<?php
if ( ! defined( 'ABSPATH' ) ) exit;
if ( ! defined( 'thpeddup-cartpopup-main-wporg' ) ) exit;

define ( 'thpeddup-cartpopup-popup-wporg', TRUE );

function thpeddup_atc_btn_popup() {
	$product_id = filter_input( INPUT_GET, 'prod_id', FILTER_SANITIZE_NUMBER_INT );
	
	if ( ( ctype_digit($product_id) ) && ($product_id > 0) )
		$product_id = $product_id;
	else
		$product_id = '';
	
	$popup = thpeddup_render_popup($product_id);
	
	echo $popup;
	die();
}
add_action('wp_ajax_nopriv_thpeddup_atc_btn_popup', 'thpeddup_atc_btn_popup');
add_action('wp_ajax_thpeddup_atc_btn_popup', 'thpeddup_atc_btn_popup');


function thpeddup_render_popup($product_id) {
	
	if (thpeddup_edduppro_is_active() && thpeddup_pro_prosettings_is_active()) {
		$thpeddup_pro_options = ( !empty(get_option( 'thpeddup_pro_options' )) ? get_option( 'thpeddup_pro_options' ) : '' );
		$global_popup = ( !empty($thpeddup_pro_options['enable_popup_global']) ? $thpeddup_pro_options['enable_popup_global'] : '' );
		
		if (!$global_popup)
			return;
	}
	else {
		$single_popup = get_post_meta($product_id, 'thpeddup_enable_popup', true);
	
		if (!$single_popup)
			return;
	}
	
	$upcrossitems_IDs = array();
	
	if (thpeddup_edduppro_is_active() && thpeddup_pro_prosettings_is_active()) {
		$upcrossitems_IDs = thpeddup_pro_get_global_upcross_items();
		$upcrossitems_IDs = array_diff($upcrossitems_IDs, array($product_id));
	}
	else {	
		$upcrossitems_IDs = get_post_meta($product_id, 'thpeddup_upcross_select', true);
	}
	
	if (!$upcrossitems_IDs)
		return;
	
	$upcrossitems_IDs = array_filter( array_unique($upcrossitems_IDs) );
	
	$popup = '';
	
	ob_start();
	include ( plugin_dir_path( __FILE__ ).'templates/template-default.php' );
	$popup = ob_get_clean();
	
	return $popup;
}