<?php
/**
 * Plugin Name: Upsell Cross-sell In Cart and Popup for EDD
 * Plugin URI: https://edd.upsell-crosssell.com/
 * Description: This is an upsell and cross-sell plugin for Easy Digital Downloads. Upsell and cross-sell on your EDD store on cart or checkout page, or with popup.
 * Version: 0.1.5
 * Author: 10Horizons Plugins
 * Author URI: https://10horizonsplugins.com
 * Text Domain: edd-upsell-cross-sell-in-cart-and-popup
 */

if ( ! defined( 'ABSPATH' ) ) exit;
define ( 'thpeddup-cartpopup-main-wporg', TRUE );

include ( 'checkout.php' );
include ( 'popup.php' );

function thpeddup_edd_is_inactive() {
	if ( ! function_exists('is_plugin_inactive')) {
	    require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
	}
	
	if( is_plugin_inactive( 'easy-digital-downloads/easy-digital-downloads.php' ) ) {
		return true; //edd is inactive
	}
return false;
}


function thpeddup_edduppro_is_active() {
	if ( ! function_exists('is_plugin_active')) {
	    require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
	}
	
	if( is_plugin_active( 'edd-upsell-cross-sell-in-cart-and-popup-pro/index.php' ) ) {
		return true;
	}
return false;
}


function thpeddup_activation_check() {
	if ( thpeddup_edd_is_inactive() ) {
		deactivate_plugins( plugin_basename( __FILE__ ) );
		wp_die( __( "Upsell Cross-sell In Cart and Popup for EDD requires Easy Digital Downloads to work properly. Please install and activate Easy Digital Downloads before trying to activate this plugin again.", 'edd-upsell-cross-sell-in-cart-and-popup' ) );
	}
}
register_activation_hook( __FILE__, 'thpeddup_activation_check' );


function thpeddup_requirement_check() {
	if ( thpeddup_edd_is_inactive() ) {
	   add_action( 'admin_notices', 'thpeddup_dependency_warning' );
	   return;
	}
	
	$redirection = edd_get_option( 'redirect_on_add', false );
	
	if ($redirection)
		add_action( 'admin_notices', 'thpeddup_edd_setting_req_warning' );
	
	load_plugin_textdomain( 'edd-upsell-cross-sell-in-cart-and-popup', false, basename( dirname( __FILE__ ) ) . '/languages' );
}
add_action( 'plugins_loaded', 'thpeddup_requirement_check' );


function thpeddup_dependency_warning() {
	?>
	<div class="notice notice-error">
		<p><?php _e( "Upsell Cross-sell In Cart and Popup for EDD requires Easy Digital Downloads plugin to work properly!", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></p>
	</div>
	<?php
}


function thpeddup_edd_setting_req_warning() {
	?>
	<div class="notice notice-warning is-dismissible">
		<p><?php _e( "Please disable redirection to checkout if you want upsell/cross-sell popups to work correctly. Ignore this if you are not using upsell/cross-sell popups.", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></p>
	</div>
	<?php
}


function thpeddup_admin_scripts_enqueuing( $hook ) {
	global $post;
	
	if ( ($hook == 'post-new.php' &&  'download' === $post->post_type) || ($hook == 'post.php' && 'download' === $post->post_type) || ($hook == 'download_page_thpeddup-pro-main-settings') ) {
		wp_enqueue_style( 'thpeddup-admin-css', plugin_dir_url( __FILE__ ).'css/eddup-admin-style.min.css' );
	}
	
	if ( ($hook == 'post-new.php' &&  'download' === $post->post_type) || ($hook == 'post.php' && 'download' === $post->post_type) || ($hook == 'download_page_thpeddup-pro-main-settings' && thpeddup_edduppro_is_active()) ) {
		
		if (! wp_script_is( 'select2-css', 'enqueued' ))
			wp_enqueue_style( 'select2-css', plugin_dir_url( __FILE__ ).'css/select2.min.css' );
		
		if (! wp_script_is( 'select2-js', 'enqueued' ))
			wp_enqueue_script( 'select2-js', plugin_dir_url( __FILE__ ).'js/select2.min.js', array( 'jquery' ), '4.1.0-rc.0', true );
		
		wp_enqueue_script( 'thpeddup-admin-js', plugin_dir_url( __FILE__ ).'js/eddup-metabox-select.min.js', array( 'jquery' ), false, true );
		wp_localize_script( 'thpeddup-admin-js', 'thpeddup_metabox_vars', array(
			'search_item' => __( 'Search for item name..', 'edd-upsell-cross-sell-in-cart-and-popup' )
		));
	}
}
add_action( 'admin_enqueue_scripts', 'thpeddup_admin_scripts_enqueuing', 10, 1 );


function thpeddup_frontend_scripts_enqueuing() {
	wp_enqueue_style( 'dashicons' );
	wp_enqueue_style( 'thpeddup-frontend-css', plugin_dir_url( __FILE__ ).'css/eddup-frontend-style.min.css' );
	wp_enqueue_script( 'thpeddup-frontend-js', plugin_dir_url( __FILE__ ).'js/eddup-frontend.min.js', array('jquery'), '', false );
	wp_localize_script( 'thpeddup-frontend-js', 'thpeddup_frontend_vars', array(
		'ajaxurl' => admin_url( 'admin-ajax.php' ),
		'fullpluginurl'  => plugin_dir_url( __FILE__ ),
		'eddcheckouturl' => edd_get_checkout_uri()
	));
}
add_action( 'wp_enqueue_scripts', 'thpeddup_frontend_scripts_enqueuing' );


function thpeddup_prodpage_meta_box_setup() {
	add_action( 'add_meta_boxes', 'thpeddup_add_meta_box' );
	add_action( 'save_post', 'thpeddup_save_meta_data', 10, 2 );
}
add_action( 'load-post.php', 'thpeddup_prodpage_meta_box_setup' );
add_action( 'load-post-new.php', 'thpeddup_prodpage_meta_box_setup' );


function thpeddup_add_meta_box() {
	add_meta_box(
		'thpeddup-conf-metabox', // ID
		esc_html__( 'Upsell Cross-sell In Cart and Popup', 'edd-upsell-cross-sell-in-cart-and-popup' ), // title
		'thpeddup_meta_box_content', // callback function
		'download', // screen
		'normal', // context (normal, side, advanced)
		'high' // priority (high, core, default, low)
	);
}


function thpeddup_meta_box_content( $object, $box ) {
	
	wp_nonce_field( 'thpeddup-update-metabox-action', 'thpeddup_metabox_nonce' ); ?>
	
	<div class="thpeddup-conf-container">
		
		<div class="thpeddup-conf-section">
			
			<div class="thpeddup-conf-title"><?php _e( "Upsell/Cross-sell Items", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></div>
			
			<p>
				<?php _e( "Set up the upsell/cross-sell items for this download:", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?>
			</p>
			
			<p>
			<select class="thpeddup-upcross-select" name="thpeddup_upcross_select[]" multiple="multiple">
				<?php 
				$upcross_values = get_post_meta($object->ID, 'thpeddup_upcross_select', true);
				if ($upcross_values) {
					foreach ($upcross_values as $upcross_value) {
						echo '<option selected="selected" value="'.esc_attr($upcross_value).'">'.get_the_title( $upcross_value ).' (ID:'.esc_attr($upcross_value).')</option>';
					}
				}
				?>
			</select>
			</p>
			
		</div><!-- .thpeddup-conf-section -->
		
		<div class="thpeddup-conf-section">
		
			<div class="thpeddup-conf-title"><?php _e( "Popup", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></div>
			
			<p>
				<input type="checkbox" name="thpeddup_enable_popup" value="1" <?php checked( '1', get_post_meta( $object->ID, 'thpeddup_enable_popup', true ) ); ?>>
				<?php _e( "Enable upsell/cross-sell popup after download is added to cart?", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?>
			</p>
			
			<p>
				<p><label for="thpeddup_popup_heading"><?php _e( "Heading to show:", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></label></p>
				
				<p>
					<?php 
					$popup_heading = get_post_meta($object->ID, 'thpeddup_popup_heading', true);
					?>
					<input name="thpeddup_popup_heading" type="text" value="<?php echo ($popup_heading ? esc_attr($popup_heading) : ''); ?>" class="thpeddup-metabox-text regular-text">
				</p>
				
				<?php
				if (!thpeddup_edduppro_is_active()) { ?>
				<div style="padding-top: 10px; padding-bottom: 5px; font-style: italic;">&ast;
					<?php
						$pro_url = 'https://edd.upsell-crosssell.com/wordpress-plugin/upsell-cross-sell-in-cart-and-popup-for-edd-pro/';
						$upgrade_note_1 = sprintf( wp_kses( __( 'You can set these options globally (sitewide) if you <a href="%s">upgrade to PRO</a>!', 'edd-upsell-cross-sell-in-cart-and-popup' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $pro_url ) );
						echo $upgrade_note_1;
					?>
				</div>
				<?php } ?>
			</p>
			
		</div><!-- .thpeddup-conf-section -->
		
		<div class="thpeddup-conf-section">
		
			<div class="thpeddup-conf-title"><?php _e( "Checkout/Cart Page", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></div>
			
			<p>
				<input type="checkbox" name="thpeddup_enable_checkout_page" value="1" <?php checked( '1', get_post_meta( $object->ID, 'thpeddup_enable_checkout_page', true ) ); ?>>
				
				<?php _e( "Enable these upsell/cross-sell items on checkout/cart page?", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?>
			</p>
			
			<?php
			if (!thpeddup_edduppro_is_active()) { ?>
			<div style="padding-top: 10px; padding-bottom: 5px; font-style: italic;">&ast;
				<?php
					$upgrade_note_2 = sprintf( wp_kses( __( 'Enable or disable this option globally (sitewide) by <a href="%s">upgrading to PRO</a>!', 'edd-upsell-cross-sell-in-cart-and-popup' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $pro_url ) );
					echo $upgrade_note_2;
				?>
			</div>
			<?php } ?>
			
		</div><!-- .thpeddup-conf-section -->
		
		<div class="thpeddup-target-id" style="display:none;"><?php echo esc_html($object->ID); ?></div>
		
	</div><!-- .thpeddup-conf-container -->
	
<?php	
}


function thpeddup_search_items_upcross() {
	if (! current_user_can( 'manage_options' ) )
		return;
	
	ob_start();
	
	$search_term = filter_input( INPUT_GET, 'search_term', FILTER_SANITIZE_STRING );
	$current_id = filter_input( INPUT_GET, 'current_id', FILTER_SANITIZE_NUMBER_INT );
	
	if ( empty( $search_term ) )
		die();
	
	if ( ( ctype_digit($current_id) ) && ($current_id > 0) )
		$current_id = $current_id;
	else
		$current_id = '';
	
	$arg = array(
		'post_status'    => 'publish',
		'post_type'      => 'download',
		'posts_per_page' => 50,
		's'              => $search_term,
		'post__not_in'   => array( $current_id )
	);
	$the_query      = new WP_Query( $arg );
	$found_products = array();
	if ( $the_query->have_posts() ) {
		while ( $the_query->have_posts() ) {
			$the_query->the_post();
			
			$product = array(
				'id'   => get_the_ID(),
				'text' => get_the_title()
			);
			$found_products[] = $product;
		}
	}
	
	wp_reset_postdata();
	wp_send_json( $found_products );
	die();
}
add_action( 'wp_ajax_thpeddup_search_items_upcross', 'thpeddup_search_items_upcross' );


function thpeddup_save_meta_data( $post_id, $post ) {
	
	if ( !isset( $_POST['thpeddup_metabox_nonce'] ) || !wp_verify_nonce( $_POST['thpeddup_metabox_nonce'], 'thpeddup-update-metabox-action' ) )
		return $post_id;
	
	$post_type = get_post_type_object( $post->post_type );
	
	if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
		return $post_id;
	
	if (isset( $_POST['thpeddup_upcross_select'] )) {
		
		$thpeddup_upcross_ids = filter_input(INPUT_POST, 'thpeddup_upcross_select', FILTER_SANITIZE_NUMBER_INT, FILTER_REQUIRE_ARRAY);
		$thpeddup_new_upcross = array();
		
		foreach($thpeddup_upcross_ids as $thpeddup_upcross_id) {
			if ( ( ctype_digit($thpeddup_upcross_id) ) && ($thpeddup_upcross_id > 0) )
				$thpeddup_upcross_id = $thpeddup_upcross_id;
			else
				$thpeddup_upcross_id = '';
			
			$thpeddup_new_upcross[] = $thpeddup_upcross_id;
		}
		$thpeddup_new_upcross = array_filter($thpeddup_new_upcross);
	}
	else {
		$thpeddup_new_upcross = '';
	}
	
	if (isset( $_POST['thpeddup_enable_popup'] )) {
		$thpeddup_new_enable_popup = filter_input(INPUT_POST, 'thpeddup_enable_popup', FILTER_SANITIZE_NUMBER_INT);
		
		if ( ($thpeddup_new_enable_popup) && ($thpeddup_new_enable_popup != 1) )
			$thpeddup_new_enable_popup = '';
	}
	else {
		$thpeddup_new_enable_popup = '';
	}
	
	if (isset( $_POST['thpeddup_popup_heading'] )) {
		$thpeddup_new_popup_heading = filter_input(INPUT_POST, 'thpeddup_popup_heading', FILTER_SANITIZE_STRING);
		$thpeddup_new_popup_heading = substr( strip_tags($thpeddup_new_popup_heading), 0, 400 );
	}
	else {
		$thpeddup_new_popup_heading = '';
	}
	
	if (isset( $_POST['thpeddup_enable_checkout_page'] )) {
		$thpeddup_new_enable_checkout = filter_input(INPUT_POST, 'thpeddup_enable_checkout_page', FILTER_SANITIZE_NUMBER_INT);
		
		if ( ($thpeddup_new_enable_checkout) && ($thpeddup_new_enable_checkout != 1) )
			$thpeddup_new_enable_checkout = '';
	}
	else {
		$thpeddup_new_enable_checkout = '';
	}
	
	$new_values = array(
		"thpeddup_upcross_select" => $thpeddup_new_upcross,
		"thpeddup_enable_popup" => $thpeddup_new_enable_popup,
		"thpeddup_popup_heading" => $thpeddup_new_popup_heading,
		"thpeddup_enable_checkout_page" => $thpeddup_new_enable_checkout
	);
	
	foreach ($new_values as $key => $new_value) {
		$old_value = get_post_meta( $post_id, $key, true );
		
		if ( $new_value && '' == $old_value ) {
			add_post_meta( $post_id, $key, $new_value, true );
		}
		elseif ( $new_value && $new_value != $old_value ) {
			update_post_meta( $post_id, $key, $new_value );
		}
		elseif ( '' == $new_value && $old_value ) {
			delete_post_meta( $post_id, $key, $old_value );
		}
	}
}


function thpeddup_promo_admin_menu() {
	
	if (thpeddup_edduppro_is_active())
		return;
	
	add_submenu_page( 'edit.php?post_type=download', __( 'Upsell Cross-sell In Cart and Popup Settings', 'edd-upsell-cross-sell-in-cart-and-popup' ), __( 'Upsell/Cross-sell', 'edd-upsell-cross-sell-in-cart-and-popup' ), 'manage_options', 'thpeddup-pro-main-settings', 'thpeddup_promo_settings' );
}
add_action( 'admin_menu', 'thpeddup_promo_admin_menu', 99 );


function thpeddup_promo_settings() {
	if (thpeddup_edduppro_is_active())
		return;
?>

<div class="wrap">

	<h1><?php _e( "Upsell Cross-sell In Cart and Popup Settings (PRO)", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></h1>
	
	<h3><?php _e( "Global", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></h3>
	
	<p><?php _e( "All the settings below will override the settings on single download pages. You can turn off the PRO settings below if you want to prioritize the settings on single download pages.", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></p>
	
	<div style="padding: 15px; font-style: italic; border: 1px #aaa dashed;">
		<?php
			$pro_url = 'https://edd.upsell-crosssell.com/wordpress-plugin/upsell-cross-sell-in-cart-and-popup-for-edd-pro/';
			$upgrade_note = sprintf( wp_kses( __( '<a href="%s">Upgrade to PRO</a> to unlock these settings!', 'edd-upsell-cross-sell-in-cart-and-popup' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $pro_url ) );
			echo $upgrade_note;
		?>
	</div>
	
	<table class="form-table" role="presentation">
		<tbody>
		
		<tr>
		<th scope="row"><?php _e( "Activation:", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></th>
		<td>
			<label for="promo9">
			<input type="checkbox" id="promo9" name="promo9" value="1" disabled>
			<?php _e( "Turn on PRO settings?", 'upsell-crosssell-cart-popup-edd-pro' ); ?>
			</label>
		</td>
		</tr>
		
		<tr>
		<th scope="row"><?php _e( "Upsell/Cross-sell Items:", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></th>
		<td class="thpeddup-globsetting-items-col">
			<p class="description"><?php _e( "Set up the upsell/cross-sell items to be used for the whole site", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></p>
			
			<p>
				<label for="promo1">
				<input type="checkbox" id="promo1" name="promo1" value="1" disabled>
				<?php _e( "Let me search and choose items manually:", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?>
				</label>
			</p>
			
			<p>
			<select class="thpeddup-upcross-select" name="promo2" disabled></select>
			</p>
			
			<p>
				<label for="promo3">	
				<input type="checkbox" id="promo3" name="promo3" value="1" disabled>
				<?php _e( "Use all items from the following category:", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?>
				</label>
			</p>
			
			<p>
			<select id="promo4" name="promo4" disabled>
				<?php
				$download_categories = get_terms( ['taxonomy' => 'download_category'] );
				
				if ($download_categories) {
					foreach ($download_categories as $download_category) {
						echo '<option value="'.$download_category->term_id.'">'.$download_category->name.'</option>';
					}
				}
				?>
			</select>
			</p>
		</td>
		</tr>
		
		<tr>
		<th scope="row"><?php _e( "Popup:", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></th>
		<td>
			<label for="promo5">
			<input type="checkbox" id="promo5" name="promo5" value="1" disabled>
			<?php _e( "Enable upsell/cross-sell popup after download is added to cart?", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?>
			</label>
		</td>
		</tr>
		
		<tr>
		<th scope="row"><label for="promo6"><?php _e( "Heading:", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></label></th>
		<td>
			<input name="promo6" type="text" value="" class="regular-text" disabled>
			<p class="description"><?php _e( "Heading to show on popups", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></p>
		</td>
		</tr>
		
		<tr>
		<th scope="row"><?php _e( "Checkout/Cart:", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></th>
		<td>
			<label for="promo7">
			<input type="checkbox" id="promo7" name="promo7" value="1" disabled>
			<?php _e( "Enable upsell/cross-sell items to be shown on checkout/cart page?", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?>
			</label>
		</td>
		</tr>
		
		<tr>
		<th scope="row"><label for="promo8"><?php _e( "Heading:", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></label></th>
		<td>
			<input name="promo8" type="text" value="" class="regular-text" disabled>
			<p class="description"><?php _e( "Heading to show on checkout/cart page", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></p>
		</td>
		</tr>
		
		</tbody>
	</table>
	
	<div style="padding: 15px; font-style: italic; border: 1px #aaa dashed;">
		<?php echo $upgrade_note; ?>
	</div>
	
	<p>
		<input class="button-primary" type="submit" name="Submit" value="<?php _e( "Save Settings", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?>" disabled />
	</p>

</div><!-- .wrap -->
<?php
}