<?php
if ( ! defined( 'ABSPATH' ) ) exit;
if ( ! defined( 'thpeddup-cartpopup-main-wporg' ) ) exit;

function thpeddup_show_upcross_items_at_checkout() {
	
	$cart_contents = edd_get_cart_contents();
	
	if ( empty( $cart_contents ) )
		return;
	
	if (thpeddup_edduppro_is_active() && thpeddup_pro_prosettings_is_active()) {
		$thpeddup_pro_options = ( !empty(get_option( 'thpeddup_pro_options' )) ? get_option( 'thpeddup_pro_options' ) : '' );
		$global_checkout = ( !empty($thpeddup_pro_options['enable_cart_global']) ? $thpeddup_pro_options['enable_cart_global'] : '' );
		
		if (!$global_checkout)
			return;
	}
	
	$upcrossitems_IDs = array();
	$cartitem_IDs = array();
	
	foreach ( $cart_contents as $item ) {
		$cartitem_ID = $item['id'];
		
		if (thpeddup_edduppro_is_active() && thpeddup_pro_prosettings_is_active()) {
			$upcross_select = thpeddup_pro_get_global_upcross_items();
		}
		else {
			$upcross_checkout_enabled = get_post_meta( $cartitem_ID, 'thpeddup_enable_checkout_page', true );
			
			if ($upcross_checkout_enabled) {
				$upcross_select = (array) get_post_meta( $cartitem_ID, 'thpeddup_upcross_select', true );
			}
			elseif (!$upcross_checkout_enabled) {
				$upcross_select = array();
			}
		}
		
		$upcrossitems_IDs = array_merge($upcrossitems_IDs, $upcross_select);
		$cartitem_IDs[] = $cartitem_ID;
	}
	
	$upcrossitems_IDs = array_unique($upcrossitems_IDs);
	$upcrossitems_IDs = array_filter( array_diff($upcrossitems_IDs, $cartitem_IDs) );
	
	if ( empty( $upcrossitems_IDs ) )
		return;
	?>
	
	<div class="thpeddup-upcross-display-main">
		<h3>
			<?php
			if ( thpeddup_edduppro_is_active() && thpeddup_pro_prosettings_is_active() && !empty($thpeddup_pro_options['cart_heading']) ) {
				echo esc_html($thpeddup_pro_options['cart_heading']);
			}
			else {
				_e( "Recommended for you:", 'edd-upsell-cross-sell-in-cart-and-popup' );
			}
			?>
		</h3>
	<?php
	foreach ($upcrossitems_IDs as $upcrossitem_ID) { ?>
		
		<div class="thpeddup-upcross-display-container">
			
			<div class="thpeddup-display-left">
				<div class="thpeddup-left-left">
					<a href="<?php echo get_permalink( $upcrossitem_ID ); ?>">
					<?php 
					if ( has_post_thumbnail( $upcrossitem_ID ) )
						echo get_the_post_thumbnail( $upcrossitem_ID, array( 70, 70) );
					else
						echo '<img src="'.plugin_dir_url( __FILE__ ).'images/download_icon_default.png" alt="thumbnail" style="width:70px;" />';
					?>
					</a>
					<a href="<?php echo get_permalink( $upcrossitem_ID ); ?>"><?php echo get_the_title( $upcrossitem_ID ); ?></a>
				</div>
				<div class="thpeddup-popup-price-wrap">
					<?php 
					if ( edd_has_variable_prices( $upcrossitem_ID ) ) {
						$prices = edd_get_variable_prices( $upcrossitem_ID );
						if( $prices ) {
							echo '<select id="thpeddup-popup-select-priceid">';
							foreach( $prices as $price_id => $price ) {
								echo '<option value="'.$price_id.'">' . $price['name'] . ' : ' . edd_currency_filter($price['amount']) . '</option>';
							}
							echo '</select>';
						}
					}
					else {
						edd_price( $upcrossitem_ID );
					}
					?>
				</div>
			</div>
			
			<form class="thpeddup-checkout-form" method=post>
				<div class="thpeddup-display-right">
					<input class="thpeddup-atc-btn" name="thpeddup-atc-btn" type="submit" value="" />
					<input class="thpeddup-hidden-upcross-id" name="thpeddup-hidden-upcross-id" type="hidden" value="<?php echo esc_attr($upcrossitem_ID); ?>">
				</div>
			</form>
			
		</div><!-- .thpeddup-upcross-display-container -->
	<?php
	} ?>
	</div><!-- .thpeddup-upcross-display-main -->
	<?php
}
add_action( 'edd_after_checkout_cart', 'thpeddup_show_upcross_items_at_checkout' );


function thpeddup_addtocart_btn_action() {
	
	$upcross_id = '';
	
	if ( isset($_GET['upcross_id']) ) {
		$upcross_id = filter_input( INPUT_GET, 'upcross_id', FILTER_SANITIZE_NUMBER_INT );
		
		if ( ( ctype_digit($upcross_id) ) && ($upcross_id > 0) )
			$upcross_id = $upcross_id;
		else
			$upcross_id = '';
	}
	
	if (! $upcross_id)
		return;
	
	$var_price_id = '';
	
	if ( isset($_GET['var_price_id']) ) {
		$var_price_id = filter_input( INPUT_GET, 'var_price_id', FILTER_SANITIZE_NUMBER_INT );
		
		if ( ( ctype_digit($var_price_id) ) && ($var_price_id > 0) )
			$var_price_id = $var_price_id;
		else
			$var_price_id = '';
	}
	
	$options = array();
	$options['price_id'] = $var_price_id;
	
	$cartkey = edd_add_to_cart($upcross_id, $options);
	
	return $cartkey;
	die();
}
add_action('wp_ajax_nopriv_thpeddup_addtocart_btn_action', 'thpeddup_addtocart_btn_action');
add_action('wp_ajax_thpeddup_addtocart_btn_action', 'thpeddup_addtocart_btn_action');
