<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function icecomaf_verify_otp_shortcode() {

    // if (!isset($_GET['user_id'])) {
    //     wp_die('Invalid request.');
    // }
    
    $user_id = isset($_GET['user_id']) && intval($_GET['user_id']) > 0 ? intval($_GET['user_id']) : 0;

    ob_start();

    if (isset($user_id)) :
    ?>
    
    <div class="ic-affiliate-form">
        <h2><?php echo esc_html__('Two-Factor Authentication', 'ecommerce-affiliate'); ?></h2>

        <form id="ic-verify-otp-form">
            <input type="hidden" name="user_id" value="<?php echo esc_attr($user_id); ?>">

            <?php wp_nonce_field('affiliate_verify_otp_nonce_action', 'affiliate_verify_otp_nonce'); ?>

            <label for="otp"><?php echo esc_html__('Enter OTP', 'ecommerce-affiliate'); ?>:</label>
            <input type="text" name="otp" id="otp" placeholder="<?php echo esc_html__('Enter OTP here.', 'ecommerce-affiliate'); ?>" required>

            <div id="ic-form-messages" style="color: red;"></div>

            <div class="ic-otp-btns">
                <button type="button" id="ic-submit-otp" class="ic_btn w-100">
                    <span class="ic_affiliate_btn_txt"><?php echo esc_html__('Verify OTP', 'ecommerce-affiliate'); ?></span>
                    <span class="ic_affiliate_spinner" style="display: none;">🔄</span>
                </button>
                <button type="button" id="ic-resend-otp" class="ic_btn">
                    <span class="ic_resend_btn_txt"><?php echo esc_html__('Resend OTP', 'ecommerce-affiliate') ?></span>
                    <span class="ic_affiliate_spinner" style="display: none;">🔄</span>
                </button>
            </div>

            <div id="otp-error" style="color: red;"></div>
        </form>
    </div>

    <?php endif;
    return ob_get_clean();
}
add_shortcode('icecomaf_affiliate_verify_otp', 'icecomaf_verify_otp_shortcode');