<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function icecomaf_affiliate_form_shortcode() {
    ob_start();
    ?>
    
    <div class="ic-affiliate-form">
        <h2><?php echo esc_html__('Affiliate Registration Form', 'ecommerce-affiliate'); ?></h2>
        <form id="ic-affiliate-register" method="post" action="">
            <?php wp_nonce_field('register_form_nonce_action', 'register_form_nonce'); ?>
            <div class="ic-form-2col">
                <div class="ic-form-group">
                    <label class="ic-form-label" for="fullname"><?php echo esc_html__('Full Name', 'ecommerce-affiliate'); ?></label>
                    <input id="fullname" name="fullname" class="ic-form-control" type="text" placeholder="<?php echo esc_html__('John Doe', 'ecommerce-affiliate'); ?>" >
                </div>
    
                <div class="ic-form-group">
                    <label class="ic-form-label" for="email"><?php echo esc_html__('Email Address', 'ecommerce-affiliate'); ?></label>
                    <input id="email" name="email" class="ic-form-control" type="email" placeholder="<?php echo esc_html__('Enter john@doe.com', 'ecommerce-affiliate') ?>" >
                </div>
            </div>

            <div class="ic-form-group">
                <label class="ic-form-label" for="affiliateID"><?php echo esc_html__('Affiliate ID', 'ecommerce-affiliate'); ?></label>
                <input id="affiliateID" name="affiliateID" class="ic-form-control" type="text" placeholder="<?php echo esc_html__('Affiliate ID (Optional)', 'ecommerce-affiliate'); ?>" >
            </div>

            <div class="ic-form-2col">
                <div class="ic-form-group">
                    <label class="ic-form-label" for="ic_reg_password"><?php echo esc_html__('Password', 'ecommerce-affiliate'); ?></label>
                    <input id="ic_reg_password" name="password" class="ic-form-control" type="password" placeholder="<?php echo esc_html__('Type password', 'ecommerce-affiliate') ?>">
                    <div id="ic_password_strength_check" class="ic_password_strength_check"></div>
                </div>
    
                <div class="ic-form-group">
                    <label class="ic-form-label" for="cpassword"><?php echo esc_html__('Confirm Password', 'ecommerce-affiliate'); ?></label>
                    <input id="cpassword" name="cpassword" class="ic-form-control" type="password" placeholder="<?php echo esc_html__('Type confirm password', 'ecommerce-affiliate') ?>">
                </div>
            </div>

            <div class="ic-payment-option">
                <h3><?php echo esc_html__('Payment Detail', 'ecommerce-affiliate'); ?></h3>
            </div>
    
            <div class="ic-affiliate-payment-row">
                <div class="ic-payment-type">
                    <div id="paypal-details" class="ic-form-group">
                        <label for="paypal_email"><?php echo esc_html__('PayPal Email', 'ecommerce-affiliate'); ?></label>
                        <input type="email" id="paypal_email" name="paypal_email" placeholder="<?php echo esc_html__('PayPal email', 'ecommerce-affiliate') ?>">
                    </div>
                </div>
            </div>

            <div class="ic_affiliate_user_consent">
                <input type="checkbox" id="ic_affiliate_consent" name="consent">
                <label for="ic_affiliate_consent">
                    <?php echo esc_html__('Accept ', 'ecommerce-affiliate'); ?> <a href="#"><?php echo esc_html__('Terms and privacy policy', 'ecommerce-affiliate'); ?></a> | <a href="#"><?php echo esc_html__('GDPR/Privacy Compliance', 'ecommerce-affiliate'); ?></a>
                </label>
            </div>

            <div class="ic_affiliate_account_exist">
                <p><?php echo esc_html__('Have you already account? ', 'ecommerce-affiliate') ?><a href="<?php echo esc_url(home_url('/affiliate-login')); ?>"><strong><?php echo esc_html__('Login here', 'ecommerce-affiliate') ?></strong></a></p>
            </div>
    
            <div id="ic-form-messages"></div>

            <div class="ic_affiliate_form_submit">
                <button type="button" id="ic-submit-register" class="ic_btn w-100">
                    <span class="ic_affiliate_btn_txt"><?php echo esc_html__('Register', 'ecommerce-affiliate'); ?></span> 
                    <span class="ic_affiliate_spinner" style="display: none;">🔄</span></span>
                </button>
            </div>
        </form>
    </div>

    <?php
    return ob_get_clean();
}
add_shortcode('icecomaf_affiliate_register_form', 'icecomaf_affiliate_form_shortcode');