<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function icecomaf_affiliate_login_form_shortcode() {
    ob_start();

    
    ?>
    
    <div class="ic-affiliate-form">
        <h2><?php echo esc_html__('Affiliate Registration Form', 'ecommerce-affiliate'); ?></h2>
        <?php  ?>
        <form id="ic-affiliate-login" method="post" action="">
            <?php wp_nonce_field('login_form_nonce_action', 'login_form_nonce'); ?>

            <!-- <div class="ic-form-2col">   -->
                <div class="ic-form-group">
                    <label class="ic-form-label" for="email"><?php echo esc_html__('Email Address', 'ecommerce-affiliate'); ?></label>
                    <input id="email" name="email" class="ic-form-control" type="email" placeholder="<?php echo esc_html__('Enter john@doe.com', 'ecommerce-affiliate') ?>" >
                </div>
                
                <div class="ic-form-group">
                    <label class="ic-form-label" for="password"><?php echo esc_html__('Password', 'ecommerce-affiliate'); ?></label>
                    <input id="password" name="password" class="ic-form-control" type="password" placeholder="<?php echo esc_html__('Type password', 'ecommerce-affiliate') ?>">
                </div>
                <div class="ic_forgot_password">
                <p><?php echo esc_html__('Don\'t have an account? ', 'ecommerce-affiliate'); ?><a href="<?php echo esc_url(home_url('/affiliate-registration')); ?>"><strong><?php echo esc_html__('Register here', 'ecommerce-affiliate') ?></strong></a></p>

                    <a href="<?php echo esc_url(site_url('/forgot-password')); ?>"><strong><?php echo esc_html__('Forgot your password?', 'ecommerce-affiliate'); ?></strong></a>
                </div>
            <!-- </div> -->

            <div id="ic-form-messages" style="color: red;"></div>

            <div class="ic_affiliate_form_submit">
                <button type="button" id="ic-submit-login" class="ic_btn w-100">
                    <span class="ic_affiliate_btn_txt"><?php echo esc_html__('Login', 'ecommerce-affiliate') ?></span> 
                    <span class="ic_affiliate_spinner" style="display: none;">🔄</span></span>
                </button>
            </div>
        </form>
    </div>

    <?php
    return ob_get_clean();
}
add_shortcode('icecomaf_affiliate_login_form', 'icecomaf_affiliate_login_form_shortcode');