<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function icecomaf_affiliate_forgot_password_shortcode() {
    

    ob_start();
    ?>
        <div class="ic-affiliate-form">
            <h2><?php echo esc_html__('Forgot Password', 'ecommerce-affiliate'); ?></h2>
            <p id="reset_password_col"></p>
            <form id="ic-forgot-password-form" method="post">
                <?php wp_nonce_field('forgot_password_nonce_action', 'forgot_password_nonce'); ?>

                <div class="ic-form-group" >
                    <label for="email"><?php echo esc_html__('Email Address', 'ecommerce-affiliate'); ?></label>
                    <input id="email" name="email" class="ic-form-control" type="email" placeholder="<?php echo esc_html__('Enter your email', 'ecommerce-affiliate'); ?>" required>
                </div>

                <div id="ic-form-messages" style="color: red;"></div>

                <div class="ic_affiliate_form_submit">
                    <button type="button" id="ic-submit-forgot-password" class="ic_btn w-100">
                        <span class="ic_affiliate_btn_txt"><?php echo esc_html__('Send Reset Link', 'ecommerce-affiliate') ?></span>
                        <span class="ic_affiliate_spinner" style="display: none;">🔄</span>
                    </button>
                </div>
            </form>
        </div>
    <?php
    return ob_get_clean();
}
add_shortcode('icecomaf_affiliate_forgot_password', 'icecomaf_affiliate_forgot_password_shortcode');