<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function icecomaf_affiliate_profile_shortcode() {
    
    if (!is_user_logged_in()) {
        return '<p class="ic_if_not_affiliate_login">You must be logged in to view this page. <a href="'.home_url('affiliate-login').'"/login><strong>Login here</strong></a></p>';
    }

    global $wpdb;
    $user_id = get_current_user_id();

    $registered_user_email = "";
    if ($user_id) {
        $registered_user_data = get_userdata($user_id);
        $registered_user_email = $registered_user_data->user_email;
    }

    $table_name = esc_sql($wpdb->prefix . 'affiliate_user');
    $affiliate_data = $wpdb->get_row(
        $wpdb->prepare("SELECT * FROM {$table_name} WHERE user_id = %d", $user_id)
    );

    if (!$affiliate_data) {
        return '<p>No affiliate data found for this user.</p>';
    }

    $affiliate_link = home_url('?ref=' . $affiliate_data->affiliate_id);

    ob_start();
    ?>
    
    <div class="ic-affiliate-profile">
        <div class="ic_affilite_phead">
            <div><h3><?php echo esc_html__('Affiliate Profile', 'ecommerce-affiliate'); ?></h3></div>
            <div>
                <?php 
                    if (is_user_logged_in() && in_array('affiliate_user', (array) wp_get_current_user()->roles)) :
                        ?>
                            <button id="ic_affiliate_logout" class="ic_btn">
                                <span id="ic_affiliate_logout_txt"><?php echo esc_html__('Logout', 'ecommerce-affiliate'); ?></span>
                                <span class="ic_affiliate_spinner" style="display: none;">🔄</span>
                                <span class="ic_affiliate_signout"><i class="fa fa-sign-out"></i></span>
                            </button>
                        <?php
                    endif;
                ?>
            </div>
        </div>

        <?php require_once ICECOMAF_PLUGIN_DIR . 'inc/registered-affiliates/affiliates_userinfo.php'; ?>

        <?php require_once ICECOMAF_PLUGIN_DIR . 'inc/registered-affiliates/affiliates_order_history.php'; ?>

        <?php require_once ICECOMAF_PLUGIN_DIR . 'inc/registered-affiliates/affiliates_payments.php'; ?>
        
    </div>

    <?php
    return ob_get_clean();
}
add_shortcode('icecomaf_affiliate_profile', 'icecomaf_affiliate_profile_shortcode');