<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

    $affiliate_id = $affiliate_data->affiliate_id;
    $total_clicks = icecomaf_get_affiliate_clicks_count($affiliate_id);
    
    $saved_profile_pic = icecomaf_get_user_profile_pic();
    $account_status = $affiliate_data->account_status;
?>

<div class="ic-affiliate-userinfo">
    <div class="ic_affiliates_profile_info">
        <h3><?php echo esc_html__('Profile information', 'ecommerce-affiliate'); ?></h3>
        <div class="ic_profile_col">
            <div class="ic_affiliate_basicinfo">
                <p><strong><?php echo esc_html__('Name', 'ecommerce-affiliate'); ?>:</strong> <?php echo esc_html(get_user_meta($user_id, 'fullname', true) ? get_user_meta($user_id, 'fullname', true) : wp_get_current_user()->user_login); ?></p>
                <p><strong><?php echo esc_html__('Email', 'ecommerce-affiliate'); ?>:</strong> <?php echo esc_html($registered_user_email); ?></p>
        
                <p style="display: flex; align-items: center; gap: 10px;"><strong><?php echo esc_html__('Affiliate Link', 'ecommerce-affiliate') ?>:</strong> <span id="ic_affiliate_link"><?php echo esc_url($affiliate_link); ?></span> <button id="icCopyAffiliateLink"><?php echo esc_html__('Copy', 'ecommerce-affiliate'); ?></button></p>
        
                <p><strong><?php echo esc_html__('Affiliate ID', 'ecommerce-affiliate'); ?>:</strong> <?php echo esc_html($affiliate_data->affiliate_id); ?></p>
                
                <p><strong><?php echo esc_html__('Affiliate Link Clicked ', 'ecommerce-affiliate') ?> </strong> <?php echo esc_html($total_clicks); ?></p>
                <p><strong><?php echo esc_html__('Account Status ', 'ecommerce-affiliate') ?> </strong> <?php echo esc_html($account_status); ?></p>
            </div>
        </div>
    </div>
</div>