<?php
    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

    global $wpdb;

    $user_id = get_current_user_id();
    $affiliate_user_table = esc_sql($wpdb->prefix . 'affiliate_user');

    $payment_detail = $wpdb->get_var(
        $wpdb->prepare(
            "SELECT payment_detail FROM $affiliate_user_table WHERE user_id = %d AND affiliate_id = %d",
            $user_id,
            $affiliate_id
        )
    );

    $due_palance = $wpdb->get_var(
        $wpdb->prepare(
            "SELECT due_balance FROM $affiliate_user_table WHERE user_id = %d AND affiliate_id = %d",
            $user_id,
            $affiliate_id
        )
    );

    $payment_data = json_decode($payment_detail, true);

    $has_bank = isset($payment_data['bank']);
    $has_paypal = isset($payment_data['paypal']);
    
    function icecomaf_view_payment_transition($status = []) {
        global $wpdb;

        if (!is_array($status)) {
            $status = [$status];
        }

        $table_payments = esc_sql($wpdb->prefix . 'affiliate_payments');

        $user_id = get_current_user_id();

        $placeholders = implode(',', array_fill(0, count($status), '%s'));

        $results_payments_pending = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT user_id, name, email, affiliate_id, payment_type, request_amount, paid_amount, due_balance, payment_status, created_at, status_updated_at 
                 FROM $table_payments 
                 WHERE user_id = %d AND payment_status IN ($placeholders) ", 
                 $user_id,
                ...$status,
            )
        );

        // error_log('amount type wise ' . $amount);

        if($results_payments_pending):
            ?>
            <table class="ic_pay_tbl">
                <thead>
                    <tr>
                        <th><?php echo esc_html__('Amount', 'ecommerce-affiliate') ?></th>
                        <th><?php echo esc_html__('Payment Type', 'ecommerce-affiliate') ?></th>
                        <th><?php echo esc_html__('Status', 'ecommerce-affiliate') ?></th>
                        <th><?php echo esc_html__('Date', 'ecommerce-affiliate') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($results_payments_pending as $item) { ?>
                        <tr>
                            <?php if($item->payment_status == 'cancel' || $item->payment_status == 'pending'): ?>
                                <td><?php echo esc_html($item->request_amount); ?></td>
                            <?php endif; ?>

                            <?php if($item->payment_status == 'full paid' || $item->payment_status == 'partial paid' || $item->payment_status == 'SUCCESS'): ?>
                                <td><?php echo esc_html($item->paid_amount); ?></td>
                            <?php endif; ?>

                            <td><?php echo esc_html($item->payment_type); ?></td>
                            
                            <td class="<?php
                                if($item->payment_status == 'pending') {
                                    echo esc_attr('ic-warning');
                                } elseif($item->payment_status == 'cancel') {
                                    echo esc_attr('ic-danger');
                                } elseif($item->payment_status == 'partial paid') {
                                    echo esc_attr('ic-info');
                                } elseif($item->payment_status == 'full paid') {
                                    echo esc_attr('ic-success');
                                } elseif($item->payment_status == 'SUCCESS') {
                                    echo esc_attr('ic-success');
                                }
                            ?>"><?php echo esc_html($item->payment_status); ?></td>

                            <?php if($item->payment_status == 'pending'): ?>
                                <td><?php echo esc_html($item->created_at); ?></td>
                            <?php endif; ?>
                            <?php if($item->payment_status == 'cancel' || $item->payment_status == 'full paid' || $item->payment_status == 'partial paid' || $item->payment_status == 'SUCCESS'): ?>
                                <td><?php echo esc_html($item->status_updated_at); ?></td>
                            <?php endif; ?>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
            
            <?php else: ?>
                <p><?php echo esc_html__('Data not found', 'ecommerce-affiliate'); ?>.</p>
            <?php 
        endif;
    }

    // payout calculation
    function icecomaf_get_paid_amount_sum($statuses = ['full paid', 'partial paid', 'SUCCESS']) {
        global $wpdb;
    
        $table_payments = esc_sql($wpdb->prefix . 'affiliate_payments');
        $user_id = get_current_user_id();
    
        if (!is_array($statuses)) {
            $statuses = [$statuses];
        }
        $placeholders = implode(',', array_fill(0, count($statuses), '%s'));
    
        $query = $wpdb->prepare(
            "SELECT SUM(paid_amount) as total_paid 
             FROM $table_payments 
             WHERE user_id = %d AND payment_status IN ($placeholders)",
            $user_id,
            ...$statuses
        );
    
        $result = $wpdb->get_var($query);
    
        return $result ? $result : 0;
    }

?>

<div class="ic_affiliates_payment_history">
    <div class="ic_payments_payout">
        <h3><?php echo esc_html__('Payments history', 'ecommerce-affiliate') ?></h3>

        <div class="ic_payments_payout_col" id="ic_payments_payout_tabs">
            <ul class="ic_payments_payout_nav">
                <li><a class="tab-link" href="#ic_payout_all"><?php echo esc_html__('All', 'ecommerce-affiliate') ?></a></li>
                <li><a class="tab-link" href="#ic_payout_pending"><?php echo esc_html__('Pending', 'ecommerce-affiliate') ?></a></li>
                <li><a class="tab-link" href="#ic_payout_cancel_request"><?php echo esc_html__('Cancel', 'ecommerce-affiliate') ?></a></li>
                <li><a class="tab-link" href="#ic_payout_success"><?php echo esc_html__('Paid', 'ecommerce-affiliate') ?></a></li>
            </ul>

            <div class="ic_payments_payout_all tab-content" id="ic_payout_all">
                <?php echo wp_kses_post(icecomaf_view_payment_transition(['pending', 'cancel', 'full paid', 'partial paid', 'SUCCESS'], 'paid_amount')); ?>
            </div>

            <div class="ic_payments_payout_pending tab-content" id="ic_payout_pending">
                <h4><?php echo esc_html__('Pending List', 'ecommerce-affiliate'); ?></h4>
                <?php echo wp_kses_post(icecomaf_view_payment_transition('pending', 'request_amount')); ?>
            </div>
            <div class="ic_payments_payout_pending tab-content" id="ic_payout_cancel_request">
                <h4><?php echo esc_html__('Cancel List', 'ecommerce-affiliate'); ?></h4>
                <?php echo wp_kses_post(icecomaf_view_payment_transition('cancel', 'request_amount')); ?>
            </div>
            <div class="ic_payments_payout_success tab-content" id="ic_payout_success">
                <h4><?php echo esc_html__('All Paid', 'ecommerce-affiliate'); ?></h4>
                <?php echo wp_kses_post(icecomaf_view_payment_transition(['full paid', 'partial paid', 'SUCCESS'], 'paid_amount')); ?>
            </div>
        </div>
    </div>

    <div class="ic_account_balance">
        <div class="ic_my_balance">
            <h3><?php echo esc_html__('Payout Balance', 'ecommerce-affiliate'); ?></h3>
            <strong>$ <?php echo wp_kses_post(icecomaf_get_paid_amount_sum()); ?></strong>
        </div>
        <div class="ic_due_balance">
            <div class="ic_due_txt">
                <h3><?php echo esc_html__('Due Balance', 'ecommerce-affiliate') ?></h3>
                <strong>$ <?php echo esc_html($due_palance); ?></strong>
            </div>
            
            <button type="button" id="ic_claim_payment" class="ic_plus_minus"><?php echo esc_html__('Claim Payment', 'ecommerce-affiliate') ?></button>
            <form id="ic_claim_payment_form" action="#">
                <?php wp_nonce_field('payment_request_nonce_action', 'payment_request_nonce'); ?>
                <div>
                    <?php if ($has_bank): ?>
                        <input type="radio" name="payment_method" value="bank" id="bank_option">
                        <label for="bank_option"><?php echo esc_html__('Bank', 'ecommerce-affiliate'); ?></label>
                    <?php endif; ?>
    
                    <?php if ($has_paypal): ?>
                        <input type="radio" name="payment_method" value="paypal" id="paypal_option">
                        <label for="paypal_option"><?php echo esc_html__('PayPal', 'ecommerce-affiliate'); ?></label>
                    <?php endif; ?>
                </div>
                <div>
                    <input type="number" id="ic_request_amount" name="request_amount" placeholder="Enter amount" min="1">
                </div>
                <div style="color: red;" id="ic_error_message"></div>
                <button id="ic_payment_request_send" type="button"><?php echo esc_html__('Send Request', 'ecommerce-affiliate'); ?></button>
            </form>
        </div>
    </div>
</div>