<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

    global $wpdb;

    // Get the current logged-in user ID
    $user_id = get_current_user_id();

    $total_commission = 0;

    // Get the affiliate data associated with the user from your custom table
    $table_name = esc_sql($wpdb->prefix . 'affiliate_user');
    $affiliate_data = $wpdb->get_row(
        $wpdb->prepare("SELECT * FROM {$table_name} WHERE user_id = %d", $user_id)
    );

    // Check if affiliate data is available for the current user
    if ($affiliate_data) {
        $affiliate_id = sanitize_text_field($affiliate_data->affiliate_id);

        // Proceed if affiliate_id is found
        if ($affiliate_id) {
            $args = [
                // 'status' => ['wc-completed', 'wc-processing'], 
                'status' => ['wc-completed'], 
                'post_type' => 'shop_order', 
                'limit' => -1, 
                'meta_query' => [
                    [
                        'key' => 'affiliate_id', 
                        'value' => $affiliate_id, 
                        'compare' => '='
                    ]
                ]
            ];

            // Get the orders
            $orders = wc_get_orders($args);

            $options_commision = get_option('settings_control_options');
            $default_number = $options_commision['default_number'] ?? 3;
        

            ?>
            <div class="ic_payment_order">
                <div class="ic_affiliates_payment_info">
                    <h3><?php echo esc_html__('Payment information', 'ecommerce-affiliate'); ?></h3>
                    <?php $payment_detail = json_decode($affiliate_data->payment_detail, true); ?>
                    <h4><?php echo esc_html__('PayPal Email', 'ecommerce-affiliate') ?> : <?php echo esc_html($payment_detail); ?></h4>
                </div>

                <div class="ic_affiliate_sales_history">
                    <div class="ic_order_history_head">
                        <div><h3><?php echo esc_html__('Order history', 'ecommerce-affiliate'); ?></h3></div>
                    </div>

                    <?php $commission_percentage = icecomaf_affiliate_commission();  ?>
                    
                    <table>
                        <thead>
                            <tr>
                                <th><?php echo esc_html__('Order ID', 'ecommerce-affiliate'); ?></th>
                                <th><?php echo esc_html__('Order Amount', 'ecommerce-affiliate'); ?></th>
                                <th><?php echo esc_html__('Commission ', 'ecommerce-affiliate'); echo '(' . esc_html($default_number).'%'. ')'; ?></th>
                                <th><?php echo esc_html__('Order created at', 'ecommerce-affiliate'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td colspan="4" style="border: 0; padding: 0;" id="ic_td_wrap_tbl">
                                    <div>
                                        <table>
                                            <tbody id="ic_order_history_data">
                                                <?php
                                                    
                                                ?>
                                                <?php if (!empty($orders)) : foreach ($orders as $order) :  
                                                    
                                                    if($order->get_meta('affiliate_id') == strtolower($affiliate_id)) {

                                                                $commission_processed = $order->get_meta('commission_processed');

                                                                $order_id = $order->get_id();
                                                                $order_total = $order->get_total();
                                                                $commission = $order_total * $commission_percentage;

                                                                if (!$commission_processed) {
                                                                    // Add to total commission
                                                                    $total_commission += $commission;
                                                        
                                                                    // Mark the commission as processed
                                                                    $order->update_meta_data('commission_processed', 1);
                                                                    $order->save();
                                                                }

                                                                ?>
                                                                    <tr>
                                                                        <td><?php echo esc_html($order_id); ?></td>
                                                                        <td><?php echo wp_kses_post( wc_price($order_total)); ?></td>
                                                                        <td><?php echo wp_kses_post($commission); ?></td>
                                                                        <td><?php echo esc_html($order->get_date_created()->date('d-m-Y')); ?></td>
                                                                    </tr>
                                                                <?php 
                                                            }
                                                        ?>
                            
                                                    <?php endforeach; ?>
                                                <?php else : ?>
                                                    <tr>
                                                        <td colspan="3"><?php echo esc_html__('No orders found.', 'ecommerce-affiliate'); ?></td>
                                                    </tr>
                                                <?php endif;

                                                    if ($total_commission > 0) {
                                                        $wpdb->query(
                                                            $wpdb->prepare(
                                                                "UPDATE $table_name 
                                                                SET due_balance = due_balance + %f 
                                                                WHERE affiliate_id = %s",
                                                                $total_commission,
                                                                $affiliate_id
                                                            )
                                                        );                                                
                                                    }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php
        } else {
            // If no affiliate_id is found
            ?>
            <div class="ic_affiliate_sales_history">
                <h3><?php echo esc_html__('Order history', 'ecommerce-affiliate'); ?></h3>
                <p><?php echo esc_html__('No affiliate ID found.', 'ecommerce-affiliate'); ?></p>
            </div>
            <?php
        }
    } else {
        // If affiliate data is not available for the user
        ?>
        <div class="ic_affiliate_sales_history">
            <h3><?php echo esc_html__('Order history', 'ecommerce-affiliate'); ?></h3>
            <p><?php echo esc_html__('No affiliate information available.', 'ecommerce-affiliate'); ?></p>
        </div>
        <?php
    }
?>
