<?php 
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// affiliate page controll restriction 
add_action('template_redirect', function () {
    $user = wp_get_current_user();

    if (is_user_logged_in() && is_page('affiliate-registration') || is_user_logged_in() && is_page('affiliate-login') || is_user_logged_in() && is_page('wp-admin') || is_user_logged_in() && is_page('my-account')) {
        if (in_array('affiliate_user', (array) $user->roles)) {
            wp_redirect(home_url('/affiliate-profile'));
            exit;
        }
    }

    if (is_user_logged_in() && !in_array('affiliate_user', $user->roles) && is_page(['affiliate-registration' , 'affiliate-login', 'affiliate-profile']) ) {
        wp_redirect(home_url()); 
        exit; 
    } 
});

// set cookie for affiliate users to track affiliate_id

add_action('init', 'icecomaf_set_affiliate_cookie');

function icecomaf_set_affiliate_cookie() {
    $cookies_options = get_option('settings_control_options');

    $cookie_time = isset($cookies_options['cookie_time']) && is_numeric(trim($cookies_options['cookie_time'])) ? (int) $cookies_options['cookie_time'] 
    : 30;

    if (isset($_GET['ref'])) {
        // Sanitize the affiliate ID using sanitize_key() to allow only letters, numbers, and underscores
        $affiliate_id = sanitize_key($_GET['ref']);
        
        // Optional: You can add a validation step to check if the affiliate ID matches a specific pattern (e.g., alphanumeric)
        if (!preg_match('/^[a-zA-Z0-9_]+$/', $affiliate_id)) {
            return; // Invalid affiliate ID format, exit function
        }

        $cookie_name = 'affiliate_id';
        $cookie_value = $affiliate_id;

        // Set the cookie expiration
        $cookie_expiration = time() + ($cookie_time * DAY_IN_SECONDS); 

        // Set the affiliate cookie
        setcookie($cookie_name, $cookie_value, $cookie_expiration, COOKIEPATH, COOKIE_DOMAIN, is_ssl(), true);
    }
}


add_action('woocommerce_thankyou', 'icecomaf_get_order_details_with_affiliate', 10, 1);

function icecomaf_get_order_details_with_affiliate($order_id) {
    // Load the order object
    $order = wc_get_order($order_id);

    if (isset($_COOKIE['affiliate_id'])) {
        $affiliate_id = sanitize_text_field($_COOKIE['affiliate_id']);

        if ($order) {
            $order->update_meta_data('affiliate_id', $affiliate_id);
            $order->save();
        }


        // $order->update_meta_data('affiliate_id', $affiliate_id);
    }

    if (!$order) {
        return;
    }

    // Get the affiliate ID from the order meta
    $affiliate_id = $order->get_meta('affiliate_id');

    // Display the affiliate ID (for debugging or reporting purposes)

    $items = $order->get_items();
    foreach ($items as $item_id => $item) {
        $product_name = $item->get_name(); 
        $quantity = $item->get_quantity(); 
        $total = $item->get_total(); 

        echo '<p>Product: ' . esc_html($product_name) . ', Quantity: ' . esc_html($quantity) . ', Total: ' . esc_html(wc_price($total)) . '</p>';
    }
}

// order by affiliate_id
function icecomaf_get_orders_by_affiliate($affiliate_id) {
    $args = [
        'status' => ['wc-completed', 'wc-processing'], 
        'limit' => -1, 
        'meta_query' => [
            [
                'key' => 'affiliate_id',
                'value' => $affiliate_id,
                'compare' => '='
            ]
        ]
    ];

    return wc_get_orders($args);
}

// click count insert to table
function icecomaf_track_affiliate_click() {
    
    if (isset($_GET['ref'])) {
        
        $affiliate_id = sanitize_text_field($_GET['ref']);

        // Ensure the affiliate ID only contains alphanumeric characters
        if (!preg_match('/^[a-zA-Z0-9_-]+$/', $affiliate_id)) {
            return;
        }

        // Define the cookie name
        $cookie_name = 'affiliate_click_' . $affiliate_id;

        if (!isset($_COOKIE[$cookie_name])) {
            global $wpdb;
            
            $table_name = esc_sql($wpdb->prefix . 'affiliate_user');

            // Prepare and execute the query to check for the affiliate ID
            $affiliate = $wpdb->get_row(
                $wpdb->prepare("SELECT * FROM $table_name WHERE affiliate_id = %s", $affiliate_id)
            );

            // If the affiliate exists in the database
            if ($affiliate) {
                $wpdb->query(
                    $wpdb->prepare(
                        "UPDATE $table_name SET clicks_count = clicks_count + 1 WHERE affiliate_id = %s",
                        $affiliate_id
                    )
                );
                
                // Set a cookie to prevent duplicate tracking within the same session (expires in 10 minutes)
                setcookie($cookie_name, '1', time() + 600, COOKIEPATH, COOKIE_DOMAIN);
            }
        }
    }
}
add_action('template_redirect', 'icecomaf_track_affiliate_click');


// retrive click count data
function icecomaf_get_affiliate_clicks_count($affiliate_id) {
    global $wpdb;
    $table_name = esc_sql($wpdb->prefix . 'affiliate_user');

    $clicks_count = $wpdb->get_var(
        $wpdb->prepare("SELECT clicks_count FROM $table_name WHERE affiliate_id = %s", $affiliate_id)
    );

    return $clicks_count ?: 0;
}

// retrive profile picture form table
function icecomaf_get_user_profile_pic() {
    global $wpdb;
    $user_id = get_current_user_id();

    $table_name = esc_sql($wpdb->prefix . 'affiliate_user');
    $profile_pic = $wpdb->get_var($wpdb->prepare(
        "SELECT profile_pic FROM $table_name WHERE user_id = %d",
        $user_id
    ));

    return $profile_pic ?: '';
}  

// account number making
function icecomaf_mask_account_number($mask_number) {
    $length = strlen($mask_number);
    if ($length <= 4) {
        return $mask_number;
    }

    $start = substr($mask_number, 0, 2);
    $end = substr($mask_number, -2);
    
    $masked = str_repeat('*', $length - 4);

    return $start . $masked . $end;
}

// commision 
function icecomaf_affiliate_commission() {
    $options_commision = get_option('settings_control_options');

    $commission_quantity = isset($options_commision['default_number']) && is_numeric(trim($options_commision['default_number'])) ? (int) $options_commision['default_number'] : 3;

    $commission_percentage = number_format(floatval($commission_quantity / 100), 2);

    return $commission_percentage;
}

// domain base name 
function icecomaf_get_base_domain_name() {
    $site_url = get_site_url(); // 
    $parsed_url = wp_parse_url($site_url); 
    $host = $parsed_url['host'] ?? ''; 

    // Remove "www." if present and split the domain
    $parts = explode('.', preg_replace('/^www\./', '', $host));

    return $parts[0] ?? '';
}


// email template
function icecomaf_email_template($headerText, $bodyContent) {
    $site_url = get_site_url();
    $parsed_url = wp_parse_url($site_url);
    $host = $parsed_url['host'] ?? '';
    $base_name = explode('.', preg_replace('/^www\./', '', $host))[0] ?? '';

    return "
    <!DOCTYPE html>
    <html>
    <head>
    </head>
    <body>
        <div class='email-container'>
            <!-- Header -->
            <div class='email-header'>
                <h1>{$base_name}</h1>
                <p>{$headerText}</p>
            </div>

            <!-- Body -->
            <div class='email-body'>
                {$bodyContent}
            </div>

            <!-- Footer -->
            <div class='email-footer'>
                <p>Thank you for using our service.</p>
                <p>&copy; " . gmdate('Y') . " {$base_name}. All rights reserved.</p>
                <p><a href='{$site_url}'>Visit our website</a></p>
            </div>
        </div>
    </body>
    </html>
    ";
}
