<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Enqueue styles and scripts for the plugin.
 */
function icecomaf_pma_enqueue_assets() {

    // Enqueue CSS and js files.
    wp_enqueue_style(
        'pma-styles', 
        ICECOMAF_PLUGIN_URL . 'assets/css/style.css', 
        array(), 
        // ICECOMAF_PLUGIN_VERSION 
        time()
    );

    // Enqueue JavaScript files.
    wp_enqueue_script(
        'pma-scripts', 
        ICECOMAF_PLUGIN_URL . 'assets/js/scripts.js', 
        array( 'jquery' ), 
        time(),
        // ICECOMAF_PLUGIN_VERSION, 
        true
    );


    

    $user_id = isset($_GET['user_id']) ? absint($_GET['user_id']) : 0;
    $current_user_id = get_current_user_id();

    wp_localize_script('pma-scripts', 'amsData', [
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('register_form_nonce_action'),
        'user_id'  => $user_id,
        'current_user_id' => $current_user_id,
        'nonce_resend_otp'    => wp_create_nonce('resend_otp_nonce_action'),
        // 'affiliates_bank_nonce' => wp_create_nonce('add_bank_info_nonce'),
        // 'affiliates_paypal_nonce' => wp_create_nonce('add_paypal_info_nonce'),
    ]);

}
add_action( 'wp_enqueue_scripts', 'icecomaf_pma_enqueue_assets' );