<?php
/**
 * Plugin Name: Ecommerce Affiliate
 * Plugin URI: https://itclanproducts.com/wp/ecommerce-affiliate
 * Description: A custom plugin that integrates with WooCommerce to provide an affiliate system for your e-commerce store.
 * Version: 1.0.0
 * Author: ITclan BD
 * Author URI: https://www.itclanbd.com
 * License: GPL-2.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: ecommerce-affiliate
 * Domain Path: /languages
 * Requires Plugins: woocommerce
 */

 if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define plugin constants.
define( 'ICECOMAF_PLUGIN_VERSION', '1.0' );
define( 'ICECOMAF_PLUGIN_DIR', plugin_dir_path( __FILE__ ) ); 
define( 'ICECOMAF_PLUGIN_URL', plugin_dir_url( __FILE__ ) ); 
define( 'ICECOMAF_UPLOAD_DIR', wp_upload_dir()['basedir'] . '/ecommerce-affiliate/' );
define( 'ICECOMAF_UPLOAD_URL', wp_upload_dir()['baseurl'] . '/ecommerce-affiliate/' );



// table create
function icecomaf_ecommerce_affiliate_create_table() {
    global $wpdb;
    
    $affiliate_payments = esc_sql($wpdb->prefix . 'affiliate_payments');
    $affiliate_user_tbl = esc_sql($wpdb->prefix . 'affiliate_user');

    if ( $wpdb->get_var( "SHOW TABLES LIKE '$affiliate_user_tbl'" ) !== $affiliate_user_tbl ) {
    
        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    
        $charset_collate = $wpdb->get_charset_collate();
    
        $affiliate_users_sql = "CREATE TABLE `$affiliate_user_tbl` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `user_id` int(11) NOT NULL,
            `affiliate_id` varchar(50) NOT NULL,
            `payment_detail` json NOT NULL,
            `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
            `clicks_count` int(11) NOT NULL DEFAULT '0',
            `profile_pic` varchar(255) NOT NULL,
            `account_status` varchar(150) NOT NULL DEFAULT 'pending',
            `paypal_account_status` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT 'pending',
            `due_balance` decimal(10,2) NOT NULL DEFAULT '0.00',
            PRIMARY KEY (`id`)
        ) $charset_collate;";
    
        dbDelta( $affiliate_users_sql );
    }
    

    if ( $wpdb->get_var( "SHOW TABLES LIKE '$affiliate_payments'" ) !== $affiliate_payments ) {
        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        
        $charset_collate = $wpdb->get_charset_collate();
    
        $affiliate_payments_sql = "CREATE TABLE `$affiliate_payments` (
            `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
            `user_id` bigint UNSIGNED NOT NULL,
            `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
            `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
            `affiliate_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
            `payment_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
            `request_amount` decimal(10,2) NOT NULL,
            `paid_amount` decimal(10,2) NOT NULL,
            `due_amount` decimal(10,2) NOT NULL,
            `due_balance` decimal(10,2) NOT NULL,
            `payment_status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
            `status_reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
            `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
            `status_updated_at` datetime DEFAULT NULL,
            PRIMARY KEY (`id`)
        ) $charset_collate;";
        
        dbDelta( $affiliate_payments_sql );
    }
}

// pages create and push title and content
function icecomaf_ecommerce_affiliate_create_pages() {
    $pages = [
        'affiliate-registration' => [
            'title'   => 'Affiliate Registration',
            'content' => '[icecomaf_affiliate_register_form]'
        ],
        'affiliate-login' => [
            'title'   => 'Affiliate Login',
            'content' => '[icecomaf_affiliate_login_form]'
        ],
        'affiliate-profile' => [
            'title'   => 'Affiliate Profile',
            'content' => '[icecomaf_affiliate_profile]'
        ],
        'verify-otp' => [
            'title'   => 'Verify otp',
            'content' => '[icecomaf_affiliate_verify_otp]'
        ],
        'forgot-password' => [
            'title'   => 'Forgot Password',
            'content' => '[icecomaf_affiliate_forgot_password]'
        ],
    ];

    foreach ( $pages as $slug => $page ) {
        $existing_page = get_page_by_path( $slug );
        if ( ! $existing_page ) {
            wp_insert_post( [
                'post_title'     => $page['title'],
                'post_name'      => $slug,
                'post_content'   => $page['content'],
                'post_status'    => 'publish',
                'post_type'      => 'page',
                'post_author'    => get_current_user_id(),
                'comment_status' => 'closed',
                'ping_status'    => 'closed',
            ] );
        }
    }
}


function icecomaf_ecommerce_affiliate_activate() {
    icecomaf_ecommerce_affiliate_create_table();

    icecomaf_ecommerce_affiliate_create_pages();
}

function icecomaf_ecommerce_affiliate_deactivate() {
    $slugs = [
        'affiliate-registration',
        'affiliate-login',
        'affiliate-profile',
    ];

    foreach ( $slugs as $slug ) {
        $page = get_page_by_path( $slug );
        if ( $page ) {
            wp_delete_post( $page->ID, true );
        }
    }
}

/**
 * Function to delete the custom table on plugin uninstall.
 */
function icecomaf_ecommerce_affiliate_delete_table() {
    global $wpdb;

    $affiliate_user_tbl = esc_sql($wpdb->prefix . 'affiliate_user');
    $affiliate_payments = esc_sql($wpdb->prefix . 'affiliate_payments');

    $wpdb->query( "DROP TABLE IF EXISTS $affiliate_user_tbl" );
    $wpdb->query( "DROP TABLE IF EXISTS $affiliate_payments" );

    icecomaf_ecommerce_affiliate_deactivate();

}

// activation hook
register_activation_hook( __FILE__, 'icecomaf_ecommerce_affiliate_activate' );

// deactivation
register_deactivation_hook( __FILE__, 'icecomaf_ecommerce_affiliate_deactivate' );

// uninstall hook
register_uninstall_hook( __FILE__, 'icecomaf_ecommerce_affiliate_delete_table' );

// FILES INCLUDE
require_once ICECOMAF_PLUGIN_DIR . 'inc/enqueue-scripts.php';
require_once ICECOMAF_PLUGIN_DIR . 'views/register.php';
require_once ICECOMAF_PLUGIN_DIR . 'views/login.php';
require_once ICECOMAF_PLUGIN_DIR . 'views/affiliate_profile.php';
require_once ICECOMAF_PLUGIN_DIR . 'views/forgot_password.php';
require_once ICECOMAF_PLUGIN_DIR . 'views/verify_otp.php';
require_once ICECOMAF_PLUGIN_DIR . 'inc/register-user.php';
require_once ICECOMAF_PLUGIN_DIR . 'inc/functions.php';
require_once ICECOMAF_PLUGIN_DIR . 'admin/menues.php';
require_once ICECOMAF_PLUGIN_DIR . 'admin/inc/callback_functions.php';
require_once ICECOMAF_PLUGIN_DIR . 'admin/inc/enqueue-admin.php';
require_once ICECOMAF_PLUGIN_DIR . 'admin/inc/admin-ajax.php';