jQuery(document).ready(function ($) {

    if($('#ic_reg_password').length > 0) {
        $('#ic_reg_password').on('input', function () {
            var password = $(this).val();
            var strengthMessage = $('#ic_password_strength_check');
            var strength = calculatePasswordStrength(password);
        
            // Show the strength message
            strengthMessage.show();
            
            // Update message and background color
            if (strength === 'weak') {
                strengthMessage.text('Very Weak').removeClass('medium strong').addClass('weak');
            } else if (strength === 'medium') {
                strengthMessage.text('Medium').removeClass('weak strong').addClass('medium');
            } else if (strength === 'strong') {
                strengthMessage.text('Strong').removeClass('weak medium').addClass('strong');
            } else {
                strengthMessage.hide();
            }
        });
        
        // Function to calculate password strength
        function calculatePasswordStrength(password) {
            if (!password) return ''; // No password
            if (password.length < 6) return 'weak'; 
            var strength = 0;
        
            if (password.match(/[a-z]/)) strength++; 
            if (password.match(/[A-Z]/)) strength++; 
            if (password.match(/[0-9]/)) strength++; 
            if (password.match(/[\W_]/)) strength++; 
        
            if (strength <= 2) return 'weak';
            if (strength === 3) return 'medium';
            if (strength >= 4) return 'strong';
        }        
    }

    function generateCaptcha() {
        const num1 = Math.floor(Math.random() * 10) + 1;
        const num2 = Math.floor(Math.random() * 10) + 1;
        const correctAnswer = num1 + num2;
    
        $('#ic-captcha-question').text(`${num1} + ${num2}`);

        $('#captcha_correct_answer').val(correctAnswer);
    }

    // register affiliate user 
    if($('#ic-affiliate-register').length > 0) {
        // generateCaptcha();

        $('#ic-submit-register').on('click', function (e) {
            e.preventDefault();

            $('#ic-form-messages').text('');

            const button = $(this);
            const form = $('#ic-affiliate-register');
            const formData = form.serialize();

            $.ajax({
                url: amsData.ajax_url,
                type: 'POST',
                data: {
                    action: 'register_affiliate_user',
                    form_data: formData,
                    register_form_nonce: $('#register_form_nonce').val(),
                },
                beforeSend: function () {
                    button.find(".ic_affiliate_spinner").show();
                    button.find('.ic_affiliate_btn_txt').text("Registering");
                },
                success: function(response) {
                    console.log('res ', response);
                    if(response.success) {
                        $('#ic-form-messages').text(response.data.message).css('color', 'green');
                    } else {
                        $('#ic-form-messages').text(response.data.message).css('color', 'red');
                    }
                    // $('#ic-form-messages').text(response.data.message);
                    button.find(".ic_affiliate_spinner").hide();
                    button.find('.ic_affiliate_btn_txt').text("Register");

                    if(response.success) {
                        $('#ic-affiliate-register')[0].reset(); 
                    }
                },
                error: function() {
                    $('#ic-form-messages').text('Error submitting form. Please try again later.');
                }
            });
        })
    }

    // login affiliate user
    if($('#ic-affiliate-login').length > 0){

        $('#ic-submit-login').click(function(e){
            e.preventDefault(); 

            $('#ic-form-messages').text('');
            
            var email = $('#email').val();
            var affiliateID = $('#affiliateID').val();
            var password = $('#password').val(); 
    
            var data = {
                action: 'affiliate_login', 
                email: email,
                // affiliateID: affiliateID,
                password: password,
                login_form_nonce: $('#login_form_nonce').val() 
            };
    
            $('#ic-submit-login .ic_affiliate_btn_txt').text("Logging");
            $('#ic-submit-login .ic_affiliate_spinner').show();
    
            $.ajax({
                url: amsData.ajax_url, 
                type: 'POST',
                data: data,
                success: function(response) {
                    if (response.success) {
                        // console.log('redi ', response);
                        window.location.href = response.data.redirect_url;
                    } else {
                        $('#ic-form-messages').text(response.data.message);
                    }
    
                    $('#ic-submit-login .ic_affiliate_spinner').hide();
                    $('#ic-submit-login .ic_affiliate_btn_txt').text("Login");
                },
                error: function() {
                    $('#ic-form-messages').text("Error submitting form. Please try again later.");
                    $('#ic-submit-login .ic_affiliate_spinner').hide();
                    $('#ic-submit-login .ic_affiliate_btn_txt').text("Login");
                }
            });
        });
    }

    // affiliate link copy
    if ($('#icCopyAffiliateLink').length > 0) {
        $('#icCopyAffiliateLink').click(function(e) {
            e.preventDefault();

            var affiliateLink = $('#ic_affiliate_link').text();

            var tempInput = $('<input>');
            $('body').append(tempInput);
            tempInput.val(affiliateLink).select();

            try {
                var successful = document.execCommand('copy');
                if (successful) {
                    $('#icCopyAffiliateLink').text('Copied');
                    alert('Affiliate link copied to clipboard!');
                } else {
                    alert('Failed to copy the affiliate link. Please try again.');
                }
            } catch (err) {
                alert('Failed to copy the affiliate link. Please try again.');
            }
            tempInput.remove();
        });
    }

    // lougt ajax
    if(('#ic_affiliate_logout').length > 0) {
        $('#ic_affiliate_logout').on('click', function () {
            
            $('#ic_affiliate_logout_txt').text("Logging out...");
            $('#ic_affiliate_logout .ic_affiliate_spinner').show();
            $('.ic_affiliate_signout').hide();
    
            $.ajax({
                url: amsData.ajax_url,
                type: 'POST',
                data: {
                    action: 'ic_affiliate_logout'
                },
                success: function (response) {
                    // console.log(response.data.redirect_url);
                    window.location.href = response.data.redirect_url;

                    $('#ic_affiliate_logout .ic_affiliate_spinner').hide();
                    $('.ic_affiliate_signout').show();
                },
                error: function () {
                    alert('Error logging out. Please try again.');
                    $('#ic_affiliate_logout_txt').text("Logout");
                }
            });
        });
    }

    // forgot password ajax
    if(('#ic-forgot-password-form').length > 0) {
        $('#ic-submit-forgot-password').click(function (e) {
            e.preventDefault();
    
            var email = $('#email').val();
            var nonce = $('#forgot_password_nonce').val();
    
            // Show spinner and disable button
            $('#ic-submit-forgot-password .ic_affiliate_btn_txt').text('Sending...');
            $('#ic-submit-forgot-password .ic_affiliate_spinner').show();
    
            $.ajax({
                url: amsData.ajax_url,
                type: 'POST',
                data: {
                    action: 'ic_forgot_password',
                    email: email,
                    forgot_password_nonce: nonce
                },
                success: function (response) {
                    if (response.success) {
                        // alert(response.data.message);
                        $('#reset_password_col').text(response.data.message);
                        $('#ic-forgot-password-form').hide();

                        // window.location.href = site_url + '/login';
                    } else {
                        $('#ic-form-messages').text(response.data.message);
                    }
                    $('#ic-submit-forgot-password .ic_affiliate_btn_txt').text('Send Reset Link');
                    $('#ic-submit-forgot-password .ic_affiliate_spinner').hide();
                },
                error: function () {
                    $('#ic-form-messages').text('Error processing your request. Please try again.');
                    $('#ic-submit-forgot-password .ic_affiliate_btn_txt').text('Send Reset Link');
                    $('#ic-submit-forgot-password .ic_affiliate_spinner').hide();
                }
            });
        });
    }

    // Verify OTP
    if($('#ic-verify-otp-form').length > 0) {
        $('#ic-submit-otp').click(function(e) {
            e.preventDefault(); 
            
            var otp = $('#otp').val();
            var userId = amsData.user_id; 
            
            $('#ic-form-messages').text('');
            
            var data = {
                action: 'affiliate_verify_otp',
                otp: otp,
                user_id: userId,
                affiliate_verify_otp_nonce: $('#affiliate_verify_otp_nonce').val(),
            };
    
            $('#ic-submit-otp .ic_affiliate_btn_txt').text("Verifying...");
            $('#ic-submit-otp .ic_affiliate_spinner').show();
    
            $.ajax({
                url: amsData.ajax_url,
                type: 'POST',
                data: data,
                success: function(response) {
                    if (response.success) {
                        window.location.href = response.data.redirect_url;
                    } else {
                        $('#ic-form-messages').text(response.data.message).css('color', 'red');
                    }
                    $('#ic-submit-otp .ic_affiliate_spinner').hide();
                    $('#ic-submit-otp .ic_affiliate_btn_txt').text("Verify OTP");
                },
                error: function() {
                    $('#ic-form-messages').text("Error verifying OTP. Please try again later.");
                    $('#ic-submit-otp .ic_affiliate_spinner').hide();
                    $('#ic-submit-otp .ic_affiliate_btn_txt').text("Verify OTP");
                }
            });
        });
    }

    // verify resend otp
    if($('#ic-resend-otp').length > 0) {
        $('#ic-resend-otp').click(function (e) {
            e.preventDefault();

            $('#ic-form-messages').text('');
    
            var userId = amsData.user_id; 
    
            var data = {
                action: 'resend_otp',
                user_id: userId,
                resend_nonce: amsData.nonce_resend_otp, 
            };
    
            $('#ic-resend-otp .ic_resend_btn_txt').text("Resending...");
            $('#ic-resend-otp .ic_affiliate_spinner').show();
    
            $.ajax({
                url: amsData.ajax_url,
                type: 'POST',
                data: data,
                success: function (response) {
                    if (response.success) {
                        $('#ic-form-messages').text(response.data.message).css('color', 'green');
                    } else {
                        $('#ic-form-messages').text(response.data.message).css('color', 'red');
                    }
    
                    $('#ic-resend-otp .ic_affiliate_spinner').hide();
                    $('#ic-resend-otp .ic_resend_btn_txt').text("Resend OTP");
                },
                error: function () {
                    $('#ic-form-messages').text("Error resending OTP. Please try again later.").css('color', 'red');
                    $('#ic-resend-otp .ic_affiliate_spinner').hide();
                    $('#ic-resend-otp .ic_resend_btn_txt').text("Resend OTP");
                }
            });
        });
    }

    // affiliate profile banin info input
    if($('#ic_add_bank_detail_btn').length > 0) {
        $('#ic_add_bank_detail_btn').on('click', function (e) {
            e.preventDefault();
            $('#bank-details').slideToggle();
        });
    }

    // affiliate profile paypal info input
    if($('#ic_paypal_add').length > 0) {
        $('#ic_paypal_add').on('click', function (e) {
            e.preventDefault();
            $('#paypal-details').slideToggle();
            $(this).toggleClass('ic-expand')
        });
    }

    if($('#ic_registered_papal_add_btn').length > 0) {
        $('#ic_registered_papal_add_btn').on('click', function (e) {
            e.preventDefault();

            const formData = {
                action: 'update_paypal_details',
                paypal_email: $('#paypal_email').val(),
                current_user_id: amsData.current_user_id,
                add_paypal_info_nonce: $('#add_paypal_info_nonce').val()
            };

            console.log('form data ', formData);

            $('#ic_registered_papal_add_btn').text("Submitting...");

            $.ajax({
                url: amsData.ajax_url, 
                type: 'POST',
                data: formData,
                success: function (response) {
                    console.log('res ', response);

                    if (response.success) {
                        $('#ic_form_messages').text(response.data.message).css('color', 'green');
                    } else {
                        $('#ic_form_messages').text(response.data.message).css('color', 'red');
                    }

                    $('#ic_registered_papal_add_btn').text("Submit");
                },
                error: function () {
                    $('#ic_form_messages').text(response.data.message).css('color', 'red');
                    $('#ic_registered_papal_add_btn').text("Submit");
                },
            });

        });
    }

    // payment request
    if($('#ic_payment_request_send').length > 0) {

        $('#ic_payment_request_send').on('click', function () {
            var formData = $('#ic_claim_payment_form').serialize(); 
            var nonce = $('#payment_request_nonce').val(); 

            $('.ic_account_balance').addClass('ic-payment-loading');
            $('#ic_error_message').text('');
    
            $.ajax({
                url: amsData.ajax_url, 
                type: 'POST',
                data: {
                    action: 'ic_claim_payment',
                    payment_request_nonce: nonce,
                    form_data: formData
                },
                success: function (response) {
                    console.log(response); 
                    if (response.success) {
                        alert(response.data.message);
                        window.location.reload();
                    } else {
                        $('#ic_error_message').text(response.data.message);
                        // alert(response.data.message);
                    }

                    $('.ic_account_balance').removeClass('ic-payment-loading');
                },
                error: function () {
                    alert('An error occurred. Please try again.');
                }
            });
        });
    }
    
});

jQuery(document).ready(function ($) {
    // claim payment
    if($('#ic_claim_payment').length > 0) {
        $('#ic_claim_payment_form').hide();
        $('#ic_claim_payment').on('click', function(e) {
            e.preventDefault();

            $(this).toggleClass('ic-expand')

            $('#ic_claim_payment_form').slideToggle();
        })
    }

    if($('#ic_payments_payout_tabs').length > 0) {
        // console.log('test balsdkfj');

        $('.tab-content').hide();
        $('.tab-content:first').show();
    
        // Add active class to the first tab
        $('.ic_payments_payout_nav li:first a').addClass('active');
    
        // Tab click event
        $('.tab-link').on('click', function (e) {
            e.preventDefault(); // Prevent the default anchor click behavior
    
            // Remove active class from all tabs
            $('.tab-link').removeClass('active');
    
            // Add active class to the clicked tab
            $(this).addClass('active');
    
            // Hide all tab content
            $('.tab-content').hide();
    
            // Show the corresponding tab content
            var target = $(this).attr('href');
            $(target).fadeIn();
        });
    }

    // paypal account verification
    // if($('#ic_claim_paypal_verify').length > 0) {
    //     $('#ic_claim_paypal_verify').on('click', function () {
    //         const clientId = 'ActdCa4Zmmkfe0tY6UetDJ6CCxu7y_f-lFqnsbKALXCfz0RAQurkiiDuu1MQqs1_hdxwXzyzrxRFGHl0';
    //         const redirectUri = 'http://paylessminisplit.test/affiliate-profile?code=AUTH_CODE'; // Replace with your callback URL
    //         const paypalAuthUrl = `https://www.sandbox.paypal.com/signin?intent=connect&ctxId=connect%3A930dc88db88446f689aceb97271f248f&returnUri=https%3A%2F%2Fwww.sandbox.paypal.com%2Fidapps%2Fconnect%2Fconsent%3FctxId%3DAAGCl87F1OiJ7RjIfxNkER6UC5LhTHfiL5xQ-omqW_R8x1lX_rKQgqWgKA7f6e1Q-Lk9QP7SFWX7Jw4gu5a33ycd%26client_id%3D${clientId}%26scope%3Dopenid%2520email%26redirect_uri%3D${encodeURIComponent(redirectUri)}%26response_type%3Dcode&flowId=3be221b6aa1a45eda79b311b5e60d285`;

    //         console.log('paypal auth url ', paypalAuthUrl);
    
    //         window.location.href = paypalAuthUrl;
    //     });

    //     const urlParams = new URLSearchParams(window.location.search);
    //     const authCode = urlParams.get('code');

    //     console.log('auth params ', urlParams);
    //     console.log('auth code ', authCode);

    //     console.log('Window location search:', window.location.search);
    //     console.log('Full URL:', window.location.href);
    
    //     if (authCode) {
    //         $.ajax({
    //             url: amsData.ajax_url,
    //             type: 'POST',
    //             data: {
    //                 action: 'verify_paypal_email',
    //                 auth_code: authCode,
    //             },
    //             success: function (response) {
    //                 if (response.success) {
    //                     alert('PayPal Account Verified: ' + response.data.email);
    //                 } else {
    //                     alert('Verification Failed: ' + response.data.message);
    //                 }
    //             },
    //             error: function () {
    //                 alert('An error occurred during verification.');
    //             }
    //         });
    //     } else {
    //         console.log('auth code not found')
    //     }

            
    // }

    if ($('#ic_claim_paypal_verify').length > 0) {
        $('#ic_claim_paypal_verify').on('click', function () {
            const clientId = 'ActdCa4Zmmkfe0tY6UetDJ6CCxu7y_f-lFqnsbKALXCfz0RAQurkiiDuu1MQqs1_hdxwXzyzrxRFGHl0';
            const redirectUri = 'https://paylessminisplit.com'; // Corrected redirect URI (PayPal will add `?code=...` automatically)
    
            const paypalAuthUrl = `https://www.sandbox.paypal.com/signin?intent=connect&ctxId=connect%3A930dc88db88446f689aceb97271f248f&returnUri=https%3A%2F%2Fwww.sandbox.paypal.com%2Fidapps%2Fconnect%2Fconsent%3FctxId%3DAAGCl87F1OiJ7RjIfxNkER6UC5LhTHfiL5xQ-omqW_R8x1lX_rKQgqWgKA7f6e1Q-Lk9QP7SFWX7Jw4gu5a33ycd%26client_id%3D${clientId}%26scope%3Dopenid%2520email%26redirect_uri%3D${encodeURIComponent(redirectUri)}%26response_type%3Dcode&flowId=3be221b6aa1a45eda79b311b5e60d285`;


            
    
            console.log('paypal auth url ', paypalAuthUrl);
    
            // Redirect the user to PayPal for authorization
            window.location.href = paypalAuthUrl;
            const urlParams = new URLSearchParams(window.location.search);
            console.log('auth params ', urlParams);
            const authCode = urlParams.get('code');
            
            console.log('auth code ', authCode);
            console.log('Window location search:', window.location.search);
            console.log('Full URL:', window.location.href);
            
            if (authCode) {
                $.ajax({
                    url: amsData.ajax_url,
                    type: 'POST',
                    data: {
                        action: 'verify_paypal_email',
                        auth_code: authCode,
                    },
                    success: function (response) {
                        if (response.success) {
                            alert('PayPal Account Verified: ' + response.data.email);
                        } else {
                            alert('Verification Failed: ' + response.data.message);
                        }
                    },
                    error: function () {
                        alert('An error occurred during verification.');
                    }
                });
            } else {
                console.log('auth code not found');
            }
        });
    }
    
    


});


