<?php 
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

add_action('admin_menu', 'icecomaf_add_affiliates_program_menu');

function icecomaf_add_affiliates_program_menu() {
    // Main menu: "Affiliates Program"
    add_menu_page(
        'Affiliates Program',       
        'Affiliates Program',       
        'manage_options',           
        'affiliates_program',       
        'icecomaf_affiliates_program',  
        'dashicons-groups',         
        20                          
    );

    // Submenu
    add_submenu_page(
        'affiliates_program',       
        'Users list',               
        'Users list',               
        'manage_options',           
        'affiliate_users_list',               
        'icecomaf_users_list_callback'           
    );

    add_submenu_page(
        'affiliates_program',       
        'Payment Options',               
        'Payment Options',               
        'manage_options',           
        'payment_options_list',               
        'icecomaf_payment_options_list'           
    );

    // Submenu: "Settings Control"
    add_submenu_page(
        'affiliates_program',       
        'Settings Control',        
        'Settings Control',               
        'manage_options',           
        'settings_control',               
        'icecomaf_settings_control'           
    );
}

// user detail page
add_action('admin_menu', function() {
    add_submenu_page(
        null, // This makes it a hidden page (not shown in the menu)
        'User Details',
        'User Details',
        'manage_options',
        'user_details',
        'icecomaf_render_user_details'
    );
});
