<?php
add_action('wp_ajax_approve_user', 'icecomaf_approve_user');
function icecomaf_approve_user() {

    if (!isset($_POST['approve_user_nonce']) || !wp_verify_nonce($_POST['approve_user_nonce'], 'approve_user_nonce')) {
        wp_send_json_error(['message' => 'Nonce verification failed.']);
        return;
    }
    
    if (!isset($_POST['user_id'])) {
        wp_send_json_error(['message' => 'Invalid request']);
    }

    $user_id = intval($_POST['user_id']);

    global $wpdb;
    $table_name = esc_sql($wpdb->prefix . 'affiliate_user');

    // Update the account_status to 'approved'
    $updated = $wpdb->update(
        $table_name,
        ['account_status' => 'approved'], 
        ['user_id' => $user_id],
        ['%s'],
        ['%d']
    );

    if ($updated !== false) {
        wp_send_json_success(['message' => 'User approved successfully']);
    } else {
        wp_send_json_error(['message' => 'Failed to update user status']);
    }
}
// cancel payment

add_action('wp_ajax_ic_cancel_payment', 'icecomaf_cancel_payment');

function icecomaf_cancel_payment() {
    global $wpdb;

    // Security Check
    check_ajax_referer('ic_payment_cancel_action_nonce', 'cancel_security');

    $user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
    
    $request_id = isset($_POST['request_id']) ? intval($_POST['request_id']) : null;

    
    $status_reason = sanitize_textarea_field($_POST['cancel_reason']);
    
    
    if (empty($status_reason)) {
        wp_send_json_error(['message' => 'Reason field is required.']);
    }

    if (empty($request_id)) {
        wp_send_json_error(['message' => 'Request ID is required.']);
    }

    $table_name = $wpdb->prefix . 'affiliate_payments';

    // Check if the specific order exists for the user
    $check_order = $wpdb->get_var(
        $wpdb->prepare(
            "SELECT COUNT(*) FROM $table_name WHERE user_id = %d AND id = %d", 
            $user_id, 
            $request_id
        )
    );

    if ($check_order == 0) {
        wp_send_json_error(['message' => 'No matching order found for this user and request ID.']);
    }

    // Update the specific row
    $updated = $wpdb->update(
        $table_name,
        [
            'payment_status' => 'cancel',
            'status_reason' => $status_reason,
            'status_updated_at' => current_time('mysql'),
        ],
        ['user_id' => $user_id, 'id' => $request_id]
    );

    if ($updated === false) {
        wp_send_json_error(['message' => 'Failed to update payment status.']);
    }

    wp_send_json_success(['message' => 'Payment status updated to "Cancel" with reason.']);
}

// make payment
add_action('wp_ajax_ic_make_payment', 'icecomaf_make_payment_handler');
function icecomaf_make_payment_handler() {
    global $wpdb;

    check_ajax_referer('ic_make_payment_action_nonce', 'make_payment_security');

    // Sanitize and validate input

    $user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
    $request_id = isset($_POST['request_id']) ? intval($_POST['request_id']) : 0;
    $request_amount = isset($_POST['request_amount']) ? floatval($_POST['request_amount']) : 0.00;

    $payment_amount = isset($_POST['payment_amount']) ? floatval($_POST['payment_amount']) : 0.00;
    
    $payment_type = isset($_POST['payment_type']) ? sanitize_text_field($_POST['payment_type']) : '';
    $payment_status = isset($_POST['payment_status']) ? sanitize_text_field($_POST['payment_status']) : '';
    $payment_note = isset($_POST['payment_note']) ? sanitize_textarea_field($_POST['payment_note']) : '';

    if (!$user_id || !$request_id || !$payment_note) {
        wp_send_json_error(['message' => 'All fields are required.']);
    }

    // Define table
    $table_payment = esc_sql($wpdb->prefix . 'affiliate_payments');
    $table_affiliate_user = esc_sql($wpdb->prefix . 'affiliate_user');


    $query_due_balance = $wpdb->prepare(
        "SELECT due_balance FROM $table_payment WHERE id = %d AND user_id = %d",
        $request_id,
        $user_id
    );

    $due_balance = $wpdb->get_var($query_due_balance);
    
    if($request_amount == $payment_amount) {
        $request_amount = $request_amount;
    } else {
        $request_amount = $payment_amount;
    }

    $updated_due_blanace = floatval($due_balance - $request_amount);

    // Prepare data for updating
    $update_payment_data = [
        'paid_amount' => $request_amount, 
        'payment_status' => $payment_status,    
        'status_reason' => $payment_note,
        'due_balance' => $updated_due_blanace,
        'status_updated_at' => current_time('mysql'),
    ];

    $update_user_data = [
        'due_balance' => $updated_due_blanace,
    ];

    $where_payment = [
        'id' => $request_id,
        'user_id' => $user_id,
    ];

    $where_user = [
        'user_id' => $user_id,
    ];

    // Update payment table
    $updated_payment = $wpdb->update($table_payment, $update_payment_data, $where_payment);
    $updated_user = $wpdb->update($table_affiliate_user, $update_user_data, $where_user);

    //

    if ($updated_payment !== false) {
        wp_send_json_success(['message' => 'Payment successfully updated.']);
    } else {
        wp_send_json_error(['message' => 'Failed to update payment. Please try again.']);
    }
}