jQuery(document).ready(function ($) {

    // affiliates users tabs
    // if(jQuery('#ic-nav-tab').length > 0) {
        const tabs = $('.ic-nav-tab');
        const contents = $('.ic-tab-content');

        if(tabs.length > 0) {
            const activeTab = localStorage.getItem('activeTab') || 'pending-users';
        
            tabs.removeClass('ic-nav-tab-active').filter(`[data-tab="${activeTab}"]`).addClass('ic-nav-tab-active');
            contents.removeClass('ic-active').filter(`#${activeTab}`).addClass('ic-active');
        
            // Handle tab click events
            tabs.on('click', function (e) {
                e.preventDefault();
        
                tabs.removeClass('ic-nav-tab-active');
                contents.removeClass('ic-active');
        
                $(this).addClass('ic-nav-tab-active');
                const target = $(this).data('tab');
                $(`#${target}`).addClass('ic-active');
        
                localStorage.setItem('activeTab', target);
            });
        }

        const payTabs = jQuery('.ic-pay-nav-tab');
        const payContent = jQuery('.ic-pay-tab-content');

        if (payTabs.length > 0) {
            const activePayTab = localStorage.getItem('activePayTab') || 'payment-request';

            payTabs.removeClass('ic-pay-nav-tab-active').filter(`[data-tab="${activePayTab}"]`).addClass('ic-pay-nav-tab-active');
            payContent.removeClass('ic-pay-active').filter(`#${activePayTab}`).addClass('ic-pay-active');

            payTabs.on('click', function (e) {
                e.preventDefault();

                payTabs.removeClass('ic-pay-nav-tab-active');
                payContent.removeClass('ic-pay-active');

                $(this).addClass('ic-pay-nav-tab-active');
                const target = $(this).data('tab');
                $(`#${target}`).addClass('ic-pay-active');
    
                // Save active tab to localStorage
                localStorage.setItem('activePayTab', target);

            });
            
        }    
    
    // }


    // approve affiliate user ajax

    const approveBtn = $('#ic-approve-button');

    if(approveBtn.length > 0) {
        jQuery('#ic-approve-button').on('click', function (e) {
            e.preventDefault();
    
            if (confirm('Are you sure you want to approve this user?')) {
                const userId = $(this).data('user-id'); 
                const nonce = $(this).data('nonce');
    
                // AJAX request to update status
                $.ajax({
                    url: ajaxurl, 
                    type: 'POST',
                    data: {
                        action: 'approve_user', 
                        user_id: userId, 
                        approve_user_nonce: nonce
                    },
                    success: function (response) {
                        if (response.success) {
                            alert('User approved successfully!');
                            location.reload(); 
                        } else {
                            alert('Failed to approve user. Please try again.');
                        }
                    },
                    error: function () {
                        alert('An error occurred. Please try again.');
                    },
                });
            }
        });
    }

    // cancel payment
    if($('.ic-cancel-payment-btn').length > 0) {
        $(document).on('click', '.ic-cancel-payment-btn', function () {
            const userId = $(this).data('user-id');
            const requestId = $(this).data('request-id');
            const nonce = $(this).data('nonce');    

            // Create Modal
            const modalHtml = `
                <div id="cancel-payment-modal" class="ic-cancel-payment-modal ic_payment_modal_content_wrapper">
                    <div class="ic-cancel-modal-content">
                        <h2>Cancel Payment</h2>
                        <form id="ic-cancel-payment-form">
                            <label for="cancel_reason">Reason for cancellation(Shortly) :</label>
                            <textarea name="cancel_reason" id="cancel_reason" placeholder="Write payment cancel reason"></textarea>
                            <input type="hidden" name="user_id" value="${userId}">
                            <input type="hidden" id="ic_cancel_req_id" name="request_id" value="${requestId}">
                            <input type="hidden" name="cancel_security" value="${nonce}">
                            <div style="color: red; text-align: left;" id="ic_error_message"></div>

                            <div class="ic_btns_payment_popup">
                                <button class="ic_makepayment_submit" type="submit">Submit</button>
                                <button class="ic_makepayment_submit_cancel" type="button" id="close-modal">Close</button>
                            </div>
                        </form>
                    </div>
                </div>
            `;
    
            $('body').append(modalHtml);
    
            // Close Modal
            $('#close-modal').on('click', function () {
                $('#cancel-payment-modal').remove();
            });
    
            // Submit Cancel Payment Form
            $('#ic-cancel-payment-form').on('submit', function (e) {
                e.preventDefault();
    
                const formData = $(this).serialize();

                $('.ic-cancel-modal-content').addClass('ic-payment-loading');
                $('#ic_error_message').text('');

                // console.log('request id', $('#ic_cancel_req_id').val());
                // console.log('request id', $('input[name="request_id"]').val());
    
                $.ajax({
                    url: icAffAdminData.ajax_url, 
                    method: 'POST',
                    data: {
                        action: 'ic_cancel_payment',
                        cancel_security: icAffAdminData.cancel_security,
                        user_id: $('input[name="user_id"]').val(),
                        request_id: $('#ic_cancel_req_id').val(),
                        cancel_reason: $('#cancel_reason').val(),
                    },
                    success: function (response) {
                        $('.ic-cancel-modal-content').removeClass('ic-payment-loading');

                        if (response.success) {
                            alert(response.data.message);
                            location.reload();
                        } else {
                            $('#ic_error_message').text(response.data.message);
                            $('.ic-cancel-modal-content').removeClass('ic-payment-loading');
                        }
                    },
                    error: function (xhr, status, error) {
                        alert('AJAX Error: ' + error);
                    }
                });
            });
        });
    }

    // make payment
    if($('.ic-make-payment-btn').length > 0) {
        $(document).on('click', '.ic-make-payment-btn', function () {
            const userId = $(this).data('user-id');
            const requestId = $(this).data('request-id');
            const paymentType = $(this).data('payment-type');

            const email = $(this).data('email');
            const bank_detail = $(this).data('bank-details');
            const requestAmount = $(this).data('request-amount');
            const nonce = $(this).data('nonce');
    
            // Populate popup
            let detailsHtml = '';
            if (paymentType === 'paypal') {
                detailsHtml = `
                <div class="ic_payment_modal_content_wrapper">
                <div class="ic_admin_payment_info">
                    <p><strong>Payment Type:</strong> PayPal</p>
                    <p><strong>PayPal Email:</strong> ${email}</p>
                </div>
            `;
            } else if (paymentType === 'bank') {
                detailsHtml = `
                <div class="ic_payment_modal_content_wrapper">
                    <div class="ic_admin_payment_info">
                        <p><strong>Payment Type:</strong> Bank</p>
                        <p><strong>Bank Name:</strong> ${bank_detail.branch_name}</p>
                        <p><strong>Account Number:</strong> ${bank_detail.account_number}</p>
                        <p><strong>Routing Number:</strong> ${bank_detail.routing_number}</p>
                    </div>
                `;
            }
    
            const popupHtml = `
                <div id="ic_make_payment_popup">
                    <div id="ic_make_payment_popup_content">
                        <h2>Make Payment</h2>
                        <form id="ic_make_payment_form">
                                ${detailsHtml}
                                <label>
                                    <strong>Payment Amount:</strong> <br/>
                                    <input type="number" name="payment_amount" value="${requestAmount}" id="ic_payment_amount" step="0.01" required>
                                </label>
                                <label>
                                    <strong>Payment Type:</strong> <br/>
                                    <select id="ic_payment_status" name="payment_status">
                                        <option value="full paid">Full Payment</option>
                                        <option value="partial paid">Partial Payment</option>
                                    </select>
                                </label>
                                <label>
                                    <strong>Payment Note:</strong> <br/>
                                    <textarea name="payment_note" id="ic_payment_note" rows="2"></textarea>
                                </label>
                                <input type="hidden" name="user_id" value="${userId}">
                                <input type="hidden" name="request_id" value="${requestId}">
                                <div style="color: red;" id="ic_error_message"></div>
                                <div class="ic_btns_payment_popup">
                                    <button class="ic_makepayment_submit" id="ic_make_payment_btn" type="submit">Submit Payment</button>
                                    <button class="ic_makepayment_submit_cancel" type="button" id="ic_close_make_payment_popup">Close</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            `;
    
            $('body').append(popupHtml);
    
            // Close popup
            $('#ic_close_make_payment_popup').on('click', function () {
                $('#ic_make_payment_popup').remove();
            });
    
            // Submit Payment Form
            $('#ic_make_payment_btn').on('click', function (e) {

                e.preventDefault();

                // const customAmount = parseFloat($('#ic_payment_amount').val()).toFixed(2);
                const customAmount = parseFloat($('#ic_payment_amount').val());
                const selectPaymentStatus = $('#ic_payment_status').val();
                const selectPaymentStatusTrim = selectPaymentStatus.trim().toLowerCase();
                const errorMessageElement = $('#ic_error_message');

                // Validate custom amount
                if (customAmount > requestAmount) {
                    errorMessageElement.text('Payment Amount cannot exceed the original request amount.');
                    return;
                }

                if(Number(requestAmount) === Number(customAmount) && selectPaymentStatusTrim === "partial paid") {
                    errorMessageElement.text('Payment Status should be "Full Payment" when paying the full amount.');
                    return;
                }

                if(customAmount < requestAmount && selectPaymentStatusTrim === "full paid") {
                    errorMessageElement.text('Payment Status should be "Partial Payment" when paying the partial amount.');
                    return;
                }

                $('#ic_make_payment_form').addClass('ic-payment-loading');

                errorMessageElement.text('');
    
                $.ajax({
                    url: icAffAdminData.ajax_url, 
                    method: 'POST',
                    data: {
                        action: 'ic_make_payment', 
                        make_payment_security: icAffAdminData.make_payment_security,
                        user_id: userId,
                        request_id: requestId,
                        payment_type: paymentType,
                        payment_status: $('#ic_payment_status').val(),
                        payment_note: $('#ic_payment_note').val(),
                        // request_id: $('input[name="request_id"]').val(),
                        email: email,
                        bank_detail: bank_detail,
                        request_amount:requestAmount,
                        payment_amount:$('#ic_payment_amount').val(),
                        nonce: nonce
                    },
                    success: function (response) {
                        console.log('res ', response);

                        if (response.success) {
                            alert(response.data.message);
                            $('#ic_make_payment_form').removeClass('ic-payment-loading');
                            location.reload(); 
                        } else {
                            $('#ic_error_message').text(response.data.message);
                            $('#ic_make_payment_form').removeClass('ic-payment-loading');
                        }
                    },
                    error: function () {
                        alert('An unexpected error occurred. Please try again.');
                    },
                });
            });
        });
    }

    // admin user detail tab
    jQuery(document).ready(function ($) {
        // On click of a tab link
        $('.ic-admin-user-tab-link').on('click', function (e) {
            e.preventDefault();

            // Remove active class from all tabs and contents
            $('.ic-admin-user-tab-link').removeClass('active');
            $('.ic-user-detail-tab-content').removeClass('active');

            // Add active class to the clicked tab and corresponding content
            $(this).addClass('active');
            $($(this).attr('href')).addClass('active');
        });
    });

    
    // paypal payment 
    if($('#paypalPaymentPopup').length > 0) {
        $(document).on('click', '.paypal-payment-button', function (e) {
            e.preventDefault();

            var user_id = $(this).data('user-id');
            var request_id = $(this).data('request-id');
            var userEmail = $(this).data('user-email');
            var userName = $(this).data('user-name');
            var paymentAmount = $(this).data('amount');
    
            $('#userNameDisplay').text(userName);
            $('#req_amount').val(paymentAmount);
            $('#userName').val(userName);
            $('#userEmail').val(userEmail);
            $('#userID').val(user_id);
            $('#request_id').val(request_id);
    
            // Open the popup
            $('#paypalPaymentPopup').show();
        });

        // $(document).on('click', '.ic_paypal_modal', function(e) {
        //     if ($(e.target).closest('.ic_paypal_modal_content').length === 0) {
        //         $('#paypalPaymentPopup').hide();
        //     }
        // });
        $(document).on('click', '.ic_paypal_modal_cancel', function(e) {
            console.log('test clicked ');
            $('#paypalPaymentPopup').hide();
        });


            $('#paypalPaymentForm').submit(function(e) {
                e.preventDefault();

                var userEmail = $('#userEmail').val();
                var userName = $('#userName').val();
                var userID = $('#userID').val();
                var request_id = $('#request_id').val();
                var amount = $('#req_amount').val();
                
                // Validate amount and email
                if (!amount || !userEmail) {
                    alert('Please provide amount and email.');
                    return;
                }

                $('.ic_paypal_modal_content ').addClass('ic-payment-loading');
                $('#ic_papal_msg').text('Payment is processing');
        
                // Trigger AJAX request
                $.ajax({
                    url: icAffAdminData.ajax_url,  
                    method: 'POST',
                    data: {
                        action: 'send_paypal_payment',  
                        amount: amount,
                        user_email: userEmail,
                        user_id: userID,
                        user_name: userName
                    },
                    success: function(response) {

                        console.log('res ', response.data);

                        if (response.success) {
                            var batchId = response.data.transaction_id;
                            var status = response.data.status;
        
                            // alert('Payment initiated successfully! Batch ID: ' + batchId);
                            $('#ic_papal_msg').text('Almost done, please wait a few moments');
        
                            // Poll for status update (in production, you'd want to poll periodically)
                            checkBatchStatus(batchId, userName, userID, request_id, userEmail);
                        } else {
                            alert('Payment initiation failed: ' + response.data.message);
                        }
                    },
                    error: function() {
                        alert('An error occurred while processing the payment.');
                    }
                });
            });
        
            // Function to poll for batch status
            function checkBatchStatus(batchId, userName, userID, request_id, userEmail) {
                $.ajax({
                    url: icAffAdminData.ajax_url,
                    method: 'POST',
                    data: {
                        action: 'check_batch_status',
                        batch_id: batchId,
                        user_name: userName,
                        user_id: userID,
                        request_id: request_id
                    },
                    success: function(response) {
                        console.log('check batch response ', response);
                        if (response.success) {
                            var transactionStatus = response.data.status;
                            // alert('Payment transaction status: ' + transactionStatus);
                            $('.ic_paypal_modal_content ').removeClass('ic-payment-loading');
                            $('#ic_papal_msg').text('Congrats! Payment Success.');
                            $('#paypalPaymentForm').hide();
                            $('#ic_paypal_backtohome').show();

                        } else {
                            $('#ic_papal_msg').html(`
                                <div style="padding: 10px; border: 1px solid #ccc; border-radius: 5px; background-color: #f9f9f9;">
                                    <p style="margin: 0;">
                                        Payment processing failed. The account associated with the email address 
                                        <strong>${userEmail}</strong> may not be registered in a PayPal account. Please contact the associated user for assistance.
                                    </p>
                                    <button id="reloadButton" style="margin-top: 10px; padding: 5px 10px; cursor: pointer; background-color: #007bff; color: #fff; border: none; border-radius: 3px;">
                                        Reload Page
                                    </button>
                                </div>
                            `);

                            $('#reloadButton').on('click', function () {
                                location.reload();
                            });

                            // alert('Failed to fetch batch status');
                        }
                    },
                    error: function() {
                        alert('Error checking batch status');
                    }
                });
            }
            
            $('#ic_paypal_backtohome').on('click', function () {
                location.reload(); // Reload the current page
            });
        // });
        

    }

});