import React from 'react';

interface EchoDashLogoProps {
	className?: string;
	width?: number | string;
	height?: number | string;
}

export const EchoDashLogo: React.FC<EchoDashLogoProps> = ({
	className = '',
	width = 189,
	height = 36,
}) => {
	return (
		<svg
			width={width}
			height={height}
			viewBox="0 0 189 36"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
			className={className}
			aria-label="EchoDash"
		>
			<path
				d="M182.926 12.7229C186.698 12.7229 188.528 14.7598 188.528 18.977V27.4114H184.202V20.1819C184.202 17.6286 183.342 16.7967 181.29 16.7967C178.988 16.7967 177.768 18.0016 177.768 20.4114V27.4114H173.469V7.32947H177.768V16.309H177.851C178.461 14.0426 180.264 12.7229 182.926 12.7229Z"
				fill="#202E41"
			/>
			<path
				d="M164.131 27.6983C160.886 27.6983 157.613 26.1491 157.059 23.5385L161.08 22.5344C161.468 23.8827 162.467 24.4565 164.353 24.4565C165.934 24.4565 166.766 24.1122 166.766 23.2803C166.738 22.5057 165.989 22.104 164.408 21.8745L161.801 21.5303C158.945 21.186 157.336 19.5221 157.281 17.1122C157.225 14.2721 159.472 12.7229 163.604 12.7229C167.736 12.7229 170.038 14.3008 170.759 16.9688L166.793 17.8581C166.544 16.4237 165.434 15.7352 163.77 15.7352C162.328 15.7352 161.579 16.1368 161.579 16.9401C161.579 17.5999 162.245 18.1163 163.632 18.2598L166.682 18.5754C169.373 18.8622 171.037 20.4975 171.092 22.8786C171.148 26.0057 168.652 27.6983 164.131 27.6983Z"
				fill="#202E41"
			/>
			<path
				d="M147.792 12.7229C151.841 12.7229 154.837 14.5877 154.837 18.2024V27.4114H151.148L150.649 24.4278H150.565C149.761 26.5508 147.986 27.6983 145.296 27.6983C142.134 27.6983 140.082 26.1491 140.082 23.768C140.082 20.9565 141.607 19.9524 149.29 18.7475L150.676 18.518L150.649 17.9729C150.51 16.5672 149.623 16.1942 147.737 16.1942C145.573 16.1942 144.63 16.9688 144.547 18.518L140.997 17.5999C141.164 14.3581 144.325 12.7229 147.792 12.7229ZM146.738 24.6286C148.901 24.6286 150.621 22.6778 150.676 20.8418L149.484 21.0426C146.378 21.645 144.353 22.1327 144.353 23.309C144.353 24.1696 145.157 24.6286 146.738 24.6286Z"
				fill="#202E41"
			/>
			<path
				d="M118.471 27.4114V7.32947H128.705C135.139 7.32947 138.772 11.2885 138.772 17.3705C138.772 23.5098 135.083 27.4114 128.705 27.4114H118.471ZM122.991 23.1082H128.594C132.782 23.1082 134.14 21.7024 134.14 17.3705C134.14 13.0385 132.782 11.6041 128.594 11.6041H122.991V23.1082Z"
				fill="#202E41"
			/>
			<path
				d="M107.177 27.6983C102.462 27.6983 98.8848 25.0303 98.8848 20.2393C98.8848 15.4196 102.518 12.7229 107.177 12.7229C111.975 12.7229 115.47 15.4483 115.47 20.2393C115.47 25.0877 111.864 27.6983 107.177 27.6983ZM107.177 23.6245C109.784 23.6245 111.143 22.7639 111.143 20.2393C111.143 17.8581 110.173 16.7967 107.177 16.7967C104.293 16.7967 103.211 17.8581 103.211 20.2393C103.211 22.8213 104.626 23.6245 107.177 23.6245Z"
				fill="#202E41"
			/>
			<path
				d="M90.7854 12.7229C94.5573 12.7229 96.3877 14.7598 96.3877 18.977V27.4114H92.0612V20.1819C92.0612 17.6286 91.2014 16.7967 89.1491 16.7967C86.8472 16.7967 85.6269 18.0016 85.6269 20.4114V27.4114H81.3281V7.32947H85.6269V16.309H85.7101C86.3202 14.0426 88.123 12.7229 90.7854 12.7229Z"
				fill="#202E41"
			/>
			<path
				d="M71.4833 27.6983C66.4634 27.6983 63.1076 24.9442 63.1076 20.2393C63.1076 15.4483 66.4912 12.7229 71.4833 12.7229C75.9762 12.7229 78.3613 14.6737 79.2488 18.4893L75.0887 19.4647C74.7282 17.5713 73.6465 16.7967 71.4833 16.7967C68.5435 16.7967 67.4064 17.8581 67.4064 20.2393C67.4064 22.5918 68.5435 23.6245 71.4833 23.6245C73.8961 23.6245 74.6727 22.8213 75.0887 20.9565L79.2488 21.9319C78.3336 25.7762 75.9207 27.6983 71.4833 27.6983Z"
				fill="#202E41"
			/>
			<path
				d="M61.0768 11.6041H50.621V14.9893H60.1615V19.1205H50.621V23.1368H61.0768V27.4114H46.1836V7.32947H61.0768V11.6041Z"
				fill="#202E41"
			/>
			<path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M7.50689 4.31251C10.4771 4.31415 13.1988 5.37832 15.3125 7.14551C10.4262 7.4671 6.56249 11.5323 6.56249 16.5C6.56249 21.4677 10.4262 25.5329 15.3125 25.8545C13.1972 27.6231 10.4729 28.6875 7.5 28.6875L5.62191 28.6875C4.07003 28.6858 2.81251 27.4273 2.81251 25.875L2.8125 7.125C2.8125 5.5717 4.0717 4.31251 5.625 4.31251L7.49999 4.3125L7.50689 4.31251ZM27.1875 16.5C27.1875 10.2246 22.4446 5.05701 16.348 4.38621C20.0776 7.11502 22.5 11.5246 22.5 16.5C22.5 21.4754 20.0776 25.885 16.348 28.6138C22.4446 27.943 27.1875 22.7754 27.1875 16.5ZM7.50764 1.50001L15 1.50001C23.2843 1.50001 30 8.21573 30 16.5C30 24.7843 23.2843 31.5 15 31.5L7.5 31.5L5.625 31.5L4.21874 31.5C1.88879 31.5 -3.89726e-06 29.6112 -3.9991e-06 27.2813L-4.94163e-06 5.71876C-5.04348e-06 3.3888 1.88879 1.50001 4.21874 1.5L5.625 1.50001L7.49999 1.5L7.50764 1.50001ZM17.6367 9.9375L15.9375 9.9375C12.3131 9.9375 9.37499 12.8756 9.37499 16.5C9.37499 20.1244 12.3131 23.0625 15.9375 23.0625L17.6367 23.0625C17.7338 23.0625 17.8125 22.9838 17.8125 22.8867L17.8125 20.25L15.9375 20.25C13.8664 20.25 12.1875 18.5711 12.1875 16.5C12.1875 14.4289 13.8664 12.75 15.9375 12.75L17.8125 12.75L17.8125 10.1133C17.8125 10.0162 17.7338 9.9375 17.6367 9.9375ZM15.9375 15.5625L17.3437 15.5625L17.3437 17.4375L15.9375 17.4375C15.4197 17.4375 15 17.0178 15 16.5C15 15.9822 15.4197 15.5625 15.9375 15.5625Z"
				fill="#202E41"
			/>
		</svg>
	);
};
