import { __ } from '@wordpress/i18n';
import { useDispatch } from '@wordpress/data';
import { store as noticesStore } from '@wordpress/notices';
import { useEffect } from '@wordpress/element';

export const NoticeComponent = ({ data, noticeId = 'default-notice-id' }) => {
    const { createNotice, removeNotice } = useDispatch(noticesStore);

    useEffect(() => {
        if (data) {
            // Remove any existing notice for this specific ID, not interfering with others
            removeNotice(noticeId, 'wc/checkout');

            if (data.type !== 'N/A') {
                createNotice(
                    data.type,
                    data.message,
                    {
                        id: noticeId,
                        isDismissible: false,
                        type: 'default',
                        speak: true,
                        context: 'wc/checkout',
                        __unstableHTML: true,
                    }
                );
            }
        }
    }, [data, noticeId, createNotice, removeNotice]);

    return null;
};
