<?php

///////////////////////////////////////////
// SETTINGS
// echeckpoint_settings.php
///////////////////////////////////////////
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('eCheckpoint_Settings')) {
    class eCheckpoint_Settings
    {

        public static function init()
        {
            add_action('admin_init', [__CLASS__, 'register_settings']);
        }

        public static function register_settings()
        {
            // Register settings for post-order checkpoint
            // @codingStandardsIgnoreLine - Sanitization is properly handled in the callback
            register_setting('eCheckpoint_settings_group', 'eCheckpoint_API_Key_Value', [
                'sanitize_callback' => [__CLASS__, 'sanitize_settings']
            ]);
            add_settings_section('eCheckpoint_API_Key_Section', 'General Settings', [__CLASS__, 'api_key_section_callback'], 'eCheckpoint_Settings_Page');
            add_settings_field('eCheckpoint_API_Key_Value', 'API Key', [__CLASS__, 'api_key_field'], 'eCheckpoint_Settings_Page', 'eCheckpoint_API_Key_Section');
            // @codingStandardsIgnoreLine - Sanitization is properly handled in the callback
            register_setting('eCheckpoint_settings_group', 'eCheckpoint_Message_Checkbox_Value', [
                'sanitize_callback' => [__CLASS__, 'sanitize_settings']
            ]);
            add_settings_section('eCheckpoint_Message_Checkbox_Section', 'Order Comment Settings', [__CLASS__, 'message_checkbox_section_callback'], 'eCheckpoint_Settings_Page');
            add_settings_field('eCheckpoint_Message_Checkbox_Value', 'Add Order Comment:', [__CLASS__, 'message_checkbox_field'], 'eCheckpoint_Settings_Page', 'eCheckpoint_Message_Checkbox_Section');
            // @codingStandardsIgnoreLine - Sanitization is properly handled in the callback
            register_setting('eCheckpoint_settings_group', 'eCheckpoint_OnHold_Checkbox_Value', [
                'sanitize_callback' => [__CLASS__, 'sanitize_settings']
            ]);
            add_settings_section('eCheckpoint_OnHold_Checkbox_Section', 'Order Status Settings', [__CLASS__, 'onhold_checkbox_section_callback'], 'eCheckpoint_Settings_Page');
            add_settings_field('eCheckpoint_OnHold_Checkbox_Value', 'Place Orders On Hold:', [__CLASS__, 'onhold_checkbox_field'], 'eCheckpoint_Settings_Page', 'eCheckpoint_OnHold_Checkbox_Section');

            // Register settings for pre-order checkpoint
            // @codingStandardsIgnoreLine - Sanitization is properly handled in the callback
            register_setting('eCheckpoint_pre_settings_group', 'eCheckpoint_pre_settings', [
                'sanitize_callback' => [__CLASS__, 'pre_settings_sanitize']
            ]);
            add_settings_section('eCheckpoint_pre_order_section', 'General Settings', [__CLASS__, 'pre_order_section_callback'], 'eCheckpoint_Pre_Order_Settings');
            add_settings_field('eCheckpoint_pre_order_checkbox', 'Enable Pre-Order Check', [__CLASS__, 'pre_order_checkbox_callback'], 'eCheckpoint_Pre_Order_Settings', 'eCheckpoint_pre_order_section');
            add_settings_field('eCheckpoint_pre_order_apikey', 'API Key', [__CLASS__, 'pre_order_apikey_callback'], 'eCheckpoint_Pre_Order_Settings', 'eCheckpoint_pre_order_section');

            // Add a new section and field for conditional fail messages
            add_settings_section('eCheckpoint_pre_order_conditional_fail_section', 'Conditional Fail Settings', [__CLASS__, 'pre_order_conditional_fail_section_callback'], 'eCheckpoint_Pre_Order_Settings');
            add_settings_field('eCheckpoint_pre_order_conditional_fail_checkbox', 'Show Conditional Fail Messages', [__CLASS__, 'pre_order_conditional_fail_checkbox_callback'], 'eCheckpoint_Pre_Order_Settings', 'eCheckpoint_pre_order_conditional_fail_section');

            // Add section for display options
            add_settings_section('eCheckpoint_pre_order_display_section', 'Display Options', [__CLASS__, 'pre_order_display_section_callback'], 'eCheckpoint_Pre_Order_Settings');
            add_settings_field('eCheckpoint_show_customer_type_dropdown', 'Show Customer Type Dropdown', [__CLASS__, 'show_customer_type_dropdown_callback'], 'eCheckpoint_Pre_Order_Settings', 'eCheckpoint_pre_order_display_section');
            add_settings_field('eCheckpoint_show_ffl_map', 'Show Dealer Map', [__CLASS__, 'show_ffl_map_callback'], 'eCheckpoint_Pre_Order_Settings', 'eCheckpoint_pre_order_display_section');

            // Add section for checkout messages
            add_settings_section('eCheckpoint_pre_order_messages_section', 'Checkout Messages', [__CLASS__, 'pre_order_messages_section_callback'], 'eCheckpoint_Pre_Order_Settings');
            add_settings_field('eCheckpoint_blocked_products_message', 'Blocked Products Message', [__CLASS__, 'blocked_products_message_callback'], 'eCheckpoint_Pre_Order_Settings', 'eCheckpoint_pre_order_messages_section');
            add_settings_field('eCheckpoint_ffl_required_message', 'Dealer Required Message', [__CLASS__, 'ffl_required_message_callback'], 'eCheckpoint_Pre_Order_Settings', 'eCheckpoint_pre_order_messages_section');
            add_settings_field('eCheckpoint_additional_info_message', 'Additional Information Message', [__CLASS__, 'additional_info_message_callback'], 'eCheckpoint_Pre_Order_Settings', 'eCheckpoint_pre_order_messages_section');

            // Add new section and fields for 50-State Compliance Fee
            // @codingStandardsIgnoreLine - Sanitization is properly handled in the callback
            register_setting('eCheckpoint_compliance_fee_group', 'eCheckpoint_enable_50_state_fee', [
                'sanitize_callback' => [__CLASS__, 'sanitize_settings']
            ]);
            // @codingStandardsIgnoreLine - Sanitization is properly handled in the callback
            register_setting('eCheckpoint_compliance_fee_group', 'eCheckpoint_fee_percentage', [
                'sanitize_callback' => [__CLASS__, 'sanitize_settings']
            ]);
            // @codingStandardsIgnoreLine - Sanitization is properly handled in the callback
            register_setting('eCheckpoint_compliance_fee_group', 'eCheckpoint_minimum_fee_per_item', [
                'sanitize_callback' => [__CLASS__, 'sanitize_settings']
            ]);
            // @codingStandardsIgnoreLine - Sanitization is properly handled in the callback
            register_setting('eCheckpoint_compliance_fee_group', 'eCheckpoint_maximum_fee_per_item', [
                'sanitize_callback' => [__CLASS__, 'sanitize_settings']
            ]);
            // @codingStandardsIgnoreLine - Sanitization is properly handled in the callback
            register_setting('eCheckpoint_compliance_fee_group', 'eCheckpoint_calculate_fee_on_multiples', [
                'sanitize_callback' => [__CLASS__, 'sanitize_settings']
            ]);
            // @codingStandardsIgnoreLine - Sanitization is properly handled in the callback
            register_setting('eCheckpoint_compliance_fee_group', 'eCheckpoint_compliance_fee_message', [
                'sanitize_callback' => [__CLASS__, 'sanitize_settings']
            ]);
            add_settings_section('eCheckpoint_compliance_fee_section', 'Settings', [__CLASS__, 'compliance_fee_section_callback'], 'eCheckpoint_Compliance_Fee_Settings');
            add_settings_field('eCheckpoint_enable_50_state_fee', 'Enable 50-State Compliance Fee', [__CLASS__, 'enable_50_state_fee_callback'], 'eCheckpoint_Compliance_Fee_Settings', 'eCheckpoint_compliance_fee_section');
            add_settings_field('eCheckpoint_compliance_fee_message', 'Compliance Fee Name', [__CLASS__, 'compliance_fee_message_callback'], 'eCheckpoint_Compliance_Fee_Settings', 'eCheckpoint_compliance_fee_section');
            add_settings_field('eCheckpoint_fee_percentage', 'Fee Percentage', [__CLASS__, 'fee_percentage_callback'], 'eCheckpoint_Compliance_Fee_Settings', 'eCheckpoint_compliance_fee_section');
            add_settings_field('eCheckpoint_minimum_fee_per_item', 'Minimum Fee Per Item', [__CLASS__, 'minimum_fee_per_item_callback'], 'eCheckpoint_Compliance_Fee_Settings', 'eCheckpoint_compliance_fee_section');
            add_settings_field('eCheckpoint_maximum_fee_per_item', 'Maximum Fee Per Item', [__CLASS__, 'maximum_fee_per_item_callback'], 'eCheckpoint_Compliance_Fee_Settings', 'eCheckpoint_compliance_fee_section');
            add_settings_field('eCheckpoint_calculate_fee_on_multiples', 'Calculate Fee for up to X Items per SKU', [__CLASS__, 'calculate_fee_on_multiples_callback'], 'eCheckpoint_Compliance_Fee_Settings', 'eCheckpoint_compliance_fee_section');

            // Register settings for excluded states
            // @codingStandardsIgnoreLine - Sanitization is properly handled in the callback
            register_setting('eCheckpoint_excluded_states_group', 'eCheckpoint_excluded_states', [
                'sanitize_callback' => [__CLASS__, 'sanitize_excluded_states']
            ]);
            add_settings_section('eCheckpoint_excluded_states_section', 'Manage Excluded States', [__CLASS__, 'excluded_states_section_callback'], 'eCheckpoint_Excluded_States_Settings');
            add_settings_field('eCheckpoint_excluded_states_field', 'Excluded States: </br>(ctrl-click to select)', [__CLASS__, 'excluded_states_field_callback'], 'eCheckpoint_Excluded_States_Settings', 'eCheckpoint_excluded_states_section');
        }

        public static function settings_page()
        {
            if (!current_user_can('manage_options')) {
                return;
            }

            // Verify nonce for POST requests
            if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] === 'POST') {
                if (!isset($_POST['eCheckpoint_nonce_name']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['eCheckpoint_nonce_name'])), 'eCheckpoint_nonce_action')) {
                    wp_die('Nonce verification failed');
                }
            }

            $active_tab = isset($_GET['tab']) ? sanitize_text_field(wp_unslash($_GET['tab'])) : 'pre_order_checkpoint';

            $tab_titles = [
                'pre_order_checkpoint' => 'Pre-Order Checkpoint',
                'post_order_checkpoint' => 'Post-Order Checkpoint',
                'excluded_states' => 'Excluded States',
                'compliance_fee' => 'Compliance Fee'
            ];

            ?>
            <div class="wrap">
                <h2>eCheckpoint Settings</h2>
                <h2 class="nav-tab-wrapper">
                    <a href="?page=eCheckpoint_Settings_Page&tab=pre_order_checkpoint"
                        class="nav-tab <?php echo $active_tab == 'pre_order_checkpoint' ? 'nav-tab-active' : ''; ?>"><?php echo esc_html($tab_titles['pre_order_checkpoint']); ?></a>
                    <a href="?page=eCheckpoint_Settings_Page&tab=post_order_checkpoint"
                        class="nav-tab <?php echo $active_tab == 'post_order_checkpoint' ? 'nav-tab-active' : ''; ?>"><?php echo esc_html($tab_titles['post_order_checkpoint']); ?></a>
                    <a href="?page=eCheckpoint_Settings_Page&tab=compliance_fee"
                        class="nav-tab <?php echo $active_tab == 'compliance_fee' ? 'nav-tab-active' : ''; ?>"><?php echo esc_html($tab_titles['compliance_fee']); ?></a>
                    <a href="?page=eCheckpoint_Settings_Page&tab=excluded_states"
                        class="nav-tab <?php echo $active_tab == 'excluded_states' ? 'nav-tab-active' : ''; ?>"><?php echo esc_html($tab_titles['excluded_states']); ?></a>
                </h2>

                <h2><?php echo esc_html($tab_titles[$active_tab]); ?></h2>

                <?php
                if ($active_tab == 'pre_order_checkpoint') {
                    echo '<p>The Pre-Order Checkpoint reviews items in the shopping cart when the Place Order button is clicked and before payment is processed. It blocks non-compliant items from being purchased and helps prevent refunds. For full compliance and accuracy, this checkpoint must be used in conjunction with the Post-Order Checkpoint.</p>';
                    ?>
                    <form method="post" action="options.php">
                        <?php
                        settings_fields('eCheckpoint_pre_settings_group');
                        do_settings_sections('eCheckpoint_Pre_Order_Settings');
                        wp_nonce_field('eCheckpoint_nonce_action', 'eCheckpoint_nonce_name');
                        submit_button('Save Changes');
                        ?>
                    </form>
                    <?php
                } elseif ($active_tab == 'post_order_checkpoint') {
                    echo '<p>The Post-Order Checkpoint reviews the items in the shopping cart after the order has been placed. This provides a tamper-proof compliance record, ensuring it is the most reliable source for Customer Service to confirm final actions needed to process the order.</p>';
                    ?>
                    <form method="post" action="options.php">
                        <?php
                        settings_fields('eCheckpoint_settings_group');
                        do_settings_sections('eCheckpoint_Settings_Page');
                        wp_nonce_field('eCheckpoint_nonce_action', 'eCheckpoint_nonce_name');
                        submit_button('Save Changes');
                        ?>
                    </form>
                    <?php
                } elseif ($active_tab == 'compliance_fee') {
                    echo '<p>This setting enables you to offset the costs of your compliance program by adding a compliance fee in checkout.</p>';
                    ?>
                    <form method="post" action="options.php">
                        <?php
                        settings_fields('eCheckpoint_compliance_fee_group');
                        do_settings_sections('eCheckpoint_Compliance_Fee_Settings');
                        wp_nonce_field('eCheckpoint_nonce_action', 'eCheckpoint_nonce_name');
                        submit_button('Save Changes');
                        ?>
                    </form>
                    <?php
                } elseif ($active_tab == 'excluded_states') {
                    echo '<p>This setting enables you to exclude certain states from compliance checks and compliance fees.</p>';
                    ?>
                    <form method="post" action="options.php">
                        <?php
                        settings_fields('eCheckpoint_excluded_states_group');
                        do_settings_sections('eCheckpoint_Excluded_States_Settings');
                        wp_nonce_field('eCheckpoint_nonce_action', 'eCheckpoint_nonce_name');
                        submit_button('Save Changes');
                        ?>
                    </form>
                    <?php
                }
                ?>
            </div>
            <?php
        }

        public static function api_key_section_callback()
        {
            echo '<p>Enter the API key for your post-order checkpoint. If you need an API key, please contact Support.</p>';
        }

        public static function message_checkbox_section_callback()
        {
            echo '<p>Adds a comment to each order noting the compliance check result. Your customers will not be notified.</p>';
        }

        public static function onhold_checkbox_section_callback()
        {
            echo '<p>Places orders with a Fail or Conditional Fail result on hold. Your customers will not be notified.</p>';
        }

        public static function api_key_field()
        {
            $api_key = sanitize_text_field(get_option('eCheckpoint_API_Key_Value'));
            echo '<input type="text" name="eCheckpoint_API_Key_Value" value="' . esc_attr($api_key) . '" />';
        }

        public static function message_checkbox_field()
        {
            $checkbox_val = get_option('eCheckpoint_Message_Checkbox_Value', '1');
            echo '<input type="checkbox" id="eCheckpoint_Message_Checkbox_Value" name="eCheckpoint_Message_Checkbox_Value" value="1"' . checked(1, $checkbox_val, false) . '/>';
        }

        public static function onhold_checkbox_field()
        {
            $checkbox_val = get_option('eCheckpoint_OnHold_Checkbox_Value', '1');
            echo '<input type="checkbox" id="eCheckpoint_OnHold_Checkbox_Value" name="eCheckpoint_OnHold_Checkbox_Value" value="1"' . checked(1, $checkbox_val, false) . '/>';
        }

        public static function pre_order_section_callback()
        {
            echo '<p>Configure the settings for your pre-order checkpoint. If you need an API key, please contact Support.</p>';
        }

        public static function pre_order_apikey_callback()
        {
            $options = get_option('eCheckpoint_pre_settings');
            $apikey = isset($options['eCheckpoint_pre_order_apikey']) ? esc_attr($options['eCheckpoint_pre_order_apikey']) : '';
            echo '<input type="text" id="eCheckpoint_pre_order_apikey" name="eCheckpoint_pre_settings[eCheckpoint_pre_order_apikey]" value="' . esc_attr($apikey) . '" />';
        }

        public static function pre_order_checkbox_callback()
        {
            $options = get_option('eCheckpoint_pre_settings');
            $checkbox = isset($options['checkbox']) ? $options['checkbox'] : '';
            echo '<input type="checkbox" id="eCheckpoint_pre_order_checkbox" name="eCheckpoint_pre_settings[checkbox]" ' . checked($checkbox, 'on', false) . ' /> Enable';
        }

        public static function pre_order_conditional_fail_section_callback()
        {
            echo '<p>Displays a message during checkout if additional information will be required from your customer after checkout for example, permits or licenses. Displaying these messages will enable your customers to remove products from their cart that they are not qualified to purchase.</p>';
        }

        public static function pre_order_conditional_fail_checkbox_callback()
        {
            $options = get_option('eCheckpoint_pre_settings');
            $checkbox = isset($options['conditional_fail_checkbox']) ? $options['conditional_fail_checkbox'] : '';
            echo '<input type="checkbox" id="eCheckpoint_pre_order_conditional_fail_checkbox" name="eCheckpoint_pre_settings[conditional_fail_checkbox]" ' . checked($checkbox, 'on', false) . ' /> Enable';
        }

        public static function pre_order_display_section_callback()
        {
            echo '<p>Configure which elements are displayed on the checkout page.</p>';
        }

        public static function show_customer_type_dropdown_callback()
        {
            $options = get_option('eCheckpoint_pre_settings');
            // Default to 'on' only if key doesn't exist (fresh install), otherwise use saved value
            $checkbox = array_key_exists('show_customer_type_dropdown', (array)$options) ? $options['show_customer_type_dropdown'] : 'on';
            echo '<input type="checkbox" id="eCheckpoint_show_customer_type_dropdown" name="eCheckpoint_pre_settings[show_customer_type_dropdown]" ' . checked($checkbox, 'on', false) . ' /> Enable';
            echo '<p class="description">Shows a dropdown allowing customers to select their customer type (Consumer, Business, or Government).</p>';
        }

        public static function show_ffl_map_callback()
        {
            $options = get_option('eCheckpoint_pre_settings');
            // Default to 'on' only if key doesn't exist (fresh install), otherwise use saved value
            $checkbox = array_key_exists('show_ffl_map', (array)$options) ? $options['show_ffl_map'] : 'on';
            echo '<input type="checkbox" id="eCheckpoint_show_ffl_map" name="eCheckpoint_pre_settings[show_ffl_map]" ' . checked($checkbox, 'on', false) . ' /> Enable';
            echo '<p class="description">Shows an interactive map for customers to select a dealer when required.</p>';
        }

        public static function pre_order_messages_section_callback()
        {
            echo '<p>Customize the messages displayed to customers during checkout.</p>';
        }

        public static function blocked_products_message_callback()
        {
            $options = get_option('eCheckpoint_pre_settings');
            $default_message = 'The following items cannot be shipped to your location due to federal, state, or local regulations. Please remove these items from your cart to proceed with checkout:';
            $message = isset($options['blocked_products_message']) ? $options['blocked_products_message'] : $default_message;
            echo '<textarea id="eCheckpoint_blocked_products_message" name="eCheckpoint_pre_settings[blocked_products_message]" rows="3" cols="60">' . esc_textarea($message) . '</textarea>';
            echo '<p class="description">This message is shown when products in the cart cannot be shipped to the customer\'s location. The blocked product names will be displayed as a bulleted list below this message.</p>';
        }

        public static function ffl_required_message_callback()
        {
            $options = get_option('eCheckpoint_pre_settings');
            $default_message = 'The following product(s) must be shipped to a Licensed Federal Firearms (FFL) dealer.  Please provide a shipping address for a dealer below:';
            $message = isset($options['ffl_required_message']) ? $options['ffl_required_message'] : $default_message;
            echo '<textarea id="eCheckpoint_ffl_required_message" name="eCheckpoint_pre_settings[ffl_required_message]" rows="3" cols="60">' . esc_textarea($message) . '</textarea>';
            echo '<p class="description">This message is shown when products require shipment to a dealer. The product names will be displayed as a bulleted list below this message.</p>';
        }

        public static function additional_info_message_callback()
        {
            $options = get_option('eCheckpoint_pre_settings');
            $default_message = 'To complete this purchase, additional information will be required after checkout.';
            $message = isset($options['additional_info_message']) ? $options['additional_info_message'] : $default_message;
            echo '<textarea id="eCheckpoint_additional_info_message" name="eCheckpoint_pre_settings[additional_info_message]" rows="3" cols="60">' . esc_textarea($message) . '</textarea>';
            echo '<p class="description">This message is shown when products in the cart require additional verification (permits, licenses, etc.) after checkout.</p>';
        }

        // 50-State Compliance Fee Section
        public static function compliance_fee_section_callback()
        {
            echo '<p>Configure the settings for the 50-State Compliance Fee.</p>';
        }

        public static function enable_50_state_fee_callback()
        {
            $checkbox_val = get_option('eCheckpoint_enable_50_state_fee', '0');
            echo '<input type="checkbox" id="eCheckpoint_enable_50_state_fee" name="eCheckpoint_enable_50_state_fee" value="1"' . checked(1, $checkbox_val, false) . '/>';
        }

        public static function compliance_fee_message_callback()
        {
            $compliance_fee_message = get_option('eCheckpoint_compliance_fee_message', '50-State Compliance Fee');
            echo '<input type="text" id="eCheckpoint_compliance_fee_message" name="eCheckpoint_compliance_fee_message" value="' . esc_attr($compliance_fee_message) . '" />';
            echo '<p class="description">Set the name for the compliance fee. Your customers will see this as a line item in the shopping cart.</p>';
        }

        public static function fee_percentage_callback()
        {
            $fee_percentage = get_option('eCheckpoint_fee_percentage', '1');
            echo '<input type="number" step="0.0001" id="eCheckpoint_fee_percentage" name="eCheckpoint_fee_percentage" value="' . esc_attr($fee_percentage) . '" /> %';
        }

        public static function minimum_fee_per_item_callback()
        {
            $minimum_fee_per_item = get_option('eCheckpoint_minimum_fee_per_item', '0.50');
            echo '<input type="number" step="0.01" id="eCheckpoint_minimum_fee_per_item" name="eCheckpoint_minimum_fee_per_item" value="' . esc_attr($minimum_fee_per_item) . '" /> $';
        }

        public static function maximum_fee_per_item_callback()
        {
            $maximum_fee_per_item = get_option('eCheckpoint_maximum_fee_per_item', '5.00');
            echo '<input type="number" step="0.01" id="eCheckpoint_maximum_fee_per_item" name="eCheckpoint_maximum_fee_per_item" value="' . esc_attr($maximum_fee_per_item) . '" /> $';
        }

        public static function calculate_fee_on_multiples_callback()
        {
            $calculate_fee_on_multiples = get_option('eCheckpoint_calculate_fee_on_multiples', '3');
            echo '<input type="number" step="1" min="1" id="eCheckpoint_calculate_fee_on_multiples" name="eCheckpoint_calculate_fee_on_multiples" value="' . esc_attr($calculate_fee_on_multiples) . '" />';
            echo '<p class="description">Sets the maximum number of items per product (SKU) for which the compliance fee will be calculated.</p>';
        }

        public static function pre_settings_sanitize($inputs)
        {
            // Nonce verification
            if (!isset($_POST['eCheckpoint_nonce_name']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['eCheckpoint_nonce_name'])), 'eCheckpoint_nonce_action')) {
                wp_die('Nonce verification failed');
            }

            $new_input = array();
            if (isset($inputs['eCheckpoint_pre_order_apikey'])) {
                $new_input['eCheckpoint_pre_order_apikey'] = sanitize_text_field($inputs['eCheckpoint_pre_order_apikey']);
            }
            if (isset($inputs['checkbox'])) {
                $new_input['checkbox'] = sanitize_text_field($inputs['checkbox']);
            }
            if (isset($inputs['conditional_fail_checkbox'])) {
                $new_input['conditional_fail_checkbox'] = sanitize_text_field($inputs['conditional_fail_checkbox']);
            }
            // Checkbox fields need explicit handling - unchecked = not submitted
            // Save 'on' if checked, empty string if unchecked
            $new_input['show_customer_type_dropdown'] = isset($inputs['show_customer_type_dropdown']) ? 'on' : '';
            $new_input['show_ffl_map'] = isset($inputs['show_ffl_map']) ? 'on' : '';
            // Textarea for checkout messages
            if (isset($inputs['blocked_products_message'])) {
                $new_input['blocked_products_message'] = sanitize_textarea_field($inputs['blocked_products_message']);
            }
            if (isset($inputs['ffl_required_message'])) {
                $new_input['ffl_required_message'] = sanitize_textarea_field($inputs['ffl_required_message']);
            }
            if (isset($inputs['additional_info_message'])) {
                $new_input['additional_info_message'] = sanitize_textarea_field($inputs['additional_info_message']);
            }
            if (isset($inputs['eCheckpoint_enable_50_state_fee'])) {
                $new_input['eCheckpoint_enable_50_state_fee'] = sanitize_text_field($inputs['eCheckpoint_enable_50_state_fee']);
            }
            if (isset($inputs['eCheckpoint_fee_percentage'])) {
                $new_input['eCheckpoint_fee_percentage'] = sanitize_text_field($inputs['eCheckpoint_fee_percentage']);
            }
            if (isset($inputs['eCheckpoint_minimum_fee_per_item'])) {
                $new_input['eCheckpoint_minimum_fee_per_item'] = sanitize_text_field($inputs['eCheckpoint_minimum_fee_per_item']);
            }
            if (isset($inputs['eCheckpoint_maximum_fee_per_item'])) {
                $new_input['eCheckpoint_maximum_fee_per_item'] = sanitize_text_field($inputs['eCheckpoint_maximum_fee_per_item']);
            }
            if (isset($inputs['eCheckpoint_calculate_fee_on_multiples'])) {
                $new_input['eCheckpoint_calculate_fee_on_multiples'] = sanitize_text_field($inputs['eCheckpoint_calculate_fee_on_multiples']);
            }
            if (isset($inputs['eCheckpoint_compliance_fee_message'])) {
                $new_input['eCheckpoint_compliance_fee_message'] = sanitize_text_field($inputs['eCheckpoint_compliance_fee_message']);
            }
            return $new_input;
        }

        public static function sanitize_settings($input)
        {
            // General sanitization function for settings
            return sanitize_text_field($input);
        }

        public static function sanitize_excluded_states($input)
        {
            if (is_array($input)) {
                return array_map('sanitize_text_field', $input);
            }
            return [];
        }

        public static function excluded_states_section_callback()
        {
            echo '<p>Select the states you would like to exclude from both compliance checks and compliance fees.</p>';
        }

        public static function excluded_states_field_callback()
        {
            $excluded_states = get_option('eCheckpoint_excluded_states', []);
            if (!is_array($excluded_states)) {
                $excluded_states = [];
            }
            $states = WC()->countries->get_states('US');
            ?>
            <select name="eCheckpoint_excluded_states[]" multiple="multiple" style="height: 200px; width: 100%;">
                <?php foreach ($states as $code => $name): ?>
                    <option value="<?php echo esc_attr($code); ?>" <?php selected(in_array($code, $excluded_states)); ?>>
                        <?php echo esc_html($name); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <?php
        }
    }
}

eCheckpoint_Settings::init();
?>