<?php

///////////////////////////////////////////
// ADD COMPLIANCE FEE
// echeckpoint_compliance-fee.php
///////////////////////////////////////////
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


if (!class_exists('eCheckpoint_Compliance_Fee')) {
    class eCheckpoint_Compliance_Fee {

        private static $regulatedProducts = [];

        public static function ComplianceFee_calculate($regulatedProducts = null) {

            if (is_a($regulatedProducts, 'WC_Cart') || empty($regulatedProducts)) {
                return; 
            }

            // Check if the Compliance Fee is enabled
            $enable_fee = get_option('eCheckpoint_enable_50_state_fee');

            if ($enable_fee !== '1') {

                return; // Do not add the compliance fee
            }

            // Skip compliance fee for non-US orders - eCheckpoint only covers United States
            $shipping_country = WC()->customer->get_shipping_country();
            $billing_country = WC()->customer->get_billing_country();
            $country = !empty($shipping_country) ? $shipping_country : $billing_country;
            if ($country !== 'US') {
                return;
            }

            $cart = WC()->cart->get_cart();

            // Retrieve settings
            $fee_percentage = floatval(get_option('eCheckpoint_fee_percentage', '1'));
            $minimum_fee_per_item = floatval(get_option('eCheckpoint_minimum_fee_per_item', '0.50'));
            $maximum_fee_per_item = floatval(get_option('eCheckpoint_maximum_fee_per_item', '5.00'));
            $calculate_fee_on_multiples = intval(get_option('eCheckpoint_calculate_fee_on_multiples', '3'));
            $compliance_fee_message = get_option('eCheckpoint_compliance_fee_message', '50-State Compliance Fee');

            // Get the customer's shipping state
            $shipping_state = WC()->customer->get_shipping_state();

            // Get the list of excluded states
            $excluded_states = get_option('eCheckpoint_excluded_states', []);
            if (!is_array($excluded_states)) {
                $excluded_states = [];
            }

            // Check if the customer's shipping state is in the list of excluded states
            if (in_array($shipping_state, $excluded_states)) {
                return; // Do not add the compliance fee
            }

            $total_fee = 0;
            $unique_items = [];

            foreach ($cart as $cart_item) {
                $product_id = !empty($cart_item['variation_id']) ? $cart_item['variation_id'] : $cart_item['product_id'];
                $item_total = $cart_item['line_total'];
                $item_quantity = $cart_item['quantity'];
                $item_price = $item_total / $item_quantity;
                $product = wc_get_product($product_id);
                $product_name = $product->get_name();

                if (is_array($regulatedProducts) && !in_array($product_name, $regulatedProducts)) {
                    continue; 
                }

                // Calculate fee based on item price
                $item_fee_based_on_percentage = ($fee_percentage / 100) * $item_price;

                // Ensure the fee is at least the minimum fee per item
                $item_fee = max($item_fee_based_on_percentage, $minimum_fee_per_item);

                // Cap the fee at the maximum fee per item
                $item_fee = min($item_fee, $maximum_fee_per_item);

                // Apply the fee calculation logic based on the "Calculate Fee on Multiples" setting
                $item_fee_applied = $item_fee * min($item_quantity, $calculate_fee_on_multiples);
                $total_fee += $item_fee_applied;
                
            }

            // Add the fee to the cart if it's greater than 0
            if ($total_fee > 0) {
                WC()->cart->add_fee(esc_html($compliance_fee_message), $total_fee, false, 'standard');
                return $total_fee;    
            } else {
                return; 
            }
        }
        
    }
}


 