<?php
/**
 * Plugin Name:     eCheckpoint
 * Description:     Robust compliance checks for firearms eCommerce. Verifies whether your customers can purchase products based on federal, state, and local sales laws.
 * Requires at least: 6.6
 * Requires PHP:      8.1
 * Version:           3.1.1
 * Author:          eCheckpoint
 * License:         GPL-2.0-or-later
 * License URI:     https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:     echeckpoint
 *
 * @package         create-block
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Define plugin constants
define('ECHECKPOINT_GOOGLE_MAPS_API_KEY', 'AIzaSyDfx2vWHOdQ3LnJzEtYL77JwF3yvjsf1ec');

  // Include other parts of the plugin
  require_once plugin_dir_path(__FILE__) . 'echeckpoint_settings.php';
  require_once plugin_dir_path(__FILE__) . 'echeckpoint_pre-order-check.php';
  require_once plugin_dir_path(__FILE__) . 'echeckpoint_post-order-check.php';
  require plugin_dir_path(__FILE__) . 'echeckpoint_compliance-fee.php';


add_action('woocommerce_blocks_loaded', function() {
    require_once __DIR__ . '/echeckpoint-blocks-integration.php';
	add_action(
		'woocommerce_blocks_cart_block_registration',
		function( $integration_registry ) {
			$integration_registry->register( new echeckpoint_Blocks_Integration() );
		}
	);
	add_action(
		'woocommerce_blocks_checkout_block_registration',
		function( $integration_registry ) {
			$integration_registry->register( new echeckpoint_Blocks_Integration() );
		}
	);

	add_action( 'init', 'echeckpoint_block_init' );
});

add_action( 'before_woocommerce_init', function() {
    if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', __FILE__, true );
    }
} );

function echeckpoint_block_init() {
	register_block_type( __DIR__ . '/build' );
}

if (!class_exists('eCheckpoint')) {
    class eCheckpoint {

        public function __construct() {
            add_action('admin_menu', [$this, 'add_admin_menu']);
            add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_styles']);
            add_filter('plugin_action_links_' . plugin_basename(__FILE__), [$this, 'add_settings_link']);
            add_filter('plugin_row_meta', [$this, 'plugin_row_meta'], 10, 2);
            add_action('admin_init', ['eCheckpoint_Settings', 'register_settings']);
            add_action('woocommerce_thankyou', ['eCheckpoint_Post_Order_Checks', 'api_call']);
            add_action('woocommerce_checkout_process', ['eCheckpoint_Pre_Order_Checks', 'check_required_fields_and_run_compliance']);
        }

        public function add_admin_menu() {
            add_menu_page(
                'eCheckpoint Settings',
                'eCheckpoint',
                'manage_options',
                'eCheckpoint_Settings_Page',
                ['eCheckpoint_Settings', 'settings_page'],
                plugins_url('src/images/eCheckpointIcon24x24.png', __FILE__), // Ensure this URL is correct
                57
            );
        }

        public function enqueue_admin_styles() {
            wp_enqueue_style('echeckpoint-admin-styles', plugins_url('src/css/echeckpoint-admin-styles.css', __FILE__), [], '1.2.2');
        }

        public function add_settings_link($links) {
            $settings_link = '<a href="' . esc_url(get_admin_url(null, 'admin.php?page=eCheckpoint_Settings_Page')) . '">Settings</a>';
            array_unshift($links, $settings_link);
            return $links;
        }

        public function plugin_row_meta($links, $file) {
            if ($file == plugin_basename(__FILE__)) {
                $website_link = '<a href="https://www.echeckpoint.com" target="_blank">Visit our website</a>';
                $email_link = '<a href="mailto:support@echeckpoint.com">Email Support</a>';
                $links[] = $website_link;
                $links[] = $email_link;
            }
            return $links;
        }
    }
    new eCheckpoint();
}
?>