<?php
use Automattic\WooCommerce\Blocks\Integrations\IntegrationInterface;

define ( 'echeckpoint_VERSION', '0.1.0' );

/**
 * Class for integrating with WooCommerce Blocks
 */
class echeckpoint_Blocks_Integration implements IntegrationInterface {

	/**
	 * The name of the integration.
	 *
	 * @return string
	 */
	public function get_name() {
		return 'echeckpoint';
	}

	/**
	 * When called invokes any initialization/setup for the integration.
	 *
	 */
	public function initialize() {
		$script_path = '/build/index.js';
		$style_path = '/src/css/echeckpoint-checkout.css';

		$script_url = plugins_url( $script_path, __FILE__ );
		$style_url = plugins_url( $style_path, __FILE__ );

		$script_asset_path = dirname( __FILE__ ) . '/build/index.asset.php';
		$script_asset      = file_exists( $script_asset_path )
			? require $script_asset_path
			: array(
				'dependencies' => array(),
				'version'      => $this->get_file_version( $script_path ),
			);

		wp_register_script(
			'echeckpoint-blocks-integration',
			$script_url,
			$script_asset['dependencies'],
			$script_asset['version'],
			true
		);

		// Register checkout styles
		wp_register_style(
			'echeckpoint-checkout-styles',
			$style_url,
			array(),
			$script_asset['version']
		);
		wp_enqueue_style( 'echeckpoint-checkout-styles' );

		// Get admin settings for display options
		$pre_settings = get_option('eCheckpoint_pre_settings');
		$show_customer_type = isset($pre_settings['show_customer_type_dropdown']) ? ($pre_settings['show_customer_type_dropdown'] === 'on') : true;
		$show_ffl_map = isset($pre_settings['show_ffl_map']) ? ($pre_settings['show_ffl_map'] === 'on') : true;

		// Localize eCheckpointParams for the React component
		wp_localize_script(
			'echeckpoint-blocks-integration',
			'eCheckpointParams',
			array(
				'ajax_url' => admin_url('admin-ajax.php'),
				'nonce' => wp_create_nonce('echeckpoint_nonce'),
				'google_maps_api_key' => defined('ECHECKPOINT_GOOGLE_MAPS_API_KEY') ? ECHECKPOINT_GOOGLE_MAPS_API_KEY : '',
				'show_customer_type_dropdown' => $show_customer_type,
				'show_ffl_map' => $show_ffl_map,
				'blocked_products_message' => eCheckpoint_Pre_Order_Checks::get_blocked_products_message(),
				'ffl_required_message' => eCheckpoint_Pre_Order_Checks::get_ffl_required_message(),
				'additional_info_message' => eCheckpoint_Pre_Order_Checks::get_additional_info_message()
			)
		);

		wp_set_script_translations(
			'echeckpoint-blocks-integration',
			'echeckpoint',
			'echeckpoint',
			dirname( __FILE__ ) . '/languages'
		);

	}

	/**
	 * Returns an array of script handles to enqueue in the frontend context.
	 *
	 * @return string[]
	 */
	public function get_script_handles() {
		return array( 'echeckpoint-blocks-integration' );
	}

	/**
	 * Returns an array of script handles to enqueue in the editor context.
	 *
	 * @return string[]
	 */
	public function get_editor_script_handles() {
		return array( 'echeckpoint-blocks-integration' );
	}

	/**
	 * An array of key, value pairs of data made available to the block on the client side.
	 *
	 * @return array
	 */

	 private $custom_message = 'Default message from the server !';

	 public function set_custom_message($message) {
        $this->custom_message = $message;
    }
	 
	public function get_script_data() {
		$data = array(
			'echeckpoint-active' => true,
			'example-data' => $this->custom_message,
		);

		return $data;

	}

	/**
	 * Get the file modified time as a cache buster if we're in dev mode.
	 *
	 * @param string $file Local path to the file.
	 * @return string The cache buster value to use for the given file.
	 */
	protected function get_file_version( $file ) {
		if ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG && file_exists( $file ) ) {
			return filemtime( $file );
		}
		return echeckpoint_VERSION;
	}
}