<?php
   /*
   Plugin Name: Easy User Data
   description: Developed by Mills & Young Custom Web Shop, Easy User Data is a Plugin to allow for easy retrieval of current user login information.  This is simply a wrapper for the default Wordpress Functions while supplying an easy to use shortcode to access the data.
   Version: 1.0
   Author: Mills & Young Custom Web Shop
   Author URI: https://www.millsandyoung.com
   License: GPL2
   */
    

    function easy_user_data_get_logged_in_user_id(){
        $current_user = wp_get_current_user();
        if ( is_user_logged_in() ) {
            return $current_user->ID; 
         }
    }

    function easy_user_data_get_logged_in_user_login(){
        $current_user = wp_get_current_user();
        if ( is_user_logged_in() ) {
            return $current_user->user_login; 
         }
    }

    function easy_user_data_get_logged_in_user_nicename(){
        $current_user = wp_get_current_user();
        if ( is_user_logged_in() ) {
            return $current_user->user_nicename; 
         }
    }

    function easy_user_data_get_logged_in_user_email(){
        $current_user = wp_get_current_user();
        if ( is_user_logged_in() ) {
            return $current_user->user_email; 
         }
    }

    function easy_user_data_get_logged_in_user_url(){
        $current_user = wp_get_current_user();
        if ( is_user_logged_in() ) {
            return $current_user->user_url; 
         }
    }

    function easy_user_data_get_logged_in_user_registerd_date(){
        $current_user = wp_get_current_user();
        if ( is_user_logged_in() ) {
            return $current_user->user_registered; 
         }
    }

    function easy_user_data_get_logged_in_user_display_name(){
        $current_user = wp_get_current_user();
        if ( is_user_logged_in() ) {
            return $current_user->display_name; 
         }
    }

    function easy_user_data_get_logged_in_user_roles(){
        $current_user = wp_get_current_user();
        if ( is_user_logged_in() ) {
            return implode(",",$current_user->roles); 
         }
    }

    function easy_user_data_get_user_ip() {
        $ipaddress = '';
        if (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if(getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if(getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if(getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if(getenv('HTTP_FORWARDED'))
           $ipaddress = getenv('HTTP_FORWARDED');
        else if(getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }


    add_shortcode('Easy_User_Data|UserId', 'easy_user_data_get_logged_in_user_id');
    add_shortcode('Easy_User_Data|UserLogin', 'easy_user_data_get_logged_in_user_login');
    add_shortcode('Easy_User_Data|UserNicename', 'easy_user_data_get_logged_in_user_nicename');
    add_shortcode('Easy_User_Data|UserEmail', 'easy_user_data_get_logged_in_user_email');
    add_shortcode('Easy_User_Data|UserUrl', 'easy_user_data_get_logged_in_user_url');
    add_shortcode('Easy_User_Data|UserRegisteredDate', 'easy_user_data_get_logged_in_user_registerd_date');
    add_shortcode('Easy_User_Data|UserDisplayName', 'easy_user_data_get_logged_in_user_display_name');
    add_shortcode('Easy_User_Data|UserRoles', 'easy_user_data_get_logged_in_user_roles');
    add_shortcode('Easy_User_Data|UserIp', 'easy_user_data_get_user_ip');
?>