document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.esyshrtlnktk-copy-shortlink').forEach(function (link) {
        link.addEventListener('click', function (e) {
            e.preventDefault();
            var shortlink = this.getAttribute('data-shortlink');
            var originalText = this.textContent;

            navigator.clipboard.writeText(shortlink).then(() => {
                this.textContent = 'Shortlink copied!';
                
                // Revert after 1 second
                setTimeout(() => {
                    this.textContent = originalText;
                }, 1000);
            }).catch(() => {
                alert('Failed to copy shortlink');
            });
        });
    });
});