<?php
/**
 * Plugin Name: Easy Shortlink Toolkit
 * Description: Adds a "Copy Shortlink" link in the post list table for all public post types.
 * Version: 1.0.0
 * Author: Prashil
 * Author URI: https://www.streamfact.com
 * License: GPL2+
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: easy-shortlink-toolkit
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

// Add "Copy Shortlink" action link
function esyshrtlnktk_add_copy_shortlink_action( $actions, $post ) {
    // Only for public post types and published posts
    $post_type = get_post_type_object( $post->post_type );
    if ( ! $post_type || ! $post_type->public || $post->post_status !== 'publish' ) {
        return $actions;
    }
    $shortlink = wp_get_shortlink( $post->ID );
    $actions['copy_shortlink'] = '<a href="#" class="esyshrtlnktk-copy-shortlink" data-shortlink="' . esc_attr( $shortlink ) . '">' . esc_html__( 'Copy Shortlink', 'easy-shortlink-toolkit' ) . '</a>';
    return $actions;
}
add_filter( 'post_row_actions', 'esyshrtlnktk_add_copy_shortlink_action', 10, 2 );

// Load JS in admin post list page
function esyshrtlnktk_copy_shortlink_js( $hook ) {
    if ( $hook === 'edit.php' && get_post_type() === 'post' ) {
        wp_enqueue_script( 'esyshrtlnktk-admin-script', plugin_dir_url(__FILE__) . 'js/script.js', array(), '1.0', true );
    }    
}
add_action( 'admin_enqueue_scripts', 'esyshrtlnktk_copy_shortlink_js' );