<?php
/**
 * Plugin Name: Easy Rating Assessor
 * Description: Create dynamic rating forms with custom questions, score calculations, Chart.js visual results, and automatic email notifications.
 * Version: 1.0
 * Author: Sachinraj CP
 * Text Domain: easy-rating-assessor
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires at least: 5.0
 * Requires PHP: 7.2
 * Tested up to: 6.9
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

define('WPRA_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('WPRA_PLUGIN_URL', plugin_dir_url(__FILE__));

// Include core files
require_once WPRA_PLUGIN_PATH . 'includes/functions.php';
require_once WPRA_PLUGIN_PATH . 'includes/ajax-handlers.php';

// Admin UI
if (is_admin()) {
    require_once WPRA_PLUGIN_PATH . 'admin/admin-ui.php';
}

// Enqueue Scripts and Styles
function wpra_enqueue_assets() {
    wp_register_style(
        'wpra-style',
        WPRA_PLUGIN_URL . 'assets/css/style.css',
        array(),
        filemtime(WPRA_PLUGIN_PATH . 'assets/css/style.css')
    );
    
    wp_register_script(
        'wpra-script',
        WPRA_PLUGIN_URL . 'assets/js/rating-form.js',
        array('jquery'),
        filemtime(WPRA_PLUGIN_PATH . 'assets/js/rating-form.js'),
        true
    );
    
    wp_localize_script('wpra-script', 'wpra_ajax', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce'    => wp_create_nonce('wpra_nonce'),
    ));
    
    wp_enqueue_style('wpra-style');
    wp_enqueue_script('wpra-script');
}
add_action('wp_enqueue_scripts', 'wpra_enqueue_assets');

// Shortcode
function wpra_render_form_shortcode() {
    ob_start();
    include WPRA_PLUGIN_PATH . 'public/form-display.php';
    return ob_get_clean();
}
add_shortcode('rating_assessor_form', 'wpra_render_form_shortcode');