<?php
if (!defined('ABSPATH')) {
    exit;
}

// Fetch all questions and group by assigned set
$sets = get_posts(array(
    'post_type' => 'rating_set',
    'numberposts' => -1,
    'orderby' => 'title',
    'order' => 'ASC',
    'post_status' => 'publish'
));

$questions = get_posts(array(
    'post_type' => 'rating_question',
    'numberposts' => -1,
    'orderby' => 'menu_order',
    'order' => 'ASC',
    'post_status' => 'publish'
));

$grouped_questions = array();
foreach ($questions as $question) {
    $set_id = get_post_meta($question->ID, 'wpra_assigned_set', true);
    if (!isset($grouped_questions[$set_id])) {
        $grouped_questions[$set_id] = array();
    }
    $grouped_questions[$set_id][] = $question;
}
?>

<div id="wpra-rating-form">
    <!-- Intro Section -->
    <div class="wpra-intro" style="max-width:700px; margin:auto; padding:20px; background:#f8f9fa; border-radius:8px; margin-bottom:30px;">
        <h2 style="text-align:center;"><?php esc_html_e('Welcome to the Assessment Tool', 'easy-rating-assessor'); ?></h2>
        <p style="text-align:center;"><?php esc_html_e('This tool will help you evaluate your skills across several dimensions.', 'easy-rating-assessor'); ?></p>
        <p><?php esc_html_e('Please read each statement carefully and rate yourself honestly on a scale from 1 to 5, where:', 'easy-rating-assessor'); ?></p>
        <ul>
            <li><?php esc_html_e('1 = Strongly Disagree / Not at all true of me', 'easy-rating-assessor'); ?></li>
            <li><?php esc_html_e('2 = Disagree / Rarely true of me', 'easy-rating-assessor'); ?></li>
            <li><?php esc_html_e('3 = Neutral / Sometimes true of me', 'easy-rating-assessor'); ?></li>
            <li><?php esc_html_e('4 = Agree / Often true of me', 'easy-rating-assessor'); ?></li>
            <li><?php esc_html_e('5 = Strongly Agree / Very true of me', 'easy-rating-assessor'); ?></li>
        </ul>
        <p style="text-align:center; margin-top:20px;">
            <button type="button" class="wpra-start-btn" style="background:#0073aa; color:white; padding:10px 20px; border:none; border-radius:5px; cursor:pointer;"><?php esc_html_e('Start Assessment', 'easy-rating-assessor'); ?></button>
        </p>
    </div>

    <form id="ratingForm" style="display:none;">
        <!-- Step 1: User Info -->
        <div class="wpra-step wpra-step-0">
            <h3><?php esc_html_e('Enter Your Details', 'easy-rating-assessor'); ?></h3>
            <div style="margin-bottom:15px;">
                <label><?php esc_html_e('First Name:', 'easy-rating-assessor'); ?></label><br>
                <input type="text" name="first_name" required style="width:100%; max-width:300px; padding:8px; border:1px solid #ddd; border-radius:4px;">
            </div>
            <div style="margin-bottom:15px;">
                <label><?php esc_html_e('Email:', 'easy-rating-assessor'); ?></label><br>
                <input type="email" name="email" required style="width:100%; max-width:300px; padding:8px; border:1px solid #ddd; border-radius:4px;">
            </div>
            <div style="margin-bottom:15px;">
                <label><?php esc_html_e('Mobile:', 'easy-rating-assessor'); ?></label><br>
                <input type="tel" name="mobile" required style="width:100%; max-width:300px; padding:8px; border:1px solid #ddd; border-radius:4px;">
            </div>
            <button type="button" class="wpra-next" style="background:#0073aa; color:white; padding:10px 20px; border:none; border-radius:5px; cursor:pointer;"><?php esc_html_e('Start Assessment', 'easy-rating-assessor'); ?></button>
        </div>

        <?php
        $step = 1;
        foreach ($sets as $set):
            $set_id = absint($set->ID);
            $set_title = esc_html($set->post_title);
            $set_questions = isset($grouped_questions[$set_id]) ? $grouped_questions[$set_id] : array();

            echo '<div class="wpra-step wpra-step-' . esc_attr($step) . '" style="display:none;">';
            echo '<h3>' . $set_title . '</h3>';
            echo '<p>' . esc_html__('Rate each statement from 1 to 5:', 'easy-rating-assessor') . '</p>';

            foreach ($set_questions as $index => $q) {
                $qid = absint($q->ID);
                $q_title = esc_html($q->post_title);
                $q_content = esc_html($q->post_content);
                
                echo '<div style="margin-bottom:25px; padding:15px; background:#fff; border-radius:5px; border:1px solid #eee;">';
                echo '<div style="margin-bottom:5px; font-weight:bold; font-size:15px;">' . $q_title . ' <span style="font-weight:normal; color:#666;">' . $q_content . '</span></div>';
                echo '<select name="rating[' . esc_attr($set_id) . '][' . esc_attr($qid) . ']" required style="width:100px; padding:5px; margin-top:8px;">';
                echo '<option value="">' . esc_html__('Select', 'easy-rating-assessor') . '</option>';
                for ($i = 1; $i <= 5; $i += 0.25) {
                    $value = number_format($i, 2);
                    echo '<option value="' . esc_attr($value) . '">' . esc_html($value) . '</option>';
                }
                echo '</select>';
                echo '</div>';
            }

            if ($step < count($sets)) {
                echo '<button type="button" class="wpra-next" style="background:#0073aa; color:white; padding:10px 20px; border:none; border-radius:5px; cursor:pointer;">' . esc_html__('Next Section', 'easy-rating-assessor') . '</button>';
            } else {
                echo '<button type="submit" style="background:#0073aa; color:white; padding:10px 20px; border:none; border-radius:5px; cursor:pointer;">' . esc_html__('Submit Assessment', 'easy-rating-assessor') . '</button>';
            }

            echo '</div>';
            $step++;
        endforeach;
        ?>
    </form>

    <div id="wpra-results" style="display:none;"></div>
</div>