<?php
if (!defined('ABSPATH')) {
    exit;
}

// Register Rating Set CPT
function wpra_register_rating_set_cpt() {
    register_post_type('rating_set', array(
        'label' => esc_html__('Rating Sets', 'easy-rating-assessor'),
        'public' => true,
        'show_in_menu' => true,
        'supports' => array('title'),
        'menu_icon' => 'dashicons-index-card',
    ));
}
add_action('init', 'wpra_register_rating_set_cpt');

// Register Rating Question CPT
function wpra_register_rating_question_cpt() {
    register_post_type('rating_question', array(
        'label' => esc_html__('Rating Questions', 'easy-rating-assessor'),
        'public' => true,
        'show_in_menu' => true,
        'supports' => array('title', 'editor'),
        'menu_icon' => 'dashicons-feedback',
    ));
}
add_action('init', 'wpra_register_rating_question_cpt');

// Add Metabox: Assign to Rating Set
function wpra_add_question_metabox() {
    add_meta_box(
        'wpra_question_meta',
        esc_html__('Question Details', 'easy-rating-assessor'),
        'wpra_question_metabox_callback',
        'rating_question',
        'normal',
        'default'
    );
}
add_action('add_meta_boxes', 'wpra_add_question_metabox');

function wpra_question_metabox_callback($post) {
    wp_nonce_field('wpra_question_meta_nonce', 'wpra_question_meta_nonce');
    
    $assigned_set = get_post_meta($post->ID, 'wpra_assigned_set', true);
    $sets = get_posts(array(
        'post_type' => 'rating_set',
        'numberposts' => -1,
        'post_status' => 'publish'
    ));

    echo '<label for="wpra_assigned_set">' . esc_html__('Assign to Set:', 'easy-rating-assessor') . '</label>';
    echo '<select name="wpra_assigned_set" id="wpra_assigned_set">';
    echo '<option value="">' . esc_html__('-- Select Set --', 'easy-rating-assessor') . '</option>';
    foreach ($sets as $set) {
        $selected = selected($assigned_set, $set->ID, false);
        echo '<option value="' . esc_attr($set->ID) . '" ' . $selected . '>' . esc_html($set->post_title) . '</option>';
    }
    echo '</select>';
}

function wpra_save_question_meta($post_id) {
    if (!isset($_POST['wpra_question_meta_nonce']) || 
        !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['wpra_question_meta_nonce'])), 'wpra_question_meta_nonce')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    if (isset($_POST['wpra_assigned_set'])) {
        update_post_meta($post_id, 'wpra_assigned_set', sanitize_text_field($_POST['wpra_assigned_set']));
    }
}
add_action('save_post', 'wpra_save_question_meta');

// Function to get level based on exact scale (for individual sections)
function wpra_get_exact_level($score) {
    if ($score <= 10) return esc_html__('Beginner', 'easy-rating-assessor');
    if ($score <= 13.75) return esc_html__('Intermediate', 'easy-rating-assessor');
    if ($score <= 17.5) return esc_html__('Mid-Level', 'easy-rating-assessor');
    if ($score <= 21.25) return esc_html__('Advance', 'easy-rating-assessor');
    return esc_html__('Elite', 'easy-rating-assessor');
}

// Function to get overall level based on percentage
function wpra_get_overall_level($score, $max) {
    $percentage = ($score / $max) * 100;
    
    if ($percentage < 20) return esc_html__('Beginner', 'easy-rating-assessor');
    if ($percentage < 40) return esc_html__('Intermediate', 'easy-rating-assessor');
    if ($percentage < 60) return esc_html__('Mid-Level', 'easy-rating-assessor');
    if ($percentage < 80) return esc_html__('Advance', 'easy-rating-assessor');
    return esc_html__('Elite', 'easy-rating-assessor');
}