jQuery(document).ready(function($) {
    let currentStep = 0;
    const totalSteps = $('.wpra-step').length;

    function showStep(step) {
        $('.wpra-step').hide();
        $('.wpra-step-' + step).show();
        
        // Scroll to top of form
        $('html, body').animate({
            scrollTop: $('#ratingForm').offset().top - 20
        }, 300);
    }

    showStep(currentStep);

    $('.wpra-next').on('click', function() {
        let inputs = $('.wpra-step-' + currentStep + ' input[required], .wpra-step-' + currentStep + ' select[required]');
        let valid = true;
        
        inputs.each(function() {
            if (!$(this).val()) {
                $(this).css('border', '1px solid red');
                valid = false;
            } else {
                $(this).css('border', '1px solid #ddd');
            }
        });

        if (valid) {
            currentStep++;
            showStep(currentStep);
        } else {
            alert('Please complete all required fields');
        }
    });

    $('#ratingForm').on('submit', function(e) {
        e.preventDefault();

        let formData = $(this).serialize();

        $.ajax({
            url: wpra_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'submit_rating_form',
                nonce: wpra_ajax.nonce,
                data: formData,
            },
            beforeSend: function() {
                $('#ratingForm').hide();
                $('#wpra-results').html('<div style="text-align:center; padding:40px;"><h3>Processing your results...</h3><div class="wpra-loader" style="margin:20px auto; width:50px; height:50px; border:5px solid #f3f3f3; border-top:5px solid #3498db; border-radius:50%; animation:spin 1s linear infinite;"></div></div>').show();
            },
            success: function(response) {
                $('#wpra-results').html('<h3 style="text-align:center; margin-bottom:20px;">Thank you! Here are your results:</h3>' + response);
            },
            error: function() {
                $('#wpra-results').html('<div style="text-align:center; padding:40px; color:red;"><h3>Error processing your results. Please try again.</h3></div>');
            }
        });
    });
});