<?php
if (!defined('ABSPATH')) {
    exit;
}

// Custom Columns for Rating Questions to show Assigned Set
function wpra_add_question_columns($columns) {
    $columns['assigned_set'] = esc_html__('Assigned Set', 'easy-rating-assessor');
    return $columns;
}
add_filter('manage_rating_question_posts_columns', 'wpra_add_question_columns');

function wpra_render_question_columns($column, $post_id) {
    if ($column === 'assigned_set') {
        $set_id = get_post_meta($post_id, 'wpra_assigned_set', true);
        if ($set_id) {
            echo esc_html(get_the_title($set_id));
        } else {
            echo '—';
        }
    }
}
add_action('manage_rating_question_posts_custom_column', 'wpra_render_question_columns', 10, 2);

// Sortable column support (optional)
function wpra_question_sortable_columns($columns) {
    $columns['assigned_set'] = 'assigned_set';
    return $columns;
}
add_filter('manage_edit-rating_question_sortable_columns', 'wpra_question_sortable_columns');