<?php
/*
 * Plugin Name:       Easy ProgressBar
 * Plugin URI:        https://graspers.000webhostapp.com/
 * Description:       An Easy ProgressBar is a visual representation to let the users know approximately how long the article will take them to complete. It can be used where you want like top, bottom
 * Version:           1.0
 * Author:            uniqe-coder
 * Author URI: https://graspers.000webhostapp.com/
 * License:           GPLv2 or later
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       easy-progressbar


*/

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;
//EPB
define('EPB_VERSION','1.0');
define('EPB_PLUGIN_URI', plugin_dir_url(__FILE__));
define('EPB_PLUGIN_DIR', plugin_dir_path( __DIR__ ) );
define('EPB_BASENAME',plugin_basename(__FILE__));

add_action( 'wp_enqueue_scripts', 'enqueue_styles_easy_progressbar_public');
function enqueue_styles_easy_progressbar_public() {
	wp_enqueue_style( 'epbfwp-styles', plugin_dir_url(__FILE__ ) . 'assets/css/rp-bar.css', array(), '', 'all');
}

add_action( 'wp_enqueue_scripts', 'enqueue_scripts_easy_pb_public');
function enqueue_scripts_easy_pb_public() {
	wp_enqueue_script( 'epbfwp-scripts', plugin_dir_url(__FILE__ ) . 'js/rp-public.js', array( 'jquery'), '', false);
}

add_action( 'admin_enqueue_scripts', 'enqueue_scripts_easy_pb_admin');
function enqueue_scripts_easy_pb_admin() {
	wp_enqueue_script( 'rp-admin-scripts', plugin_dir_url(__FILE__ ) . 'js/rp-admin.js', array( 'jquery', 'wp-color-picker'), '', false);
}

add_action( 'admin_enqueue_scripts', 'enqueue_scripts_easy_pb_admin_css');
function enqueue_scripts_easy_pb_admin_css() {
	wp_enqueue_style( 'admin-styles', plugin_dir_url(__FILE__ ) . 'assets/css/rp-admin_r.css');
}

add_action( 'admin_menu', 'easy_pb_admin_menu');
if(!function_exists('easy_pb_admin_menu')){
function easy_pb_admin_menu() {
	add_options_page( __('Easy ProgressBar', 'easy-progressbar'), __('Easy ProgressBar', 'easy-progressbar'), 'manage_options', 'easy-progressbar-settings', 'easy_progressbar_options');
}
}

add_action( 'admin_init', 'easy_progressbar_options_settings');
if(!function_exists('easy_progressbar_options_settings')){
function easy_progressbar_options_settings() {
	register_setting( 'easy_pb_page', 'easy_pb_page_settings');
	add_settings_section( 'easy_pb_page_section', __( 'Easy PB options', 'easy-progressbar'), 'easy_pb_page_settings_caller', 'easy_pb_page');
	add_settings_field( 'easy_pb_field_posttypes', __( 'Select post types to render Progress Bar', 'easy-progressbar'), 'easy_pb_page_posttypes_selector', 'easy_pb_page', 'easy_pb_page_section');
	add_settings_field( 'easy_pb_height', __( 'Select Height', 'easy-progressbar'), 'easy_pb_height_render', 'easy_pb_page', 'easy_pb_page_section');
	add_settings_field( 'easy_pb_position', __( 'Select Position', 'easy-progressbar'), 'easy_pb_position_render', 'easy_pb_page', 'easy_pb_page_section');
	add_settings_field( 'easy_pb_fg_color', __( 'Select Foreground Color', 'easy-progressbar'), 'easy_pb_fg_render', 'easy_pb_page', 'easy_pb_page_section');
	add_settings_field( 'easy_pb_bg_color', __( 'Select Background Color', 'easy-progressbar'), 'easy_pb_bg_render', 'easy_pb_page', 'easy_pb_page_section');
}
}

function easy_pb_page_posttypes_selector() {
	$easy_pb_opt=get_option( 'easy_pb_page_settings');
	$easy_pb_PostType='';
	if (isset($easy_pb_opt['easy_pb_field_posttypes'])) {
		$Postypes_opt=$easy_pb_opt['easy_pb_field_posttypes'];
		$post_types=get_post_types( array( 'public'=> true), 'objects');
		foreach ( $post_types as $in_types=> $pos_t) {
			$easy_pb_PostType=$Postypes_opt[$pos_t->name];
			?><p><input type='checkbox' name='easy_pb_page_settings[easy_pb_field_posttypes][<?php echo $pos_t->name; ?>]' <?php checked( $easy_pb_PostType=='1');
			?>value='1' /><?php echo $pos_t->labels->name;
			?></p><?php
		}
	}
	else {
		$post_types=get_post_types( array( 'public'=> true), 'objects');
		foreach ( $post_types as $in_types=> $pos_t) {
			?><p><input type='checkbox' name='easy_pb_page_settings[easy_pb_field_posttypes][<?php echo $pos_t->name; ?>]' value='1' /><?php echo $pos_t->labels->name;
			?></p><?php
		}
	}
}

function easy_pb_height_render() {
	$easy_pb_height=get_option( 'easy_pb_page_settings');
	//if(isset($easy_pb_height['easy_pb_height'])){
	$easy_pb_height_val=$easy_pb_height['easy_pb_height'];
	//print_r($easy_pb_height_val); die;
	//}?>
	<input type='number' name='easy_pb_page_settings[easy_pb_height]' value='<?php echo $easy_pb_height_val; ?>'><?php
}

function easy_pb_position_render() {
	$easy_pb_main=get_option( 'easy_pb_page_settings');
	//if(isset($easy_pb_height['easy_pb_height'])){
	$easy_pb_pos_val=$easy_pb_main['easy_pb_position'];
	//print_r($easy_pb_height_val); die;
	//}?>
	<select name='easy_pb_page_settings[easy_pb_position]'><option value='top' <?php selected( $easy_pb_pos_val, 'top');
	?>><?php echo __('Top', 'easy-progressbar');
	?></option><option value='bottom' <?php selected( $easy_pb_pos_val, 'bottom');
	?>><?php echo __('Bottom', 'easy-progressbar');
	?></option></select><?php
}

function easy_pb_fg_render() {
	$easy_pb_main=get_option( 'easy_pb_page_settings');
	//if(isset($easy_pb_height['easy_pb_height'])){
	$easy_pb_fg_val=$easy_pb_main['easy_pb_fg_color'];
	//print_r($easy_pb_height_val); die;
	//}?>
	<input class="rp-forwp-colorpick" value="<?php echo $easy_pb_fg_val; ?>" type="text" name="easy_pb_page_settings[easy_pb_fg_color]"><?php
}

function easy_pb_bg_render() {
	$easy_pb_main=get_option( 'easy_pb_page_settings');
	$easy_pb_bg_val=$easy_pb_main['easy_pb_bg_color'];
	//print_r($easy_pb_bg_val); die;
	?><input type="text" class="rp-forwp-colorpick" name="easy_pb_page_settings[easy_pb_bg_color]" value="<?php echo $easy_pb_bg_val; ?>"><?php
}

add_action( 'wp_footer', 'easy_pgbar_render_out');
if(!function_exists('easy_pgbar_render_out')){
	function easy_pgbar_render_out() {
	$postviewssettings=get_option( 'easy_pb_page_settings');
	if(isset($postviewssettings['easy_pb_field_posttypes'])) {
		$internal_settings=$postviewssettings['easy_pb_field_posttypes'];
		$support_array=array();
		foreach ($internal_settings as $key=> $value) {
			$support_array[]=$key;
		}
		if(!empty($support_array) && is_singular($support_array)) {
			$easy_pb_main=get_option( 'easy_pb_page_settings');
			$rb_ht=$easy_pb_main['easy_pb_height'];
			$rb_pos=$easy_pb_main['easy_pb_position'];
			$rpfwp_up_layer=$easy_pb_main['easy_pb_fg_color'];
			$$rpfwp_bg_layer=$easy_pb_main['easy_pb_bg_color'];
			$easy_pb_bg_val=$easy_pb_main['easy_pb_bg_color'];
			echo '<progress height="'.$rb_ht.'" class="rp_bar" position="'.$rb_pos.'"  value="0" up_layer="'.$rpfwp_up_layer.'" background="'.$easy_pb_bg_val.'" ></progress>';
		}
	}
}
}

function easy_pb_page_settings_caller() {
	echo "Here are the settings below";
}

function easy_progressbar_options() {
	?><form action='options.php' method='post'><?php settings_fields( 'easy_pb_page');
	do_settings_sections( 'easy_pb_page');
	submit_button();
	?></form><?php
}