<?php
/**
 * utils
 *
 * @since      1.0.1
 * @author     Leo Q
 */

namespace EPTFW;


class Util
{
    /**
     * Check if WooCommerce is active
     *
     * @return bool
     */
    public static function is_woocommerce_active()
    {
        if ( ! function_exists( 'is_plugin_active_for_network' ) ) {
            require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        }

        if ( ! in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
            if ( ! is_plugin_active_for_network( 'woocommerce/woocommerce.php' ) ) {
                return false;
            }
        }

        return true;
    }
}