<?php
/**
 * Admin settings page
 *
 * @since      1.0.0
 * @author     Leo Q
 */

namespace EPTFW;


class AdminPage
{
    /**
     * Constructor
     *
     * @since 1.0.0
     */
    public function __construct()
    {
        $this->hooks();
    }

    /**
     * Setup Hooks
     *
     * @since 1.0.0
     */
    public function hooks()
    {
        add_action( 'admin_menu', array( $this, 'app_menu' ), 200 );
    }

    /**
     * Sidebar tab
     *
     * @since 1.0.0
     */
    public function app_menu()
    {
        // Add to admin_menu
        add_menu_page(
            __( 'Easy Product Tabs For Woocommerce' ),
            __( 'Easy Product Tabs' ),
            'edit_theme_options',
            Constants::ADMIN_PATH,
            array( $this, 'main_page_content' ),
            plugins_url( 'dist/img/icon.jpg', EPTFW_PLUGIN_DIRNAME )
        );
    }

    /**
     * Main page content.
     *
     * @since 1.0.0
     */
    public function main_page_content()
    {
        include( EPTFW_PLUGIN_DIR . 'templates/admin/index.html' );
    }
}