<?php
/**
 * Plugin Name:       Easy Mobile Poster
 * Description:       Provides a simple frontend posting form optimized for mobile use, with its own simple login system, separate from WordPress users.
 * Version:           2.0.1
 * Requires at least: 5.0
 * Tested up to:      6.9
 * Author:            Bros.KT
 * Author URI:        https://bros-n.com/
 * License:           GPLv2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       easy-mobile-poster
 *
 * @package EasyMobilePoster
 */

if (!defined('ABSPATH')) exit;

define('EASYMOPO_FREE_VERSION', '2.0.1');
define('EASYMOPO_FREE_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('EASYMOPO_FREE_PLUGIN_URL', plugin_dir_url(__FILE__));

// ===== ファイルの読み込み =====
require_once EASYMOPO_FREE_PLUGIN_DIR . 'admin/settings-page.php';
require_once EASYMOPO_FREE_PLUGIN_DIR . 'frontend/shortcode-form.php';

// ===== フックの登録 =====
add_action('admin_menu', 'easymopo_add_admin_menu');
add_action('admin_init', 'easymopo_admin_init');
add_action('wp_enqueue_scripts', 'easymopo_enqueue_styles');
add_shortcode('easymopo_post_form', 'easymopo_shortcode_handler');
register_deactivation_hook(__FILE__, 'easymopo_deactivate');

function easymopo_enqueue_styles() {
    global $post;
    if (is_a($post, 'WP_Post') && has_shortcode($post->post_content, 'easymopo_post_form')) {
        wp_enqueue_style(
            'easymopo-frontend-style',
            EASYMOPO_FREE_PLUGIN_URL . 'frontend/style.css',
            [],
            EASYMOPO_FREE_VERSION
        );
    }
}

function easymopo_deactivate() {
    $options = get_option('easymopo_settings');
    if (!empty($options['page_id'])) {
        wp_trash_post($options['page_id']);
    }
    delete_option('easymopo_settings');
}
?>