<?php
// custom-frontend-poster-free/admin/settings-page.php

if (!defined('ABSPATH')) exit;

function easymopo_add_admin_menu() {
    add_menu_page(
        esc_html__('Easy Mobile Poster Settings', 'easy-mobile-poster'),
        esc_html__('Easy Mobile Poster', 'easy-mobile-poster'),
        'manage_options',
        'easymopo_settings_page',
        'easymopo_options_page_html',
        'dashicons-edit-page'
    );
}

function easymopo_options_page_html() {
    if (!current_user_can('manage_options')) return;
    ?>
    <div class="wrap">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
        <p><?php esc_html_e('This plugin creates a simple frontend posting page that is optimized for mobile devices, using its own ID and password, separate from WordPress user accounts.', 'easy-mobile-poster'); ?></p>
        <div class="notice notice-info inline">
            <p><strong><?php esc_html_e('Pro Version Available:', 'easy-mobile-poster'); ?></strong> <?php esc_html_e('If you need multiple image uploads and automatic gallery generation, please consider the Pro addon.', 'easy-mobile-poster'); ?></p>
        </div>
        <form action="options.php" method="post">
            <?php
            settings_fields('easymopo_settings_group');
            do_settings_sections('easymopo_settings_page');
            submit_button(esc_html__('Save Settings', 'easy-mobile-poster'));
            ?>
        </form>

        <hr>
        <h2 style="margin-top: 30px;"><?php esc_html_e('Post Management', 'easy-mobile-poster'); ?></h2>
        <p><?php esc_html_e('Posts submitted from the frontend are treated as regular WordPress posts.', 'easy-mobile-poster'); ?></p>
        <p><?php esc_html_e('To view, edit, or delete the submitted posts, please go to the post management screen.', 'easy-mobile-poster'); ?></p>
        <p><a href="<?php echo esc_url(admin_url('edit.php')); ?>" class="button button-primary"><?php esc_html_e('Go to Posts Screen', 'easy-mobile-poster'); ?></a></p>
    </div>
    <?php
}

function easymopo_admin_init() {
    register_setting('easymopo_settings_group', 'easymopo_settings', 'easymopo_settings_sanitize');
    add_settings_section('easymopo_login_section', esc_html__('Frontend Posting Page Login Credentials', 'easy-mobile-poster'), null, 'easymopo_settings_page');
    add_settings_section('easymopo_page_section', esc_html__('Frontend Posting Page URL Settings', 'easy-mobile-poster'), null, 'easymopo_settings_page');
    add_settings_field('easymopo_username', esc_html__('Username', 'easy-mobile-poster'), 'easymopo_username_field_html', 'easy_mobile_poster_settings', 'easymopo_login_section');
    add_settings_field('easymopo_password', esc_html__('Password', 'easy-mobile-poster'), 'easymopo_password_field_html', 'easy_mobile_poster_settings', 'easymopo_login_section');
    add_settings_field('easymopo_page_slug', esc_html__('Posting Page URL (Slug)', 'easy-mobile-poster'), 'easymopo_page_slug_field_html', 'easy_mobile_poster_settings', 'easymopo_page_section');
}

function easymopo_username_field_html() {
    $options = get_option('easymopo_settings');
    $username = isset($options['username']) ? $options['username'] : '';
    echo '<input type="text" name="easymopo_settings[username]" value="' . esc_attr($username) . '" required>';
    $description = __('This is the **login username for this plugin only**. It is not related to WordPress users. Please use alphanumeric characters.', 'easy-mobile-poster');
    echo '<p class="description">' . wp_kses_post($description) . '</p>';
}

function easymopo_password_field_html() {
    echo '<input type="password" name="easymopo_settings[password]" value="" autocomplete="new-password">';
    $description = __('This is the **login password for this plugin only**. Only enter a new password if you want to change it. If left blank, the password will not be changed. **For security, please use a complex password** (e.g., combining uppercase, lowercase, numbers, and symbols). If you forget your username or password, you must re-enter and save it on this page.', 'easy-mobile-poster');
    echo '<p class="description">' . wp_kses_post($description) . '</p>';
}

function easymopo_page_slug_field_html() {
    $options = get_option('easymopo_settings');
    $slug = isset($options['page_slug']) ? $options['page_slug'] : 'frontend-post';
    echo '<input type="text" name="easymopo_settings[page_slug]" value="' . esc_attr($slug) . '" required>';
    $description = __('Set the "slug", which is part of the URL for the posting page.', 'easy-mobile-poster') . '<br>' . 
                   sprintf(__('Example: If you set it to %s, the URL will be %s', 'easy-mobile-poster'), '<code>frontend-post</code>', '<code>' . esc_url(home_url('/frontend-post/')) . '</code>') . '<br>' . 
                   __('Only alphanumeric characters and hyphens (<code>-</code>) are allowed.', 'easy-mobile-poster');
    echo '<p class="description">' . wp_kses_post($description) . '</p>';
}

function easymopo_settings_sanitize($input) {
    $options = get_option('easymopo_settings');
    $new_input = [];

    $new_input['username'] = isset($input['username']) ? sanitize_text_field($input['username']) : '';
    $new_input['password_hash'] = !empty($input['password']) ? password_hash($input['password'], PASSWORD_DEFAULT) : (isset($options['password_hash']) ? $options['password_hash'] : '');
    
    $old_slug = isset($options['page_slug']) ? $options['page_slug'] : '';
    $new_slug = isset($input['page_slug']) ? sanitize_title($input['page_slug']) : 'frontend-post';
    if(empty($new_slug)) $new_slug = 'frontend-post';
    $new_input['page_slug'] = $new_slug;

    if ($old_slug && $old_slug !== $new_slug && ($old_page = get_page_by_path($old_slug))) {
        wp_trash_post($old_page->ID);
    }
    
    $page = get_page_by_path($new_slug);
    $page_title = esc_html__('Easy Mobile Posting Page', 'easy-mobile-poster');

    if (!$page) {
        $page_id = wp_insert_post(['post_title' => $page_title, 'post_name' => $new_slug, 'post_content' => '[easymopo_post_form]', 'post_status' => 'publish', 'post_type' => 'page']);
        $new_input['page_id'] = $page_id;
    } else {
        $new_input['page_id'] = $page->ID;
        if ($page->post_title !== $page_title) {
            $page->post_title = $page_title;
            wp_update_post($page);
        }
        if ($page->post_status === 'trash') wp_untrash_post($page->ID);
        if (strpos($page->post_content, '[easymopo_post_form]') === false) {
            $page->post_content .= "\n[easymopo_post_form]";
            wp_update_post($page);
        }
    }
    return $new_input;
}
?>