<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

include( plugin_dir_path( __FILE__ ) . '/../../includes/class-easy-fundraisers-payment-manager.php' );

$easy_fundraisers_return_text;
$easy_fundraisers_singlecol_options = get_option('easy_fundraisers_singlecol_settings_arraykey');

if (isset($_POST['easy_fundraisers_single_collection_nonce']) && wp_verify_nonce($_POST['easy_fundraisers_single_collection_nonce'], 'easy_fundraisers_single_collection')) {

	if (!isset($_POST['donor_first_name']) || empty($_POST['donor_first_name'])) {
		$easy_fundraisers_return_text = esc_html__( 'Please enter your first name!', 'fpdomain' );

	} else if (strlen($_POST['donor_first_name']) < 3) {
		$easy_fundraisers_return_text = esc_html__('The submitted first name is too short!', 'fpdomain');

	} else if (strlen($_POST['donor_first_name']) > 100) {
		$easy_fundraisers_return_text = esc_html__('The submitted first name is too long!', 'fpdomain');

	} else if (!ctype_alpha($_POST['donor_first_name'])) {
		$easy_fundraisers_return_text = esc_html__('The submitted first name is invalid!', 'fpdomain');

	} else if (!isset($_POST['donor_last_name']) || empty($_POST['donor_last_name'])) {
		$easy_fundraisers_return_text = esc_html__( 'Please enter your last name!', 'fpdomain' );

	} else if (strlen($_POST['donor_last_name']) < 3) {
		$easy_fundraisers_return_text = esc_html__('The submitted last name is too short!', 'fpdomain');

	} else if (strlen($_POST['donor_last_name']) > 100) {
		$easy_fundraisers_return_text = esc_html__('The submitted last name is too long!', 'fpdomain');

	} else if (!ctype_alpha($_POST['donor_last_name'])) {
		$easy_fundraisers_return_text = esc_html__('The submitted last name is invalid!', 'fpdomain');

	} else if (!isset($_POST['donor_email']) || empty($_POST['donor_email'])) {
		$easy_fundraisers_return_text = esc_html__( 'Please enter your e-mail!', 'fpdomain' );

	} else if (strlen($_POST['donor_email']) < 3) {
		$easy_fundraisers_return_text = esc_html__('The chosen e-mail is too short!', 'fpdomain');

	} else if (strlen($_POST['donor_email']) > 100) {
		$easy_fundraisers_return_text = esc_html__('The chosen e-mail is too long!', 'fpdomain');

	} else if (!filter_var($_POST['donor_email'], FILTER_VALIDATE_EMAIL)) {
		$easy_fundraisers_return_text = esc_html__('The chosen e-mail is invalid!', 'fpdomain');

	} else if (!isset($_POST['donation_amount']) || empty($_POST['donation_amount'])) {
		$easy_fundraisers_return_text = esc_html__( 'Please enter an amount to donate!', 'fpdomain' );

	} else if (!is_numeric($_POST['donation_amount']) || !($_POST['donation_amount'] > 0 && $_POST['donation_amount'] < PHP_INT_MAX)) {
		$easy_fundraisers_return_text = esc_html__('The chosen donation amount is invalid!', 'fpdomain');

	} else if (!isset($_POST['payment_method']) || empty($_POST['payment_method'])) {
		$easy_fundraisers_return_text = esc_html__( 'Invalid payment method!', 'fpdomain' );

	} else if ($_POST['payment_method'] != 'CREDITCARD' && $_POST['payment_method'] != 'SWISH') {
		$easy_fundraisers_return_text = esc_html__( 'Invalid payment method!', 'fpdomain' );

	} else if (!isset($_POST['tos_checkbox']) || empty($_POST['tos_checkbox']) || $_POST['tos_checkbox'] != 'accept_tos_checkbox') {
		$easy_fundraisers_return_text = esc_html__( 'Please accept the', 'fpdomain' ) . ' ' . wp_kses($easy_fundraisers_singlecol_options["checkbox_text"], $easy_fundraisers_html_tags) . '!';

	} else {
        $easy_fundraisers_collection_id = sanitize_text_field($_POST['collection_id']);
        $easy_fundraisers_donor_name = sanitize_text_field($_POST['donor_first_name']). ' ' . sanitize_text_field($_POST['donor_last_name']);
        $easy_fundraisers_donor_email = sanitize_email($_POST['donor_email']);
        $easy_fundraisers_donation_amount = sanitize_text_field($_POST['donation_amount']);

		global $post;
		$easy_fundraisers_donation_data = array(
			'collection_id'     => $easy_fundraisers_collection_id,
			'donor_name'        => $easy_fundraisers_donor_name,
			'donor_email'       => $easy_fundraisers_donor_email,
			'donation_amount'   => $easy_fundraisers_donation_amount
		);
		$easy_fundraisers_payment_method = sanitize_text_field($_POST['payment_method']);
		$easy_fundraisers_return_url = get_permalink($post->ID);
		$easy_fundraisers_payment_manager = new easy_fundraisers_payment_manager();
		$easy_fundraisers_payment_manager->easy_fundraisers_initialize_payment_process( $easy_fundraisers_donation_data, $easy_fundraisers_payment_method, $easy_fundraisers_return_url );
	}
} elseif ( isset( $_GET['orderRef'] ) ) {
	$easy_fundraisers_order_ref = esc_html($_GET['orderRef']);
	$easy_fundraisers_payment_manager = new easy_fundraisers_payment_manager();
	$easy_fundraisers_result = $easy_fundraisers_payment_manager->easy_fundraisers_complete_payment_process( $easy_fundraisers_order_ref );
	if ( $easy_fundraisers_result['donation_status'] == 'successful' ) {
		$easy_fundraisers_return_text = wp_kses($easy_fundraisers_singlecol_options["donate_reply"], $easy_fundraisers_html_tags);
		$easy_fundraisers_emails = new easy_fundraisers_emails();
		$easy_fundraisers_transaction_number = esc_html($easy_fundraisers_result['transaction_number']);
		global $wpdb;
		$easy_fundraisers_table = $wpdb->prefix . 'donations';
		$easy_fundraisers_query = "SELECT collection_id, donor_email, donation_date FROM $easy_fundraisers_table WHERE transaction_number = $easy_fundraisers_transaction_number AND donation_status = 'successful'";
		$easy_fundraisers_query_results = $wpdb->get_row( $easy_fundraisers_query, ARRAY_A );
		$easy_fundraisers_emails->easy_fundraisers_send_thanks_email( $easy_fundraisers_query_results['collection_id'], $easy_fundraisers_query_results['donor_email'], $easy_fundraisers_query_results['donation_date'], $easy_fundraisers_result['donation_id'], $easy_fundraisers_transaction_number, $easy_fundraisers_result['donation_amount'] / 100 );
		
		$goal_email_sent = get_post_meta(get_the_ID(), 'easy_fundraisers_goal_email_sent', true);
		if (empty($goal_email_sent) || (!empty($goal_email_sent) && $goal_email_sent == 0)) {
			$target = (get_post_meta(get_the_ID(), 'easy_fundraisers_target_amount', true) ? get_post_meta(get_the_ID(), 'easy_fundraisers_target_amount', true) : 0);
			$easy_fundraisers_query = "SELECT (SUM(donation_amount) / 100) AS sum FROM $easy_fundraisers_table WHERE collection_id = '" . $easy_fundraisers_query_results['collection_id'] . "' AND donation_status = 'successful'";
			$easy_fundraisers_query_results = $wpdb->get_row( $easy_fundraisers_query, ARRAY_A );
			$current = ($easy_fundraisers_query_results['sum'] ? $easy_fundraisers_query_results['sum'] : 0);
			
			if ($current >= $target) {
				$easy_fundraisers_emails->easy_fundraisers_send_goal_reached_email($easy_fundraisers_query_results['collection_id']);
				update_post_meta(get_the_ID(), 'easy_fundraisers_goal_email_sent', 1);
			}
		}
	}
}

get_header();

?>

<div id="primary" class="content-area">
	<main id="main" class="site-main" role="main">
		<?php
			if (isset($easy_fundraisers_return_text)) {
				if ($easy_fundraisers_result['donation_status'] == 'successful') {
					echo '<div id="sfl-donate-collection-reply" class="sfl-donate-collection-reply-success">';
				} else {
					echo '<div id="sfl-donate-collection-reply">';
				}
					echo '<div class="x-container max width offset">';
					echo $easy_fundraisers_return_text;
					?>
					</div>
				</div>
				<?php
			}
		?>
		<div class="x-container max width offset">
			<?php
			while ( have_posts() ) : the_post();
				//get_template_part( 'template-parts/content', 'single' );
			?>
			<article id="post-101" class="post-101 page type-page status-publish hentry">
				<div class="sfl_single_collection_container donation_container">
					<div class="sfl_single_collection_div max_page_style">
						<img src="<?php the_post_thumbnail_url('large'); ?>" alr="Collection image" />
					</div>
					<div class="sfl_single_collection_div donation_form_div_max_page_style">
						<div class="yellow-box sfl_donation_form_div">
							<?php
								$easy_fundraisers_end_date = get_post_meta(get_the_ID(), 'easy_fundraisers_end_date', true) . '23:59';
								if (strtotime($easy_fundraisers_end_date) > time()) {
									$easy_fundraisers_payex_options = get_option( 'easy_fundraisers_payex_settings_arraykey' );
									echo '
									<h1 class="entry-title">Make a donation</h1>
									<form class="form-donation" method="post" action="">';

                                            wp_nonce_field( 'easy_fundraisers_single_collection', 'easy_fundraisers_single_collection_nonce' );
                                            echo '

										<div class="form_div">
											<div class="formatter">
												<table>
													<tr>
														<td>
															<label for="donor_first_name">' . esc_html__( 'First name:', 'fpdomain' ) . '</label>
															<input type="text" name="donor_first_name" value="" placeholder="' . esc_html($easy_fundraisers_singlecol_options["default_first_name"]) . '" />
														</td>
														<td>
															<label for="donor_last_name">' . esc_html__( 'Last name:', 'fpdomain' ) . '</label>
															<input type="text" name="donor_last_name" value="" placeholder="' . esc_html($easy_fundraisers_singlecol_options["default_last_name"]) . '" />
														</td>
													</tr>
													<tr>
														<td>
															<label for="donor_email">' . esc_html__( 'E-mail:', 'fpdomain' ) . '</label>
															<input type="email" name="donor_email" value="" placeholder="' . esc_html($easy_fundraisers_singlecol_options["default_email"]) . '" />
														</td>
														<td>
															<label for="donation_amount">' . esc_html__( 'Amount', 'fpdomain' ) . ' (' . esc_html($easy_fundraisers_payex_options["payex_currency"]) . ')</label>
															<input type="number" min="1" name="donation_amount" value="" placeholder="' . esc_html($easy_fundraisers_singlecol_options["default_amount"]) . '" />
														</td>
													</tr>
													<tr>
														<td>
															<label for="payment_method">' . esc_html__( 'Payment Method', 'fpdomain' ) . '</label>
															<input type="radio" name="payment_method" value="CREDITCARD" checked="true" /> Creditcard';
															if ( $easy_fundraisers_payex_options["payex_currency"] == "SEK" ) {
																echo '<input type="radio" name="payment_method" value="SWISH" /> Swish';
															}
															echo '
														</td>
														<td>
															<label for="tos_checkbox">' . wp_kses($easy_fundraisers_singlecol_options["checkbox_text"], $easy_fundraisers_html_tags) . '</label>
															<input type="checkbox" name="tos_checkbox" id="tos_checkbox" value="accept_tos_checkbox" />
															&nbsp' . esc_html__( 'I accept', 'fpdomain' ) . '
														</td>
													</tr>
												</table>
												<table>
												<tr>
													<td>
														<a href="http://www.payex.se" target="_blank"><img src="' . plugins_url('images/payex_logo.png', dirname(__FILE__)) . '" /></a>
														<p style="margin-top: 0px;font-size:0.8em;">' . esc_html__( 'PayEx is used for payments.', 'fpdomain' ) . '</p>
													</td>
													<td>
														<input style="float:right;" type="submit" name="save_donation" value="' . esc_html__( 'Make Donation', 'fpdomain' ) . '">
													</td>
												</tr>
												</table>
												<input type="hidden" name="collection_id" value="' . get_the_ID() . '">
												<input type="hidden" name="submit_donation" value="1">
											</div>
										</div>
									</form>';
								} else {
									echo '
									<div class="sfl-div-donation">
										<div>
											<h4>
												' . esc_html__( 'The end date of this collection has expired.', 'fpdomain' ) . '
											</h4>
											<p>
												' . esc_html__( 'No more donations can be made to this collection.', 'fpdomain' ) . '
											</p>
										</div>
									</div>';
								}
							?>
						</div>
					</div>
				</div>
				<div class="sfl_single_collection_container">
					<div class="sfl_single_collection_div min_page_style" style="padding-bottom:2em;">
						<img src="<?php the_post_thumbnail_url('large'); ?>" alr="Collection image" />
					</div>
					<div class="sfl_single_collection_div">
						<h1 class="entry-title"><?php the_title(); ?></h1>
						<div class="sfl_single_collection_div_desc">
							<p><?php the_content(); ?></p>
							<table>
								<tr>
									<td><b><?php esc_html_e( 'Started by:', 'fpdomain' ); ?></b></td>
									<td><?php the_author(); ?></td>
								</tr>
								<tr>
									<td><b><?php esc_html_e( 'Target amount:', 'fpdomain' ); ?></b></td>
									<td><?php echo get_post_meta(get_the_ID(), 'easy_fundraisers_target_amount', true) . ' ' . esc_html($easy_fundraisers_payex_options["payex_currency"]); ?></td>
								</tr>
								<tr>
									<td><b><?php esc_html_e( 'Gathered amount:', 'fpdomain' ); ?></b></td>
									<td>
										<?php
											global $wpdb;
											$easy_fundraisers_table = $wpdb->prefix . 'donations';
											$easy_fundraisers_id = get_the_ID();
											$easy_fundraisers_query = "SELECT SUM(donation_amount) FROM $easy_fundraisers_table WHERE collection_id = $easy_fundraisers_id AND donation_status = 'successful'";
											$easy_fundraisers_total_amount = $wpdb->get_var( $easy_fundraisers_query ) / 100;
											echo ($easy_fundraisers_total_amount ? $easy_fundraisers_total_amount : '0') . ' ' . $easy_fundraisers_payex_options["payex_currency"];
										?>
									</td>
								</tr>
								<tr>
									<td><b><?php esc_html_e( 'Ending at:', 'fpdomain' ); ?></b></td>
									<td><?php echo get_post_meta(get_the_ID(), 'easy_fundraisers_end_date', true); ?></td>
								</tr>
                                <?php
                                    if ($easy_fundraisers_singlecol_options["show_categories"] == 'true') {
                                        $easy_fundraisers_terms = get_the_terms($easy_fundraisers_id, 'collectioncategory' );
										if ($easy_fundraisers_terms && ! is_wp_error($easy_fundraisers_terms)) :
											$easy_fundraisers_tslugs_arr = array();
											foreach ($easy_fundraisers_terms as $term) {
												$easy_fundraisers_tslugs_arr[] = $term->name;
											}
											$easy_fundraisers_terms_slug_str = join( " ", $easy_fundraisers_tslugs_arr);
										endif;
                                        echo '
        								<tr>
        									<td><b>' . esc_html__( 'Category:', 'fpdomain' ) .'</b></td>
        									<td>
        										' . $easy_fundraisers_terms_slug_str . '
        									</td>
        								</tr>';
                                    }
                                ?>
							</table>
						</div>
    					<div class="sfl_single_collection_div donation_form_div_min_page_style">
                            <div class="yellow-box sfl_donation_form_div">
    							<?php
    								$easy_fundraisers_end_date = get_post_meta(get_the_ID(), 'easy_fundraisers_end_date', true) . '23:59';
    								if (strtotime($easy_fundraisers_end_date) > time()) {
    									$easy_fundraisers_payex_options = get_option( 'easy_fundraisers_payex_settings_arraykey' );
    									echo '
    									<h1 class="entry-title">Make a donation</h1>
    									<form class="form-donation" method="post" action="">';

                                            wp_nonce_field( 'easy_fundraisers_single_collection', 'easy_fundraisers_single_collection_nonce' );
                                            echo '
    										<div class="form_div">
    											<div class="formatter">
    												<table>
    													<tr>
    														<td>
    															<label for="donor_first_name">' . esc_html__( 'First name:', 'fpdomain' ) . '</label>
    															<input type="text" name="donor_first_name" value="" placeholder="' . esc_html($easy_fundraisers_singlecol_options["default_first_name"]) . '" />
    														</td>
    														<td>
    															<label for="donor_last_name">' . esc_html__( 'Last name:', 'fpdomain' ) . '</label>
    															<input type="text" name="donor_last_name" value="" placeholder="' . esc_html($easy_fundraisers_singlecol_options["default_last_name"]) . '" />
    														</td>
    													</tr>
    													<tr>
    														<td>
    															<label for="donor_email">' . esc_html__( 'E-mail:', 'fpdomain' ) . '</label>
    															<input type="email" name="donor_email" value="" placeholder="' . esc_html($easy_fundraisers_singlecol_options["default_email"]) . '" />
    														</td>
    														<td>
    															<label for="donation_amount">' . esc_html__( 'Amount', 'fpdomain' ) . ' (' . esc_html($easy_fundraisers_payex_options["payex_currency"]) . ')</label>
    															<input type="number" min="1" name="donation_amount" value="" placeholder="' . esc_html($easy_fundraisers_singlecol_options["default_amount"]) . '" />
    														</td>
    													</tr>
    													<tr>
    														<td>
    															<label for="payment_method">' . esc_html__( 'Payment Method', 'fpdomain' ) . '</label>
    															<input type="radio" name="payment_method" value="CREDITCARD" checked="true" /> Creditcard';
																if ( $easy_fundraisers_payex_options["payex_currency"] == "SEK" ) {
																	echo '<input type="radio" name="payment_method" value="SWISH" /> Swish';
																}
																echo '
    														</td>
    														<td>
    															<label for="tos_checkbox">' . wp_kses($easy_fundraisers_singlecol_options["checkbox_text"], $easy_fundraisers_html_tags) . '</label>
    															<input type="checkbox" name="tos_checkbox" id="tos_checkbox" value="accept_tos_checkbox" />
    															&nbsp' . esc_html__( 'I accept', 'fpdomain' ) . '
    														</td>
    													</tr>
    												</table>
    												<table>
    												<tr>
														<td>
															<a href="http://www.payex.se" target="_blank"><img src="' . plugins_url('images/payex_logo.png', dirname(__FILE__)) . '" /></a>
															<p style="margin-top: 0px;font-size:0.8em;">' . esc_html__( 'PayEx is used for payments.', 'fpdomain' ) . '</p>
														</td>
    													<td>
    														<input style="float:right;" type="submit" name="save_donation" value="' . __( 'Make Donation', 'fpdomain' ) . '">
    													</td>
    												</tr>
    												</table>
    												<input type="hidden" name="collection_id" value="' . get_the_ID() . '">
    												<input type="hidden" name="submit_donation" value="1">
    											</div>
    										</div>
    									</form>';
    								} else {
    									echo '
    									<div class="sfl-div-donation">
    										<div>
    											<h4>
    												' . esc_html__( 'The end date of this collection has expired.', 'fpdomain' ) . '
    											</h4>
    											<p>
    												' . esc_html__( 'No more donations can be made to this collection.', 'fpdomain' ) . '
    											</p>
    										</div>
    									</div>';
    								}
    							?>
    						</div>
    					</div>
    				</div>

				</div>
			</article>
			<?php endwhile; ?>
		</div>
	</main>
</div>

<?php get_footer(); ?>
