<?php
	// Exit if accessed directly
	if (!defined('ABSPATH')) {
		exit;
	}

	get_header();

?>
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<div class="x-container cs-ta-center divided max width marginless-columns" style="margin: 0px auto 20px;padding: 0px;">
				<div class="sfl_preview_container">

				<?php 
                
                $easy_fundraisers_paged = (get_query_var('paged')) ? absint(get_query_var('paged')) : 1;
                $easy_fundraisers_args = array(
                    'post_type' => 'collection',
                    'orderby' => 'post_date',
                    'posts_per_page' => 9,
                    'paged' => $easy_fundraisers_paged,
                );
                
                $easy_fundraisers_the_query = new WP_Query($easy_fundraisers_args);
                
                if ( $easy_fundraisers_the_query->have_posts() ) : ?>

					<header class="page-header">
						<?php
							$easy_fundraisers_archive_options = get_option('easy_fundraisers_archive_settings_arraykey');
							$easy_fundraisers_payex_options = get_option( 'easy_fundraisers_payex_settings_arraykey' );
							$easy_fundraisers_payex_currency = $easy_fundraisers_payex_options["payex_currency"];
							
							//the_archive_title( '<h1 class="page-title">', '</h1>' );
							//the_archive_description( '<div class="taxonomy-description">', '</div>' );
						?>
						<h2 style="float:left;"><?php echo wp_kses($easy_fundraisers_archive_options["archive_title"], $easy_fundraisers_html_tags); ?></h2>
						<div style="width: 100%;float:left;">
							<p style="float:left;"><?php echo wp_kses($easy_fundraisers_archive_options["archive_desc"], $easy_fundraisers_html_tags); ?></p>
							<form action="<?php echo esc_url($easy_fundraisers_archive_options["archive_link"]); ?>" style="float:right;margin-top:-2em;">
								<input type="submit" name="create_collection" value="<?php esc_html_e( 'Create Collection', 'fpdomain' ); ?>" />
							</form>
						</div>
					</header>


					<?php
					while ($easy_fundraisers_the_query->have_posts()) : $easy_fundraisers_the_query->the_post();
						global $wpdb;
						$easy_fundraisers_table = $wpdb->prefix . 'donations';
						$easy_fundraisers_id = get_the_ID();
						$easy_fundraisers_query = "SELECT SUM(donation_amount) FROM $easy_fundraisers_table WHERE collection_id = $easy_fundraisers_id AND donation_status = 'successful'";
						$easy_fundraisers_total_amount = $wpdb->get_var( $easy_fundraisers_query ) / 100;
						$easy_fundraisers_target_amount = esc_html(get_post_meta(get_the_ID(), 'easy_fundraisers_target_amount', true));

						$easy_fundraisers_gatheredPercentage = 0;
						$easy_fundraisers_leftPercentage = 0;

						if ($easy_fundraisers_total_amount > 0 && $easy_fundraisers_target_amount > 0) {
							$easy_fundraisers_gatheredPercentage = (($easy_fundraisers_total_amount / $easy_fundraisers_target_amount) * 100);
							$easy_fundraisers_gatheredPercentage = ($easy_fundraisers_gatheredPercentage > 100) ? 100 : $easy_fundraisers_gatheredPercentage;
							$easy_fundraisers_leftPercentage = 100 - $easy_fundraisers_gatheredPercentage;
						}
						?>
						<a href="<?php the_permalink(); ?>">
							<div class="sfl_collection_container yellow-box">
								<div class="sfl_rounded" style="background: url(<?php the_post_thumbnail_url('large'); ?>);">
									<div class="sfl_trans_box">
										<?php
											if ($easy_fundraisers_gatheredPercentage > 1) {
												echo'
												<canvas id="postchart' . get_the_id() . '" width="300" height="250"></canvas>';
											}
										?>
									</div>
								</div>
								<?php the_title('<h3 class="h5"><span>', '</span></h3>'); ?>
								<table>
									<tr>
										<td>
											<p style="text-align: center;">
												<?php esc_html_e( 'Gathered:', 'fpdomain' ); ?>&nbsp&nbsp
												<?php
													echo ($easy_fundraisers_total_amount ? $easy_fundraisers_total_amount : '0') . ' ' . $easy_fundraisers_payex_currency;
												?>
											</p>
										</td>
									</tr>
									<tr>
										<td>
											<p style="text-align: center;">
												<?php esc_html_e( 'Goal:', 'fpdomain' ); ?>&nbsp&nbsp
												<?php echo $easy_fundraisers_target_amount . ' ' . $easy_fundraisers_payex_currency; ?>
											</p>
										</td>
									</tr>
								</table>
							</div>
						</a>
						<?php
							if ($easy_fundraisers_gatheredPercentage > 1) {
								echo 
								    '<script>
									var ctx = document.getElementById("postchart' . get_the_id() . '");
									var myChart = new Chart(ctx, {
										type: "pie",
										data: {
											datasets: [
											{
												data: [' . $easy_fundraisers_gatheredPercentage . ', ' . $easy_fundraisers_leftPercentage . '],
												backgroundColor: [
													"#3fab5d",
													"rgba(255,255,255,0.5)"
												],
												hoverBackgroundColor: [
													"#3fab5d",
													"rgba(255,255,255,0.5)"
												]
											}]
										},
										options: {
											tooltips: {
												enabled: false
											}
										}
									});
								</script>';
							}
						?>
						<?php
                        wp_reset_postdata();
					endwhile;
				else :
					get_template_part( 'content', 'none' );

				endif;
                        
                    $easy_fundraisers_big = 999999999; // This needs to be an unlikely integer
                    $easy_fundraisers_paginate_links = paginate_links( array(
                        'base' => str_replace( $easy_fundraisers_big, '%#%', esc_url(get_pagenum_link($easy_fundraisers_big))),
                        'format' => '?paged=%#%',
                        'current' => max(1, get_query_var('paged')),
                        'total' => $easy_fundraisers_the_query->max_num_pages,
                        'mid_size' => 3
                    ));
                
                    // Display the pagination if more than one page is found
                    if ( $easy_fundraisers_paginate_links ) {
                        echo '<div class="pagination" style="margin-top:4em;">';
                        echo $easy_fundraisers_paginate_links;
                        echo '</div><!--// end .pagination -->';
                    }
				?>
				</div>
			</div>
			<div style="widht:100%;height:8em"></div>
		</main>
	</div>

<?php get_footer(); ?>
