<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('easy_fundraisers_list_collections_widget')) {

	class easy_fundraisers_list_collections_widget extends WP_Widget {

		/**
		 * Sets up the widgets name etc
		 */
		public function __construct() {
			$widget_ops = array(
				'classname' => esc_html__('list_collections_widget', 'fpdomain'),
				'description' => esc_html__('Widget for listing collections', 'fpdomain'),
			);
			parent::__construct('list_collections_widget', 'SFL Collections', $widget_ops);
		}

		/**
		 * Outputs the content of the widget
		 *
		 * @param array $args
		 * @param array $instance
		 */
		public function widget($args, $instance) {
			$rows = (isset($instance['rows']) && is_numeric($instance['rows'])) ? $instance['rows'] : 3;
			$sortby = isset($instance['sortby']) ? $instance['sortby'] : esc_html__('Recent collections', 'fpdomain');
			
			if ($sortby != esc_html__('Most collected', 'fpdomain')) {
				$args = array(
					'numberposts' => $rows,
					'offset' => 0,
					'category' => 0,
					'orderby' => 'post_date',
					'order' => 'DESC',
					'include' => '',
					'exclude' => '',
					'meta_key' => '',
					'meta_value' =>'',
					'post_type' => 'collection',
					'post_status' => 'publish',
					'suppress_filters' => true
				);
				$posts = wp_get_recent_posts( $args, ARRAY_A );

				echo $args['before_widget'];
				?>
				
				<div id="sfl_widget" class="widget sfl_list_collections_widget">
					<h4 class="h-widget"><?php echo(esc_html($instance['title'])); ?></h4>
					<ul>
					
				<?php
				foreach( $posts as $recent ) {
					$payex_options = get_option( 'easy_fundraisers_payex_settings_arraykey' );
					$payex_currency = esc_html($payex_options["payex_currency"]);
			
					global $wpdb;
					$table = $wpdb->prefix . 'donations';
					$id = $recent["ID"];
					$query = "SELECT SUM(donation_amount) FROM $table WHERE collection_id = $id AND donation_status = 'successful'";
					$total_amount = $wpdb->get_var( $query ) / 100;
					echo '
						<li class="cat-item cat-item-11">
							<table>
								<tr>
									<td>
										<a href="' . get_permalink($id) . '">' .   $recent["post_title"] . '</a>
									</td>
									<td>
										<p>' . $total_amount . ' ' . $payex_currency . ' gathered</p>
									</td>
								</tr>
							</table>
						</li>';
				}
				wp_reset_query();
				?>
				
					</ul>
				</div>
				
				<?php
			} else {
				?>
				
				<div id="sfl_widget" class="widget sfl_list_collections_widget">
					<h4 class="h-widget"><?php echo(esc_html($instance['title'])); ?></h4>
					<ul>
					
				<?php
				
				if ($rows > 0) {
					global $wpdb;
					$table = $wpdb->prefix . 'donations';
					$query = "SELECT id FROM (SELECT collection_id AS id, SUM(donation_amount) AS sum FROM $table WHERE donation_status = 'successful' GROUP BY collection_id) AS subquery ORDER BY sum DESC";
					$num_rows = 0;
					
					foreach($wpdb->get_results($query) as $key => $row) {
						if ($num_rows >= $rows) break;
						$query2 = "SELECT SUM(donation_amount) FROM $table WHERE collection_id = " . $row->id . " AND donation_status = 'successful'";
						$total_amount = $wpdb->get_var($query2) / 100;
						$post = get_post($row->id);
						echo '
							<li class="cat-item cat-item-11">
								<table>
									<tr>
										<td>
											<a href="' . esc_url(get_permalink($post)) . '">' . get_the_title($post) . '</a>
										</td>
										<td>
											<p>' . $total_amount . ' ' . $payex_currency . ' gathered</p>
										</td>
									</tr>
								</table>
							</li>';
						$num_rows++;
					}
					wp_reset_query();
				}
				?>
				
					</ul>
				</div>
				
				<?php
			}
				
			echo $args['after_widget'];
			wp_reset_postdata();
		}

		/**
		 * Outputs the options form on admin
		 *
		 * @param array $instance The widget options
		 */
		public function form($instance) {
			if (isset($instance['title'])) {
				$title = $instance['title'];
			} else {
				$title = esc_html__('Recent Collections:', 'fpdomain');
			}
			
			if (isset($instance['rows']) && is_numeric($instance['rows'])) {
				$rows = $instance['rows'];
			} else {
				$rows = 3;
			}
			
			if (isset($instance['sortby'])) {
				$sortby = $instance['sortby'];
			} else {
				$sortby = esc_html__('Recent collections', 'fpdomain');
			}
			
			$raw_id = explode("-", $this->get_field_id("widget_id"));
			$id = $raw_id[1] . "-" . $raw_id[2];
			?>
			
			<p>
				<label for="<?php echo ($this->get_field_id('title')); ?>"><?php _e('Title:'); ?></label>
				<input class="widefat" id="<?php echo($this->get_field_id('title')); ?>" name="<?php echo($this->get_field_name('title')); ?>" type="text" value="<?php echo(esc_attr($title)); ?>" />
			</p>
			<p>
				<label for="<?php echo ($this->get_field_id('rows')); ?>"><?php _e('Rows:'); ?></label>
				<input class="widefat" id="<?php echo($this->get_field_id('rows')); ?>" name="<?php echo($this->get_field_name('rows')); ?>" type="number" value="<?php echo(esc_attr($rows)); ?>" />
			</p>
			<p>
				<label for="<?php echo ($this->get_field_id('sortby')); ?>"><?php _e('Sort by:'); ?></label>
				<select class="widefat" id="<?php echo($this->get_field_id('sortby')); ?>" name="<?php echo($this->get_field_name('sortby')); ?>">
					<?php
						$arr = array(esc_html__('Recent collections', 'fpdomain'), esc_html__('Most collected', 'fpdomain'));
						foreach ($arr as $value) {
							if (esc_attr($sortby) == $value) {
								echo '<option value="' . $value . '" selected>' . $value . '</option>';
							} else {
								echo '<option value="' . $value . '">' . $value . '</option>';
							}
						}
					?>
				</select>
			</p>
			<?php
		}

		/**
		 * Processing widget options on save
		 *
		 * @param array $new_instance The new options
		 * @param array $old_instance The previous options
		 */
		public function update($new_instance, $old_instance) {
			$instance = array();
			$newTitle = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
			$newRows = (!empty($new_instance['rows'])) ? strip_tags($new_instance['rows']) : 3;
			$newSort = (!empty($new_instance['sortby'])) ? strip_tags($new_instance['sortby']) : __('Recent collections', 'fpdomain');
            
			$newTitle = sanitize_text_field($newTitle);
			$newRows = sanitize_text_field($newRows);
			$newSort = sanitize_text_field($newSort);
            
			$instance['title'] = $newTitle;
			$instance['rows'] = $newRows;
			$instance['sortby'] = $newSort;
            
			return $instance;
			
			//$instance = $old_instance;
			//$instance['number'] = (int) $new_instance['number'];
			//return $instance;
		}
	}
}

?>
