<?php

/**
 * Helper class for creating hash.
 *
 */
class easy_fundraisers_payex_hash {
    
    private $md5;
    
    function __construct($_md5){
        if($_md5 == false){
            $this->md5 = false;
        }
        else{
            $this->md5 = true;
        }
    }
    
        /**
         * Returns the input array with addition of calculated hash.
	 *
         * @param array $paramArray an array with empty hash key.
	 * @param string $encryptionKey the encryption key used to make the hash.
	 * @return array an array with the same values as $paramArray with the addition of 'hash'.
         */
        function createHash($paramArray, $encryptionKey)
        {
            if($this->md5){
                return $this->createMD5($paramArray, $encryptionKey);
            }
            else{
                return $this->createSHA1($paramArray, $encryptionKey);
            }
        }


	function createMD5($paramArray, $encryptionKey){
	
		$param = $paramArray;
		
		$stringToHash = implode("", $param);
		$stringToHash .= $encryptionKey;
		$hash = md5($stringToHash);
		
		$param['hash'] = $hash;
		return $param;
		
        }
        
        function createSHA1($paramArray, $encryptionKey){
            
                $param = $paramArray;
		
		$stringToHash = implode("", $param);
		$stringToHash .= $encryptionKey;
		$hash = sha1($stringToHash);
		
		$param['hash'] = $hash;
		return $param;
        }
}

?>
