<?php

include_once 'payexHash.php';

/**
 * Class that handles calling PxOrder API.
 * http://www.payexpim.com/category/pxorder/
 *
 * @param boolean $testMode Decides if running testmode or not.
 * @param boolean $md5 set to true for MD5 hash algorithm, false for SHA1.
 */
class easy_fundraisers_px_order_methods {

    private $PxOrderWSDL;
    private $payexHash;
    private $soapObject;
    private $encryptionKey;

    function __construct($testMode, $md5, $encrKey) {

        $this->payexHash = new easy_fundraisers_payex_hash($md5);

        if (strval($testMode) == "STAGE") {
            $this->PxOrderWSDL = "https://stage-external.payex.com/pxorder/pxorder.asmx?wsdl"; //TEST ENVIRONMENT
        } else if ($testMode == true) {
            $this->PxOrderWSDL = "https://test-external.payex.com/pxorder/pxorder.asmx?wsdl"; //STAGE ENVIRONMENT
        } else {
            $this->PxOrderWSDL = "https://external.payex.com/pxorder/pxorder.asmx?wsdl"; //PRODUCTION ENVIRONMENT
        }

        $this->soapObject = new SoapClient($this->PxOrderWSDL, array("trace" => 1));
        
        $this->encryptionKey = $encrKey;
    }

    /**
     * Returns the last SOAP request sent by this class.
     *
     * @return string a string containing headers and body of the last SOAP request.
     */
    function getLastRequest() {

        $request = "Request headers: " . $this->soapObject->__GetLastRequestHeaders() . "\n" . "Request body: " . $this->soapObject->__getLastRequest();

        return $request;
    }

    /**
     * Returns the last SOAP response sent by this class.
     *
     * @return string a string containing headers and body of the last SOAP request.
     */
    function getLastResponse() {
        $response = "Response headers: " . $this->soapObject->__getLastRequestHeaders() . "\n" . "Response body: " . $this->soapObject->__getLastResponse();

        return $response;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/addorderaddress2/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     * 
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API.
     */
    function addOrderAddress2($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->AddOrderAddress2($param);

        $simpleResponseXML = new simpleXMLelement($result->{'AddOrderAddress2Result'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/addsingleorderline2/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     * 
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API.
     */
    function addSingleOrderLine2($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->AddSingleOrderLine2($param);

        $simpleResponseXML = new simpleXMLelement($result->{'AddSingleOrderLine2Result'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/getaddressbypaymentmethod/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     * 
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API.
     */
    function getAddressByPaymentMethod($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->GetAddressByPaymentMethod($param);

        $simpleResponseXML = new simpleXMLelement($result->{'GetAddressByPaymentMethodResult'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/initialize8/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     * 
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API.
     */
    function initialize8($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->Initialize8($param);

        $simpleResponseXML = new simpleXMLelement($result->{'Initialize8Result'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/cancel2/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     *
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API
     */
    function cancel2($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->Cancel2($param);

        $simpleResponseXML = new simpleXMLelement($result->{'Cancel2Result'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/capture5/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     *
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API
     */
    function capture5($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->Capture5($param);

        $simpleResponseXML = new simpleXMLelement($result->{'Capture5Result'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/credit5/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     *
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API
     */
    function credit5($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->Credit5($param);
        var_dump($result);

        $simpleResponseXML = new simpleXMLelement($result->{'Credit5Result'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/check2/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     *
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API
     */
    function check2($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->Check2($param);

        $simpleResponseXML = new simpleXMLelement($result->{'Check2Result'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/gettransactiondetails2/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     *
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API
     */
    function gettransactiondetails2($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->GetTransactionDetails2($param);

        $simpleResponseXML = new simpleXMLelement($result->{'GetTransactionDetails2Result'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/purchasefinancinginvoice/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     *
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API
     */
    function purchasefinancinginvoice($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->PurchaseFinancingInvoice($param);

        $simpleResponseXML = new simpleXMLelement($result->{'PurchaseFinancingInvoiceResult'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/purchasecreditaccount/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     *
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API
     */
    function purchasecreditaccount($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->PurchaseCreditAccount($param);

        $simpleResponseXML = new simpleXMLelement($result->{'PurchaseCreditAccountResult'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/purchaseinvoiceprivate/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     *
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API
     */
    function purchaseinvoiceprivate($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->PurchaseInvoicePrivate($param);

        $simpleResponseXML = new simpleXMLelement($result->{'PurchaseInvoicePrivateResult'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/purchaseinvoicecorporate/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     *
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API
     */
    function purchaseinvoicecorporate($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->PurchaseInvoiceCorporate($param);

        $simpleResponseXML = new simpleXMLelement($result->{'PurchaseInvoiceCorporateResult'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/complete/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     *
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API
     */
    function complete($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->Complete($param);

        $simpleResponseXML = new simpleXMLelement($result->{'CompleteResult'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/finalizetransaction/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     *
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API
     */
    function finalizetransaction($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->FinalizeTransaction($param);

        $simpleResponseXML = new simpleXMLelement($result->{'FinalizeTransactionResult'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/technical-reference/pxorder/getapproveddeliveryaddress/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     *
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API
     */
    function getapproveddeliveryaddress($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->GetApprovedDeliveryAddress($param);

        $simpleResponseXML = new simpleXMLelement($result->{'GetApprovedDeliveryAddressResult'});

        return $simpleResponseXML;
    }
    
    /**
     * http://www.payexpim.com/uncategorized/prepareswish/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     *
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API
     */
    function preparePurchaseSwish($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->PreparePurchaseSwish($param);

        $simpleResponseXML = new simpleXMLelement($result->{'PreparePurchaseSwishResult'});

        return $simpleResponseXML;
    }

    /**
     * http://www.payexpim.com/payment-methods/wywallet-mobilbetalning/
     * Hash will be calculated by the method, therefore send in an empty 'Hash' parameter.
     *
     * @param array $paramArray An array with the parameters you are sending.
     * @return object $simpleResponseXML A simpleXML-object of the response from PayEx API
     */
    function purchasePremiumSms($paramArray) {

        $param = $this->payexHash->createHash($paramArray, $this->encryptionKey);

        $result = $this->soapObject->PurchasePremiumSms($param);

        $simpleResponseXML = new simpleXMLelement($result->{'PurchasePremiumSmsResult'});

        return $simpleResponseXML;
    }
}

?>