<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

?>
<form id="create-collection" action="#" method="post" enctype="multipart/form-data">
		<?php
			wp_nonce_field( 'easy_fundraisers_create_collection', 'easy_fundraisers_create_collection_nonce' );
			$easy_fundraisers_options = get_option('easy_fundraisers_newcol_settings_arraykey');
			$easy_fundraisers_newcol_options = get_option('easy_fundraisers_newcol_settings_arraykey');
			$easy_fundraisers_email_options = get_option('easy_fundraisers_email_settings_arraykey');
			$easy_fundraisers_payex_options = get_option( 'easy_fundraisers_payex_settings_arraykey' );
			$easy_fundraisers_payex_currency = esc_html($easy_fundraisers_payex_options["payex_currency"]);
		?>

		<p> <?php echo $easy_fundraisers_newcol_options["registration_text"]; ?> </p>

		<table>
			<tr>
				<td>
					<label for="sfl_firstname"><?php echo esc_html__('First name', 'fpdomain') . ": (" . esc_html__('3-100 characters', 'fpdomain') . ")"; ?></label>
					<?php
						if (!isset($_POST['firstname']) || empty($_POST['firstname'])) {
							echo '<input type="text" name="firstname" id="firstname" maxlength="100" placeholder="' . esc_html__('My first name', 'fpdomain') . '" />';
						} else {
							echo '<input type="text" name="firstname" id="firstname" maxlength="100" placeholder="' . esc_html__('My first name', 'fpdomain') . '" value="' . sanitize_text_field($_POST['firstname']) . '" />';
						}
					?>
				</td>
				<td>
					<label for="lastname"><?php echo esc_html__('Last name', 'fpdomain') . ": (" . esc_html__('3-100 characters', 'fpdomain') . ")"; ?></label>
					<?php
						if (!isset($_POST['lastname']) || empty($_POST['lastname'])) {
							echo '<input type="text" name="lastname" id="lastname" maxlength="100" placeholder="' . esc_html__('My last name', 'fpdomain') . '" />';
						} else {
							echo '<input type="text" name="lastname" id="lastname" maxlength="100" placeholder="' . esc_html__('My last name', 'fpdomain') . '" value="' . sanitize_text_field($_POST['lastname']) . '" />';
						}
					?>
				</td>
			</tr>
			<tr>
				<td>
					<label for="email"><?php echo esc_html__('E-mail', 'fpdomain') . ": (" . esc_html__('3-100 characters', 'fpdomain') . ")"; ?></label>
					<?php
						if (!isset($_POST['email']) || empty($_POST['email'])) {
							echo '<input type="email" name="email" id="email" maxlength="100" placeholder="' . esc_html__('my@email.com', 'fpdomain') . '" />';
						} else {
							echo '<input type="email" name="email" id="email" maxlength="100" placeholder="' . esc_html__('my@email.com', 'fpdomain') . '" value="' . sanitize_text_field($_POST['email']) . '" />';
						}
					?>
				<td>
			</tr>
			<tr>
				<td>
					<label for="password"><?php echo esc_html__('Password', 'fpdomain') . ": (" . esc_html__('6-16 characters', 'fpdomain') . ")"; ?></label>
					<input type="password" name="password" id="password" maxlength="16" placeholder="********" />
				</td>
				<td>
					<label for="cpassword"><?php echo esc_html__('Confirm password', 'fpdomain') . ": "; ?></label>
					<input type="password" name="cpassword" id="cpassword" maxlength="16" placeholder="********" />
				</td>
			</tr>
		</table>

		<hr /><!-- H. Line -->

		<table>
			<tr>
				<td>
					<label for="collectioncategory"><?php echo esc_html__('Collection category', 'fpdomain') . ": "; ?></label>
					<?php
						$easy_fundraisers_terms = get_terms( array(
							'taxonomy' => 'collectioncategory',
							'hide_empty' => false,
						));
					?>
					<select name="collectioncategory" id="collectioncategory">
						<?php
						if (!isset($_POST['collectioncategory']) || empty($_POST['collectioncategory'])) {
							foreach ( $easy_fundraisers_terms as $term ) {
								if ( $easy_fundraisers_newcol_options["default_category"] == $term->slug ){
									echo '<option value="' . $term->slug . '" selected>' . $term->name . '</option>';
								} else {
									echo '<option value="' . $term->slug . '">' . $term->name . '</option>';
								}
							}
						} else {
							foreach ( $easy_fundraisers_terms as $term ) {
								if ( $_POST['collectioncategory'] == $term->slug ){
									echo '<option value="' . $term->slug . '" selected>' . $term->name . '</option>';
								} else {
									echo '<option value="' . $term->slug . '">' . $term->name . '</option>';
								}
							}
						}
						?>
					</select>
				</td>
			</tr>
			<tr>
				<td>
					<label for="collectionname"><?php echo esc_html__('Collection name', 'fpdomain') . ": (" . esc_html__('3-100 characters', 'fpdomain') . ")"; ?></label>
					<?php
						if (!isset($_POST['collectionname']) || empty($_POST['collectionname'])) {
							echo '<input type="text" name="collectionname" id="collectionname" maxlength="100" placeholder="' . esc_html($easy_fundraisers_newcol_options["collection_name"]) . '" />';
						} else {
							echo '<input type="text" name="collectionname" id="collectionname" maxlength="100" placeholder="' . esc_html($easy_fundraisers_newcol_options["collection_name"]) . '" value="' . sanitize_text_field($_POST['collectionname']) . '" />';
						}
					?>
				</td>
				<td>
					<label for="collectiongoal"><?php echo esc_html__('Collection goal', 'fpdomain') . ' (' . $easy_fundraisers_payex_currency . '): '; ?></label>
					<?php
						if (!isset($_POST['collectiongoal']) || empty($_POST['collectiongoal'])) {
							echo '<input type="number" min="1" name="collectiongoal" id="collectiongoal" placeholder="2500" />';
						} else {
							echo '<input type="number" min="1" name="collectiongoal" id="collectiongoal" placeholder="2500" value="' . sanitize_text_field($_POST['collectiongoal']) . '" />';
						}
					?>
				</td>
			</tr>

		</table>

		<table>
			<tr>
				<td>
					<label for="collectionenddate_year"><?php echo esc_html__('Finish year', 'fpdomain') . ": "; ?></label>
					<!-- Print years-->
					<select name="collectionenddate_year" id="collectionenddate_year">
						<?php
							$finishYear = date('Y', strtotime('+' . esc_html($easy_fundraisers_newcol_options["finish_date_limit"]) . ' months'));

							for ($year = date("Y"); $year <= $finishYear; $year++) {
								echo '<option value="' . $year . '">' . $year . '</option>';
							}

						?>
					</select>
				</td>
				<td>
					<label for="collectionenddate_month"><?php echo esc_html__('Finish month', 'fpdomain') . ": "; ?></label>
				<!-- Print months -->
					<select name="collectionenddate_month" id="collectionenddate_month">
						<?php

						for ($month = 1; $month <= 12; $month++) {
							echo '<option value="' . $month . '">' . date('F', mktime(0, 0, 0, $month, 10)) . '</option>';
						}

						?>
					</select>
				</td>
				<td>
					<label for="collectionenddate_day"><?php echo esc_html__('Finish day', 'fpdomain') . ": "; ?></label>
					<!-- Print days -->
					<select name="collectionenddate_day" id="collectionenddate_day">
						<?php

						for ($day = 1; $day <= 31; $day++) {
							echo '<option value="' . $day . '">' . $day . '</option>';
						}

						?>
					</select>
				</td>
			</tr>
		</table>

		<label for="collectiondescription"><?php echo esc_html__('Collection description', 'fpdomain') . ": (" . esc_html__('20-500 characters', 'fpdomain') . ")"; ?></label>
		<?php
			if (!isset($_POST['collectiondescription']) || empty($_POST['collectiondescription'])) {
				echo '<textarea name="collectiondescription" id="collectiondescription" rows="3" maxlength="500"  placeholder="' . esc_html($easy_fundraisers_newcol_options["collection_desc"]) . '"></textarea>';
			} else {
				echo '<textarea name="collectiondescription" id="collectiondescription" rows="3" maxlength="500">' . sanitize_text_field($_POST['collectiondescription']) . '</textarea>';
			}
		?>

		<label for="collectionemailreply"><?php echo esc_html__('Email reply', 'fpdomain') . ": (" . esc_html__('20-500 characters', 'fpdomain') . ")<br />" . wp_kses($easy_fundraisers_newcol_options["email_reply_info"], $easy_fundraisers_html_tags); ?></label>
		<?php
			if (!isset($_POST['collectionemailreply']) || empty($_POST['collectionemailreply'])) {
				echo '<textarea name="collectionemailreply" id="collectionemailreply" rows="3" maxlength="500">' . esc_html($easy_fundraisers_newcol_options["email_reply"]) . '</textarea>';
			} else {
				echo '<textarea name="collectionemailreply" id="collectionemailreply" rows="3" maxlength="500">' . sanitize_text_field($_POST['collectionemailreply']) . '</textarea>';
			}
		?>
		<p style="text-align: center; margin-top: 2em;">
			<?php
				esc_html_e('Choose an image and create your collection!', 'fpdomain');
				echo '<br />';
				esc_html_e('Please double check your entries, so far only admins can make changes afterwards.', 'fpdomain');
				echo '<br /><br />
				<input type="checkbox" name="tos_checkbox" id="tos_checkbox" value="accept_tos_checkbox" />
				&nbsp' . wp_kses($easy_fundraisers_newcol_options["default_checkbox_text"], $easy_fundraisers_html_tags);
			?>
		</p>
		<table>
			<tr>
				<td>
					<div style="text-align:center;vertical-align: middle;">
						<input type="file" id="cpostimage" name="cpostimage" class="upload" multiple="false" />
					</div>
				</td>
			</tr>
			<tr>
				<td>
					<div style="text-align:center;vertical-align: middle;">
						<input type="submit" id="cpostsubmit" value="<?php echo esc_html__('Create collection', 'fpdomain'); ?>" style="display: inline-block;vertical-align: middle;" />
					</div>
				</td>
			</tr>
		</table>
</form>
