<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

$easy_fundraisers_reply;
$easy_fundraisers_success = false;

if (isset($_POST['easy_fundraisers_create_collection_nonce']) && wp_verify_nonce($_POST['easy_fundraisers_create_collection_nonce'], 'easy_fundraisers_create_collection')) {

	$easy_fundraisers_sanitized = false;
	$easy_fundraisers_loginFail = false;
	$easy_fundraisers_existingPost = false;
	$easy_fundraisers_insertNewUser = true;

	$easy_fundraisers_options = get_option('easy_fundraisers_newcol_settings_arraykey');

	// Sanitize input
	if (!isset($_POST['firstname']) || empty($_POST['firstname'])) {
		$easy_fundraisers_reply = esc_html__('Please choose a first name!', 'fpdomain');

	} else if (!isset($_POST['lastname']) || empty($_POST['lastname'])) {
		$easy_fundraisers_reply = esc_html__('Please choose a last name!', 'fpdomain');

	} else if (!isset($_POST['email']) || empty($_POST['email'])) {
		$easy_fundraisers_reply = esc_html__('Please choose an e-mail!', 'fpdomain');

	} else if (!isset($_POST['password']) || empty($_POST['password'])) {
		$easy_fundraisers_reply = esc_html__('Please choose a password!', 'fpdomain');

	} else if (!isset($_POST['cpassword']) || empty($_POST['cpassword'])) {
		$easy_fundraisers_reply = esc_html__('Please confirm your password!', 'fpdomain');

	} else if (!isset($_POST['collectionname']) || empty($_POST['collectionname'])) {
		$easy_fundraisers_reply = esc_html__('Please choose a collection name!', 'fpdomain');

	} else if (!isset($_POST['collectiondescription']) || empty($_POST['collectiondescription'])) {
		$easy_fundraisers_reply = esc_html__('Please choose a collection description!', 'fpdomain');

	} else if (!isset($_POST['collectionemailreply']) || empty($_POST['collectionemailreply'])) {
		$easy_fundraisers_reply = esc_html__('Please choose an e-mail reply!', 'fpdomain');

	} else if (!isset($_POST['collectioncategory']) || empty($_POST['collectioncategory'])) {
		$easy_fundraisers_reply = esc_html__('Please choose a collection category!', 'fpdomain');

	} else if (!isset($_POST['collectiongoal']) || empty($_POST['collectiongoal'])) {
		$easy_fundraisers_reply = esc_html__('Please choose a collection goal!', 'fpdomain');

	} else if (!isset($_POST['collectionenddate_year']) || empty($_POST['collectionenddate_year']) ||
				!isset($_POST['collectionenddate_month']) || empty($_POST['collectionenddate_month']) ||
				!isset($_POST['collectionenddate_day']) || empty($_POST['collectionenddate_day'])) {
		$easy_fundraisers_reply = esc_html__('Please choose a finish date!', 'fpdomain');

	} else if (!isset($_FILES['cpostimage'])) {
		$easy_fundraisers_reply = esc_html__('Please upload an image for the collection!', 'fpdomain');

	} else if ($_FILES['cpostimage']['error'] > 0) {
		$easy_fundraisers_reply = esc_html__('Please upload an image for the collection!', 'fpdomain');

	} else {
		$easy_fundraisers_firstname = sanitize_text_field($_POST['firstname']);
		$easy_fundraisers_lastname = sanitize_text_field($_POST['lastname']);
		$easy_fundraisers_email = sanitize_email($_POST['email']);
		$easy_fundraisers_password = sanitize_text_field($_POST['password']);
		$easy_fundraisers_cpassword = sanitize_text_field($_POST['cpassword']);
		$easy_fundraisers_collectionname = sanitize_text_field($_POST['collectionname']);
		$easy_fundraisers_collectioncategory = sanitize_text_field($_POST['collectioncategory']);
		$easy_fundraisers_collectiongoal = sanitize_text_field($_POST['collectiongoal']);
		$easy_fundraisers_collectionenddate_year = sanitize_text_field($_POST['collectionenddate_year']);
		$easy_fundraisers_collectionenddate_month = sanitize_text_field($_POST['collectionenddate_month']);
		$easy_fundraisers_collectionenddate_day = sanitize_text_field($_POST['collectionenddate_day']);

		$easy_fundraisers_new_line = "\n";
		$easy_fundraisers_new_line_substitute = "NEWLINE-SUBSTITUTE3214";
		$easy_fundraisers_fixed_description = str_replace($easy_fundraisers_new_line, $easy_fundraisers_new_line_substitute, $_POST['collectiondescription'] );
		$easy_fundraisers_sanitized_desc = sanitize_text_field( $easy_fundraisers_fixed_description );
		$easy_fundraisers_collectiondescription = str_replace($easy_fundraisers_new_line_substitute, $easy_fundraisers_new_line, $easy_fundraisers_sanitized_desc );

		$easy_fundraisers_fixed_emailreply = str_replace($easy_fundraisers_new_line, $easy_fundraisers_new_line_substitute, $_POST['collectionemailreply'] );
		$easy_fundraisers_sanitized_reply = sanitize_text_field( $easy_fundraisers_fixed_emailreply );
		$easy_fundraisers_collectionemailreply = str_replace($easy_fundraisers_new_line_substitute, $easy_fundraisers_new_line, $easy_fundraisers_sanitized_reply );

		if (strlen($easy_fundraisers_firstname) < 3) {
			$easy_fundraisers_reply = esc_html__('The submitted first name is too short!', 'fpdomain');

		} else if (strlen($easy_fundraisers_firstname) > 100) {
			$easy_fundraisers_reply = esc_html__('The submitted first name is too long!', 'fpdomain');

		} else if (strlen($easy_fundraisers_lastname) < 3) {
			$easy_fundraisers_reply = esc_html__('The submitted last name is too short!', 'fpdomain');

		} else if (strlen($easy_fundraisers_lastname) > 100) {
			$easy_fundraisers_reply = esc_html__('The submitted last name is too long!', 'fpdomain');

		} else if (strlen($easy_fundraisers_email) < 3) {
			$easy_fundraisers_reply = esc_html__('The chosen e-mail is too short!', 'fpdomain');

		} else if (strlen($easy_fundraisers_email) > 100) {
			$easy_fundraisers_reply = esc_html__('The chosen e-mail is too long!', 'fpdomain');

		} else if (strlen($easy_fundraisers_password) < 6) {
			$easy_fundraisers_reply = esc_html__('The chosen password is too short!', 'fpdomain');

		} else if (strlen($easy_fundraisers_password) > 16) {
			$easy_fundraisers_reply = esc_html__('The chosen password is too long!', 'fpdomain');

		} else if ($easy_fundraisers_password != $easy_fundraisers_cpassword) {
			$easy_fundraisers_reply = esc_html__('The passwords does not match!', 'fpdomain');

		} else if (strlen($easy_fundraisers_collectionname) < 3) {
			$easy_fundraisers_reply = esc_html__('The collection name is too short!', 'fpdomain');

		} else if (strlen($easy_fundraisers_collectionname) > 100) {
			$easy_fundraisers_reply = esc_html__('The collection name is too long!', 'fpdomain');

		} else if (strlen($easy_fundraisers_collectiondescription) < 20) {
			$easy_fundraisers_reply = esc_html__('The collection description is too short!', 'fpdomain');

		} else if (strlen($easy_fundraisers_collectiondescription) > 500) {
			$easy_fundraisers_reply = esc_html__('The collection description is too long!', 'fpdomain');

		} else if (strlen($easy_fundraisers_collectionemailreply) < 20) {
			$easy_fundraisers_reply = esc_html__('The chosen e-mail reply is too short', 'fpdomain');

		} else if (strlen($easy_fundraisers_collectionemailreply) > 500) {
			$easy_fundraisers_reply = esc_html__('The chosen e-mail reply is too long', 'fpdomain');

		} else if (strlen($easy_fundraisers_collectioncategory) < 2) {
			$easy_fundraisers_reply = esc_html__('The selected category is invalid!', 'fpdomain');

		// No need to check length of goal, year, month, or day

		} else {

			if (!ctype_alpha($easy_fundraisers_firstname)) {
				$easy_fundraisers_reply = esc_html__('The submitted first name is invalid!', 'fpdomain');

			} else if (!ctype_alpha($easy_fundraisers_lastname)) {
				$easy_fundraisers_reply = esc_html__('The submitted last name is invalid!', 'fpdomain');

			} else if (!filter_var($easy_fundraisers_email, FILTER_VALIDATE_EMAIL)) {
				$easy_fundraisers_reply = esc_html__('The chosen e-mail is invalid!', 'fpdomain');

			// Collection name and category may contain space

			} else if (!is_numeric($easy_fundraisers_collectiongoal) || !($easy_fundraisers_collectiongoal > 0 && $easy_fundraisers_collectiongoal < PHP_INT_MAX)) {
				$easy_fundraisers_reply = esc_html__('The chosen goal is invalid!', 'fpdomain');

			} else if (!is_numeric($easy_fundraisers_collectionenddate_year) || !($easy_fundraisers_collectionenddate_year > 2016 && $easy_fundraisers_collectionenddate_year < PHP_INT_MAX)) {
				$easy_fundraisers_reply = esc_html__('The selected year is invalid!', 'fpdomain');

			} else if (!is_numeric($easy_fundraisers_collectionenddate_month) || !($easy_fundraisers_collectionenddate_month > 0 && $easy_fundraisers_collectionenddate_month < 13)) {
				$easy_fundraisers_reply = esc_html__('The selected month is invalid!', 'fpdomain');

			} else if (!is_numeric($easy_fundraisers_collectionenddate_day) || !($easy_fundraisers_collectionenddate_day > 0 && $easy_fundraisers_collectionenddate_day < 32)) {
				$easy_fundraisers_reply = esc_html__('The selected day is invalid!', 'fpdomain');

			} else if (!isset($_POST['tos_checkbox']) || empty($_POST['tos_checkbox']) || $_POST['tos_checkbox'] != 'accept_tos_checkbox') {
                $easy_fundraisers_newcol_options = get_option('easy_fundraisers_newcol_settings_arraykey');
				$easy_fundraisers_default_tos_text = $easy_fundraisers_newcol_options["default_checkbox_text"];
				$easy_fundraisers_reply = esc_html__( 'Please accept the', 'fpdomain' ) . ' ' . wp_kses($easy_fundraisers_default_tos_text, $easy_fundraisers_html_tags) . '!';

			} else {
				$easy_fundraisers_finish_time = strtotime('+' . esc_html($easy_fundraisers_options["finish_date_limit"]) . ' months');

				$easy_fundraisers_time = strtotime($easy_fundraisers_collectionenddate_year . '-' . $easy_fundraisers_collectionenddate_month . '-' . $easy_fundraisers_collectionenddate_day);

				if ($easy_fundraisers_time > $easy_fundraisers_finish_time) {
					$easy_fundraisers_reply = esc_html__('Please choose an earlier finish date!', 'fpdomain');
				} else if ($easy_fundraisers_time <= strtotime("+1 day")) {
					$easy_fundraisers_reply = esc_html__('Please choose a later finish date!', 'fpdomain');
				} else {
					$easy_fundraisers_sanitized = true;
				}
			}
		}
	}

	// Validate the user
	if ($easy_fundraisers_sanitized) {

		// If email doesn't exist => Generate new username (wait with account creation)
		if (!email_exists($easy_fundraisers_email)) {

			$easy_fundraisers_username = $easy_fundraisers_firstname . $easy_fundraisers_lastname;
			$easy_fundraisers_i = 0;

			while (username_exists($easy_fundraisers_username)) {
				$easy_fundraisers_username .= rand(0, 9);
				$easy_fundraisers_i++;

				if ($easy_fundraisers_i > 50) {// Extremely unlikely
					$easy_fundraisers_reply = _esc_html_('Unknown error occurred!', 'fpdomain');
					$easy_fundraisers_loginFail = true;
				}
			}

		// If email already exist, try to login
		} else {
			$easy_fundraisers_userWithEmail = get_user_by('email', $easy_fundraisers_email);
			$easy_fundraisers_user = wp_authenticate_username_password(NULL, $easy_fundraisers_userWithEmail->user_login, $easy_fundraisers_password);
			if (is_wp_error($easy_fundraisers_user)) {
				$easy_fundraisers_reply = esc_html__('This e-mail is already registred, please use the password for that account!', 'fpdomain');
				$easy_fundraisers_loginFail = true;
			} else {
				$easy_fundraisers_insertNewUser = false;// Login successful, no need to create new user
			}
		}
	}

	// Make sure category exist and collection doesn't.
	if ($easy_fundraisers_sanitized && !$easy_fundraisers_loginFail) {

		if (!is_admin()) {// Required for post_exists
			require_once(realpath(ABSPATH . '/wp-admin/includes/post.php'));
		}

		$easy_fundraisers_term_category = term_exists($easy_fundraisers_collectioncategory, 'collectioncategory');// For any post type?
		if ($easy_fundraisers_term_category == null || $easy_fundraisers_term_category == 0) {
			$easy_fundraisers_reply = esc_html__('The selected category is invalid!', 'fpdomain');
			$easy_fundraisers_existingPost = true;
		}
/*		} else if (post_exists($easy_fundraisers_collectionname) != 0) {
			$easy_fundraisers_reply = __('A collection already exist with this name!', 'fpdomain');
			$easy_fundraisers_existingPost = true;
		}*/
	}

	// Create user and collection
	// What if a user was created and the post insertion fails?
	if ($easy_fundraisers_sanitized && !$easy_fundraisers_loginFail && !$easy_fundraisers_existingPost) {

		$easy_fundraisers_insertPost = false;

		// Create new user
		if ($easy_fundraisers_insertNewUser) {
			$easy_fundraisers_user_id = wp_create_user($easy_fundraisers_username, $easy_fundraisers_password, $easy_fundraisers_email);
			if (is_wp_error($easy_fundraisers_user_id)) {
				$easy_fundraisers_reply = esc_html__('Unknown error occurred!', 'fpdomain');

			} else {
				$easy_fundraisers_user = get_user_by('id', $easy_fundraisers_user_id);
				$easy_fundraisers_user->remove_role('subscriber');
				$easy_fundraisers_user->add_role('collector');

				$easy_fundraisers_user_update = wp_update_user(array('ID' => $easy_fundraisers_user_id,
												'first_name' => $easy_fundraisers_firstname,
												'last_name' => $easy_fundraisers_lastname,
												'display_name' => $easy_fundraisers_firstname . ' ' . $easy_fundraisers_lastname));

				if (is_wp_error($easy_fundraisers_user_update)) {
					$easy_fundraisers_reply = __('Unknown error occurred!', 'fpdomain');

				} else {
					$easy_fundraisers_insertPost = true;// Creation successful, signal for new post
				}
			}
		}

		// Insert post if existing user, or if new user inserted correctly.
		if (!$easy_fundraisers_insertNewUser || ($easy_fundraisers_insertNewUser && $easy_fundraisers_insertPost)) {
			$easy_fundraisers_arrs = array(
				'post_author' => get_user_by('email', $easy_fundraisers_email)->ID,
				'post_content' => $easy_fundraisers_collectiondescription,
				'post_title' => $easy_fundraisers_collectionname,
				'post_status' => 'pending',
				'post_type' => 'collection',
				'tax_input' => array('collectioncategory' => $easy_fundraisers_collectioncategory),
			);

			$easy_fundraisers_post_id = wp_insert_post($easy_fundraisers_arrs);
			if (is_wp_error($easy_fundraisers_post_id)) {
				$easy_fundraisers_reply = esc_html__('Unknown error occurred!', 'fpdomain');

			} else {
				$easy_fundraisers_reply = wp_kses($easy_fundraisers_options["created_text"], $easy_fundraisers_html_tags);
				$easy_fundraisers_success = true;
			}

			update_post_meta($easy_fundraisers_post_id, 'easy_fundraisers_email_reply', $easy_fundraisers_collectionemailreply);
			update_post_meta($easy_fundraisers_post_id, 'easy_fundraisers_target_amount', $easy_fundraisers_collectiongoal);
			update_post_meta($easy_fundraisers_post_id, 'easy_fundraisers_end_date', $easy_fundraisers_collectionenddate_year . '-' . $easy_fundraisers_collectionenddate_month . '-' . $easy_fundraisers_collectionenddate_day);

			// Upload image
			require_once(realpath(ABSPATH . '/wp-admin/includes/image.php'));
			require_once(realpath(ABSPATH . '/wp-admin/includes/file.php'));
			require_once(realpath(ABSPATH . '/wp-admin/includes/media.php'));
			$easy_fundraisers_attachment_id = media_handle_upload('cpostimage', $easy_fundraisers_post_id);

			if (!is_wp_error($easy_fundraisers_attachment_id)) {
				set_post_thumbnail($easy_fundraisers_post_id, $easy_fundraisers_attachment_id);
			}
		}
	}
}

if (isset($easy_fundraisers_reply)) {
	echo '<div style="padding-bottom:2em;">';
		if ($easy_fundraisers_success) {
			$easy_fundraisers_emails = new easy_fundraisers_emails();
			$easy_fundraisers_emails->easy_fundraisers_send_creation_email($easy_fundraisers_email, $easy_fundraisers_password);
			echo '<div id="sfl-create-collection-reply" class="sfl-create-collection-reply-success">';
		} else {
			echo '<div id="sfl-create-collection-reply">';
		}
		echo '
			<p>
				' . $easy_fundraisers_reply . '
			</p>
		</div>
	</div>';
}

include_once('easy-fundraisers-create-collection-form.php');

?>
