<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

?>
<div class="sfl_preview_container">
<?php

	$easy_fundraisers_w3col_options = get_option('easy_fundraisers_3colwidget_settings_arraykey');
	$easy_fundraisers_payex_options = get_option( 'easy_fundraisers_payex_settings_arraykey' );
	$easy_fundraisers_payex_currency = esc_html($easy_fundraisers_payex_options["payex_currency"]);
	
	if ($easy_fundraisers_w3col_options["sort_by"] == 'recent') {
		$easy_fundraisers_args = array(
			'numberposts' => 2,
			'offset' => 0,
			'category' => 0,
			'orderby' => 'post_date',
			'order' => 'DESC',
			'include' => '',
			'exclude' => '',
			'meta_key' => '',
			'meta_value' =>'',
			'post_type' => 'collection',
			'post_status' => 'publish',
			'suppress_filters' => true
		);
		$easy_fundraisers_posts = wp_get_recent_posts( $easy_fundraisers_args, ARRAY_A );

		echo $easy_fundraisers_args['before_widget'];
		?>
		
		<div id="sfl_widget" class="widget sfl_list_collections_widget">
			<h4 class="h-widget"><?php echo(wp_kses($instance['title'], $easy_fundraisers_html_tags)); ?></h4>
			
			<?php
			foreach( $easy_fundraisers_posts as $easy_fundraisers_recent ) {
				global $wpdb;
				$easy_fundraisers_table = $wpdb->prefix . 'donations';
				$easy_fundraisers_id = $easy_fundraisers_recent["ID"];
				$easy_fundraisers_query = "SELECT SUM(donation_amount) FROM $easy_fundraisers_table WHERE collection_id = $easy_fundraisers_id AND donation_status = 'successful'";
				$easy_fundraisers_total_amount = $wpdb->get_var( $easy_fundraisers_query ) / 100;
				$easy_fundraisers_target_amount = get_post_meta($easy_fundraisers_id, 'easy_fundraisers_target_amount', true);

				$easy_fundraisers_gatheredPercentage = 0;
				$easy_fundraisers_leftPercentage = 0;

				if ($easy_fundraisers_total_amount > 0 && $easy_fundraisers_target_amount > 0) {
					$easy_fundraisers_gatheredPercentage = (($easy_fundraisers_total_amount / $easy_fundraisers_target_amount) * 100);
					$easy_fundraisers_gatheredPercentage = ($easy_fundraisers_gatheredPercentage > 100) ? 100 : $easy_fundraisers_gatheredPercentage;
					$easy_fundraisers_leftPercentage = 100 - $easy_fundraisers_gatheredPercentage;
				}
				?>
				<a href="<?php echo esc_url(get_permalink($easy_fundraisers_id)); ?>">
					<div class="sfl_collection_container yellow-box">
						<div class="sfl_rounded" style="background: url(<?php echo get_the_post_thumbnail_url($easy_fundraisers_id, 'large'); ?>);">
							<div class="sfl_trans_box">
								<?php
									if ($easy_fundraisers_gatheredPercentage > 1) {
										echo'
										<canvas id="postchart' . $easy_fundraisers_id . '" width="300" height="250"></canvas>';
									}
								?>
							</div>
						</div>
						<?php echo '<h3 class="h5"><span>' . $easy_fundraisers_recent["post_title"] . '</span></h3>'; ?>
						<table>
							<tr>
								<td>
									<p style="text-align: center;">
										Gathered:&nbsp&nbsp
										<?php
											echo ($easy_fundraisers_total_amount ? $easy_fundraisers_total_amount : '0') . ' ' . $easy_fundraisers_payex_currency;
										?>
									</p>
								</td>
							</tr>
							<tr>
								<td>
									<p style="text-align: center;">
										Goal:&nbsp&nbsp
										<?php echo $easy_fundraisers_target_amount . ' ' . $easy_fundraisers_payex_currency; ?>
									</p>
								</td>
							</tr>
						</table>
					</div>
				</a>
				<?php
				if ($easy_fundraisers_gatheredPercentage > 1) {
					echo '
					<script>
						var ctx = document.getElementById("postchart' . $easy_fundraisers_id . '");
						var myChart = new Chart(ctx, {
							type: "pie",
							data: {
								datasets: [
								{
									data: [' . $easy_fundraisers_gatheredPercentage . ', ' . $easy_fundraisers_leftPercentage . '],
									backgroundColor: [
										"#3fab5d",
										"rgba(255,255,255,0.5)"
									],
									hoverBackgroundColor: [
										"#3fab5d",
										"rgba(255,255,255,0.5)"
									]
								}]
							},
							options: {
								tooltips: {
									enabled: false
								}
							}
						});
					</script>';
				}
			}
			wp_reset_query();
		} else {
			global $wpdb;
			$easy_fundraisers_table = $wpdb->prefix . 'donations';
			$easy_fundraisers_query = "SELECT id FROM (SELECT collection_id AS id, SUM(donation_amount) AS sum FROM $easy_fundraisers_table WHERE donation_status = 'successful' GROUP BY collection_id) AS subquery ORDER BY sum DESC";
			$easy_fundraisers_num_rows = 0;
			
			foreach($wpdb->get_results($easy_fundraisers_query) as $easy_fundraisers_key => $easy_fundraisers_row) {
				if ($easy_fundraisers_num_rows >= 2) break;
                if (!get_post_status($easy_fundraisers_row->id)) continue;// If post doesn't exist
				$easy_fundraisers_query2 = "SELECT SUM(donation_amount) FROM $easy_fundraisers_table WHERE collection_id = " . $easy_fundraisers_row->id . " AND donation_status = 'successful'";
				$easy_fundraisers_total_amount = $wpdb->get_var($easy_fundraisers_query2) / 100;
				$easy_fundraisers_gatheredPercentage = 0;
				$easy_fundraisers_leftPercentage = 0;
				$easy_fundraisers_id = $easy_fundraisers_row->id;
				$easy_fundraisers_post = get_post($easy_fundraisers_id);
				$easy_fundraisers_target_amount = get_post_meta($easy_fundraisers_id, 'easy_fundraisers_target_amount', true);

				if ($easy_fundraisers_total_amount > 0 && $easy_fundraisers_target_amount > 0) {
					$easy_fundraisers_gatheredPercentage = (($easy_fundraisers_total_amount / $easy_fundraisers_target_amount) * 100);
					$easy_fundraisers_gatheredPercentage = ($easy_fundraisers_gatheredPercentage > 100) ? 100 : $easy_fundraisers_gatheredPercentage;
					$easy_fundraisers_leftPercentage = 100 - $easy_fundraisers_gatheredPercentage;
				}
				?>
				<a href="<?php echo esc_url(get_permalink($easy_fundraisers_id)); ?>">
					<div class="sfl_collection_container yellow-box">
						<div class="sfl_rounded" style="background: url(<?php echo get_the_post_thumbnail_url($easy_fundraisers_id, 'large'); ?>);">
							<div class="sfl_trans_box">
								<?php
									if ($easy_fundraisers_gatheredPercentage > 1) {
										echo'
										<canvas id="postchart' . $easy_fundraisers_id . '" width="300" height="250"></canvas>';
									}
								?>
							</div>
						</div>
						<?php echo '<h3 class="h5"><span>' . get_the_title($easy_fundraisers_id) . '</span></h3>'; ?>
						<table>
							<tr>
								<td>
									<p style="text-align: center;">
										Gathered:&nbsp&nbsp
										<?php
											echo ($easy_fundraisers_total_amount ? $easy_fundraisers_total_amount : '0') . ' ' . $easy_fundraisers_payex_currency;
										?>
									</p>
								</td>
							</tr>
							<tr>
								<td>
									<p style="text-align: center;">
										Goal:&nbsp&nbsp
										<?php echo $easy_fundraisers_target_amount . ' ' . $easy_fundraisers_payex_currency; ?>
									</p>
								</td>
							</tr>
						</table>
					</div>
				</a>
				<?php
				if ($easy_fundraisers_gatheredPercentage > 1) {
					echo '
					<script>
						var ctx = document.getElementById("postchart' . $easy_fundraisers_id . '");
						var myChart = new Chart(ctx, {
							type: "pie",
							data: {
								datasets: [
								{
									data: [' . $easy_fundraisers_gatheredPercentage . ', ' . $easy_fundraisers_leftPercentage . '],
									backgroundColor: [
										"#3fab5d",
										"rgba(255,255,255,0.5)"
									],
									hoverBackgroundColor: [
										"#3fab5d",
										"rgba(255,255,255,0.5)"
									]
								}]
							},
							options: {
								tooltips: {
									enabled: false
								}
							}
						});
					</script>';
				}
				$easy_fundraisers_num_rows++;
			}
			wp_reset_query();
		}
		?>
		<a href="<?php echo esc_url($easy_fundraisers_w3col_options["widget_link"]); ?>">
			<div class="sfl_collection_container create_new yellow-box">
				<img src="<?php echo esc_url($easy_fundraisers_w3col_options["widget_image_link"]); ?>" />
				<?php
					echo '<h3 class="h5"><span>' . wp_kses($easy_fundraisers_w3col_options["widget_title"], $easy_fundraisers_html_tags) . '</span></h3>';
					echo '<p>' . wp_kses($easy_fundraisers_w3col_options["description"], $easy_fundraisers_html_tags) . '</p>';
				?>
			</div>
		</a>
	</div>
</div>
