<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

include( plugin_dir_path( __FILE__ ) . 'payex/PxOrder.php' );

if ( !class_exists( 'easy_fundraisers_payment_manager' ) ) {

	class easy_fundraisers_payment_manager {

		private $easy_fundraisers_test_mode;
		private $easy_fundraisers_account_number;
		private $easy_fundraisers_encryption_key;

		public function __construct() {
			$order_ref = '';
			if ( isset( $_GET['orderRef'] ) ) {
				$order_ref = esc_html($_GET['orderRef']);
			}
			$options = get_option( 'easy_fundraisers_payex_settings_arraykey' );
			$payex_server = esc_html($options["payex_server"]);
			$this->easy_fundraisers_test_mode = ($payex_server == 'test' ? true : false);
			if ( $options ) {
				$this->easy_fundraisers_account_number = esc_html($options['payex_account_number']);
				$this->easy_fundraisers_encryption_key = esc_html($options['payex_encryption_key']);
			} else {
				echo __( 'Please enter your payex account number and encryption key in the admin panel!', 'fpdomain' );
			}
			if ( $order_ref ) {
				$this->easy_fundraisers_complete_payment_process( $order_ref );
			}
		}

		public function easy_fundraisers_initialize_payment_process( $donation_data, $payment_method, $return_url ) {
			$donation_id = $this->easy_fundraisers_save_donation_data( $donation_data );
			if ( is_numeric( $donation_id ) ) {
				$db_donation_data = $this->easy_fundraisers_get_donation_data( $donation_id );
				if ( is_array( $db_donation_data )) {
					$payex_parameters = $this->easy_fundraisers_get_payex_parameters( $db_donation_data, $payment_method, $return_url );
					$this->easy_fundraisers_initialize_payex_process( $payex_parameters );
				}
			}
		}

		public function easy_fundraisers_complete_payment_process( $order_ref ) {
			$params = array(
				'accountNumber' => $this->easy_fundraisers_account_number,
				'orderRef'      => $order_ref,
				'hash'          => ''
			);
			$px_order = new easy_fundraisers_px_order_methods( $this->easy_fundraisers_test_mode, true, $this->easy_fundraisers_encryption_key );
			$result = $px_order->complete( $params, $this->easy_fundraisers_encryption_key );
			if ( strval( $result->status->errorCodeSimple ) == 'OK' ) {
				if ( !isset( $result->transactionNumber ) ) {
					$result->transactionNumber = '';
				}
				if ( (int) $result->transactionStatus == 0 || (int) $result->transactionStatus == 3 ) {
					$result_data = array(
						'donation_id'        => esc_html($result->orderId),
						'donation_amount'    => esc_html($result->amount),
						'donation_status'    => 'successful',
						'transaction_number' => esc_html($result->transactionNumber)
					);
				} else {
					$result_data = array(
						'donation_id'        => esc_html($result->orderId),
						'donation_amount'    => esc_html($result->amount),
						'donation_status'    => 'failed',
						'transaction_number' => esc_html($result->transactionNumber)
					);
				}
				$this->easy_fundraisers_update_donation_data( $result_data );
				return $result_data;
			} else {
				echo ( 'Failed to complete payment process: ' );
				var_dump( $result );
				return;
			}
		}

		private function easy_fundraisers_save_donation_data( $donation_data ) {
			global $wpdb;
			$table = $wpdb->prefix . 'donations';
			$success = $wpdb->insert(
				$table,
				array(
					'collection_id'     => esc_html($donation_data['collection_id']),
					'donation_date'     => date( 'Y-m-d H:s:i', current_time( 'timestamp' ) ),
					'donor_name'        => esc_html($donation_data['donor_name']),
					'donor_email'       => wp_kses($donation_data['donor_email'], $easy_fundraisers_html_tags),
					'donation_amount'   => esc_html($donation_data['donation_amount']),
				),
				array( '%d', '%s', '%s', '%s', '%d' )
			);
			if ( $success ) {
				return $wpdb->insert_id;
			}
		}

		private function easy_fundraisers_get_donation_data( $donation_id ) {
			global $wpdb;
			$table = $wpdb->prefix . 'donations';
			$query = "SELECT * FROM $table WHERE id = $donation_id";
			return $wpdb->get_row( $query, ARRAY_A );
		}

		private function easy_fundraisers_update_donation_data( $donation_data ) {
			global $wpdb;
			$table = $wpdb->prefix . 'donations';
			$success = $wpdb->update(
				$table,
				array(
					'donation_amount'    => esc_html($donation_data['donation_amount']),
					'donation_status'    => esc_html($donation_data['donation_status']),
					'transaction_number' => esc_html($donation_data['transaction_number'])
				),
				array(
					'id' => $donation_data['donation_id']
				),
				array( '%s', '%s', '%s' ),
				array( '%d' )
			);
			return $success;
		}

		private function easy_fundraisers_get_payex_parameters( $donation_data, $payment_method, $return_url ) {
			$payex_options = get_option( 'easy_fundraisers_payex_settings_arraykey' );
			$payex_currency = esc_html($payex_options["payex_currency"]);
			return array(
				'accountNumber'     => intval( $this->easy_fundraisers_account_number ),
				'purchaseOperation' => 'SALE',
				'price'             => (int) round( esc_html($donation_data['donation_amount']) * 100 ),
				'priceArgList'      => '',
				'currency'          => $payex_currency,
				'vat'               => 0,
				'orderID'           => strval( esc_html($donation_data['id']) ),
				'productNumber'     => '1',
				'description'       => 'Collection: ' . esc_html($donation_data['collection_id']),
				'clientIPAddress'   => filter_input(INPUT_SERVER, 'REMOTE_ADDR', FILTER_VALIDATE_IP),
				'clientIdentifier'  => 'USERAGENT=' . filter_input(INPUT_SERVER, 'HTTP_USER_AGENT', FILTER_SANITIZE_SPECIAL_CHARS),
				'additionalValues'  => 'RESPONSIVE=1',
				'externalID'        => '',
				'returnUrl'         => esc_html($return_url),
				'view'              => esc_html($payment_method),
				'agreementRef'      => '',
				'cancelUrl'         => esc_html($return_url),
				'clientLanguage'    => 'sv-SE',
				'hash'              => ''
			);
		}

		private function  easy_fundraisers_initialize_payex_process( $payex_parameters ) {
			$px_order = new easy_fundraisers_px_order_methods( $this->easy_fundraisers_test_mode, true, $this->easy_fundraisers_encryption_key );
			$result = $px_order->initialize8( $payex_parameters );
			if ( strval($result->status->errorCode) == 'OK' ) {
				header( 'Location: ' . strval( $result->redirectUrl ) );
				exit;
			} else {
				echo ( 'Failed to initialize payment process: ' );
				var_dump( $result );
				exit;
			}
		}

	}

}

?>
