<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('easy_fundraisers_emails')) {

	class easy_fundraisers_emails {
		public function easy_fundraisers_setup() {
			add_action( 'phpmailer_init', array( $this, 'easy_fundraisers_init_phmailer' ) );
			add_action( 'transition_post_status', array( $this, 'easy_fundraisers_send_transition_email' ), 10, 3 );
		}

		public function easy_fundraisers_send_transition_email( $new_status, $old_status, $post ) {
			if ( $post->post_type !== 'collection' ) {
				return;
			}

			if ( $new_status === 'publish' && $old_status === 'pending' ) {
				$this->easy_fundraisers_send_accepted_email( $post );
			}

			else if ( $new_status === 'trash' && $old_status === 'pending' ) {
				$this->easy_fundraisers_send_rejected_email( $post );
			}
		}

		public function easy_fundraisers_init_phmailer( $phpmailer ) {
			$options = get_option('easy_fundraisers_email_settings_arraykey');

		    $phpmailer->isSMTP();
		    $phpmailer->Host = ($options['smtp_host']);
		    $phpmailer->SMTPAuth = true; // Force it to use Username and Password to authenticate
		    $phpmailer->Port = ($options['smtp_port']);
		    $phpmailer->Username = ($options['smtp_username']);
		    $phpmailer->Password = ($options['smtp_password']);

		    $phpmailer->SMTPSecure = "tls"; // Choose SSL or TLS, if necessary for your server
		    $phpmailer->From = ($options['smtp_username']);
		    $phpmailer->FromName = ($options['smtp_from_name']);
		}

		public function easy_fundraisers_send_accepted_email( $post ) {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			if ( $options['enable_smtp'] != 'true' ) {
				return;
			}

			$user_id = $post->post_author;
			$user = get_userdata($user_id);
			$email = $user->user_email;

			$body = wp_kses($options['email_reply_accepted_col'], $easy_fundraisers_html_tags);
			$body .= "<br>";
			$body .= "<br>" . wp_kses($options['email_reply_general_footer'], $easy_fundraisers_html_tags);

			$to = $email;
			$subject = esc_html__('Collection accepted','fpdomain');
			$body = $body;
			$headers = array('Content-Type: text/html; charset=UTF-8');

			wp_mail( $to, $subject, $body, $headers );
		}

		public function easy_fundraisers_send_rejected_email( $post ) {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			if ( $options['enable_smtp'] != 'true' ) {
				return;
			}

			$user_id = $post->post_author;
			$user = get_userdata($user_id);
			$email = $user->user_email;

			$body = wp_kses($options['email_reply_rejected_col'], $easy_fundraisers_html_tags);
			$body .= "<br>";
			$body .= "<br>" . wp_kses($options['email_reply_general_footer'], $easy_fundraisers_html_tags);

			$to = $email;
			$subject = esc_html__('Collection rejected','fpdomain');
			$body = $body;
			$headers = array('Content-Type: text/html; charset=UTF-8');

			wp_mail( $to, $subject, $body, $headers );
		}

		public function easy_fundraisers_send_creation_email( $email, $password ) {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			if ( $options['enable_smtp'] != 'true' ) {
				return;
			}

			$body = wp_kses($options['email_reply_new_col'], $easy_fundraisers_html_tags);
			$body .= "<br>";
			$body .= "<br>" . esc_html__('Username: ','fpdomain') . esc_html($email);
			$body .= "<br>" . esc_html__('Password: ','fpdomain') . esc_html($password);
			$body .= "<br>";
			$body .= "<br>" . wp_kses($options['email_reply_general_footer'], $easy_fundraisers_html_tags);

			$to = $email;
			$subject = esc_html__('Collection created','fpdomain');
			$body = $body;
			$headers = array('Content-Type: text/html; charset=UTF-8');

			wp_mail( $to, $subject, $body, $headers );

			$admin_options = get_option('easy_fundraisers_general_settings_arraykey');
			if( $admin_options['enable_notices'] == 'true' && isset( $admin_options['admin_notices_email'] ) ) {
				$this->easy_fundraisers_notify_admin();
			}
		}

		public function easy_fundraisers_notify_admin() {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			if ( $options['enable_smtp'] != 'true' ) {
				return;
			}

			$admin_options = get_option('easy_fundraisers_general_settings_arraykey');
			$admin_email = ($admin_options['admin_notices_email']);

			$body = esc_html__('A new collection has been created and is available for review.','fpdomain');

			$to = $admin_email;
			$subject = esc_html__('Collection has been created','fpdomain');
			$body = $body;
			$headers = array('Content-Type: text/html; charset=UTF-8');

			wp_mail( $to, $subject, $body, $headers );
		}

		public function easy_fundraisers_send_thanks_email( $post_id, $donator_email, $date, $order_number, $transaction_number, $amount ) {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			$payex_options = get_option( 'easy_fundraisers_payex_settings_arraykey' );
			if ( $options['enable_smtp'] != 'true' ) {
				return;
			}

			$collection_name = get_the_title( $post_id );
			$currency = esc_html($payex_options["payex_currency"]);
			$emailreply = get_post_meta( $post_id, 'easy_fundraisers_email_reply', true );

			$body = $emailreply;
			$body .= "<br>";
			$body .= "<br>" . "<b>" . esc_html__('Receipt', 'fpdomain') . "</b>";
			$body .= "<br>" . esc_html__('Name of fundraiser', 'fpdomain') . ': ' . $collection_name;
			$body .= "<br>" . esc_html__('Amount', 'fpdomain') . ': ' . esc_html($amount) . ' (' . $currency . ')';
			$body .= "<br>" . esc_html__('Date', 'fpdomain') . ': ' . esc_html($date);
			$body .= "<br>" . esc_html__('Order number', 'fpdomain') . ': ' . esc_html($order_number);
			$body .= "<br>" . esc_html__('Transaction number', 'fpdomain') . ': ' . esc_html($transaction_number);
			$body .= "<br>";
			$body .= "<br>" . wp_kses($options['email_reply_general_footer'], $easy_fundraisers_html_tags);

			$to = $donator_email;
			$subject = esc_html__('Thank you for your donation','fpdomain');
			$body = $body;
			$headers = array('Content-Type: text/html; charset=UTF-8');

			wp_mail( $to, $subject, $body, $headers );
		}

		public function easy_fundraisers_send_goal_reached_email( $post_id ) {
			$options = get_option('easy_fundraisers_email_settings_arraykey');
			if ( $options['enable_smtp'] != 'true' ) {
				return;
			}
			$user_id = get_post($post_id)->post_author;
			$user = get_userdata($user_id);
			$email = $user->user_email;

			$collection_name = get_the_title( $post_id );
			$body .= "<br>" . "The goal of your fundraiser " . $collection_name ." has been reached!";
			$body .= "<br>";
			$body .= "<br>" . wp_kses($options['email_reply_general_footer'], $easy_fundraisers_html_tags);

			$to = $email;
			$subject = esc_html__('Fundraiser goal has been reached','fpdomain');
			$body = $body;
			$headers = array('Content-Type: text/html; charset=UTF-8');

			wp_mail( $to, $subject, $body, $headers );
		}
	}
}
?>
