<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

if ( !class_exists( 'easy_fundraisers_meta_boxes' ) ) {

	class easy_fundraisers_meta_boxes {

		public function easy_fundraisers_setup() {
			add_action('add_meta_boxes', array($this, 'easy_fundraisers_add_metabox'));
			add_action('save_post', array($this, 'easy_fundraisers_custom_email_reply_save'));
			add_action('save_post', array($this, 'easy_fundraisers_data_save'));
		}

		public function easy_fundraisers_add_metabox() {
			add_meta_box('easy_fundraisers_metabox_custom_email_reply', esc_html__('Custom e-mail reply', 'fpdomain'), array($this, 'easy_fundraisers_custom_email_reply'), 'collection', 'normal', 'high');
			add_meta_box('easy_fundraisers_metabox_data', esc_html__('Collection data', 'fpdomain'), array($this, 'easy_fundraisers_data'), 'collection', 'side', 'default');
		}

		public function easy_fundraisers_custom_email_reply($post) {
			// Use nonce for verification
			wp_nonce_field( plugin_basename( __FILE__ ), 'easy_fundraisers_email_reply_nonce' );

			$emailReply = get_post_meta($post->ID, 'easy_fundraisers_email_reply', true);
			echo '<textarea id="easy_fundraisers_email_reply" class="wp-editor-area" name="easy_fundraisers_email_reply" cols="100" style="height: 200px;">' . wp_kses($emailReply, $easy_fundraisers_html_tags) . '</textarea>';
		}

		public function easy_fundraisers_custom_email_reply_save($post_id) {
			if ( isset( $_POST['easy_fundraisers_email_reply_nonce'] ) && !wp_verify_nonce( $_POST['easy_fundraisers_email_reply_nonce'], plugin_basename( __FILE__ ) ) ) {
				return;
			}

			if ( !current_user_can( 'edit_page', $post_id ) || !current_user_can( 'edit_post', $post_id )) {
				return;
			}

			if ( get_post_type( $post_id ) != 'collection' ) {
				return;
			}

			if ( isset( $_POST['easy_fundraisers_email_reply'] ) ) {
				$meta = wp_kses($_POST['easy_fundraisers_email_reply'], $easy_fundraisers_html_tags);
				update_post_meta($post_id, 'easy_fundraisers_email_reply', $meta);
			}
		}

		public function easy_fundraisers_data($post) {
			// Use nonce for verification
			wp_nonce_field( plugin_basename( __FILE__ ), 'easy_fundraisers_data_nonce' );
			
			$payex_options = get_option( 'easy_fundraisers_payex_settings_arraykey' );
			$payex_currency = $payex_options["payex_currency"];

			$targetAmount = get_post_meta($post->ID, 'easy_fundraisers_target_amount', true);
			echo '<label for="easy_fundraisers_target_amount">' . esc_html__('Goal amount', 'fpdomain') . ' (' . esc_html($payex_currency) . ')</label>';
			echo '<input type="text" name="easy_fundraisers_target_amount" value="' . esc_html($targetAmount)  . '" class="widefat" /><br /><br />';

			?>

			<div>
			<label for="easy_fundraisers_end_year"><?php echo esc_html__('Finish date', 'fpdomain') . ": "; ?></label>
			<br />
<!-- Print years-->
			<select name="easy_fundraisers_end_year" id="easy_fundraisers_end_year">
<?php
				$options = get_option('collections_settings');
				$options_months = (isset($options["finish_date_limit"]) && !empty($options["finish_date_limit"])) ? esc_html($options["finish_date_limit"]) : 24;
                $endYear = date('Y', strtotime(get_post_meta($post->ID, 'easy_fundraisers_end_date', true)));
				$finishYear = date('Y', strtotime('+' . $options_months . ' months'));

				for ($year = date("Y"); $year <= $finishYear; $year++) {
					if ($endYear == $year) {
						echo '<option value="' . $year . '" selected>' . $year . '</option>';
					} else {
						echo '<option value="' . $year . '">' . $year . '</option>';
					}
				}

?>
			</select>
<!-- Print months -->
			<select name="easy_fundraisers_end_month" id="easy_fundraisers_end_month">
<?php

				$endMonth = date('m', strtotime(get_post_meta($post->ID, 'easy_fundraisers_end_date', true)));

				for ($month = 1; $month <= 12 ; $month++) {
					if ($endMonth == $month) {
						echo '<option value="' . $month . '" selected>' . $month . '</option>';
					} else {
						echo '<option value="' . $month . '">' . $month . '</option>';
					}
				}

?>
			</select>
<!-- Print days -->
			<select name="easy_fundraisers_end_day" id="easy_fundraisers_end_day">
<?php

				$endDay = date('d', strtotime(get_post_meta($post->ID, 'easy_fundraisers_end_date', true)));
				
				for ($day = 1; $day <= 31 ; $day++) {
					if ($endDay == $day) {
						echo '<option value="' . $day . '" selected>' . $day . '</option>';
					} else {
						echo '<option value="' . $day . '">' . $day . '</option>';
					}
				}

?>
			</select>
		</div>

			<?php
		}

		public function easy_fundraisers_data_save($post_id) {
			if ( isset( $_POST['easy_fundraisers_data_nonce'] ) && !wp_verify_nonce( $_POST['easy_fundraisers_data_nonce'], plugin_basename( __FILE__ ) ) ) {
				return;
			}

			if ( !current_user_can( 'edit_page', $post_id ) || !current_user_can( 'edit_post', $post_id ) ) {
				return;
			}

			if ( get_post_type( $post_id ) != 'collection' ) {
				return;
			}

			if ( isset( $_POST['easy_fundraisers_target_amount'] ) ) {
				$targetAmount = sanitize_text_field($_POST['easy_fundraisers_target_amount']);
				update_post_meta($post_id, 'easy_fundraisers_target_amount', $targetAmount);
			}

			if ( isset($_POST['easy_fundraisers_end_year']) && isset($_POST['easy_fundraisers_end_month']) && isset($_POST['easy_fundraisers_end_day'])) {
				$endYear = sanitize_text_field($_POST['easy_fundraisers_end_year']);
				$endMonth = sanitize_text_field($_POST['easy_fundraisers_end_month']);
				$endDay = sanitize_text_field($_POST['easy_fundraisers_end_day']);
				update_post_meta($post_id, 'easy_fundraisers_end_date', $endYear . '-' . $endMonth . '-' . $endDay);
			}
		}

	}

}

?>
