<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
	exit;
}

$easy_fundraisers_html_tags = 
    array(
    'a' => array(
      'href' => array(),
      'title' => array()
    ),
    'br' => array(),
    'b' => array(),
    'i' => array(),
    'em' => array(),
    'strong' => array() 
    );

if ( !class_exists( 'easy_fundraisers_activation' ) ) {

	class easy_fundraisers_activation {

		public function easy_fundraisers_activation_setup() {
            add_action( 'pre_get_posts', array($this,'easy_fundraisers_modify_archive_taxonomy_query'));
			add_action( 'wp_enqueue_scripts', array( $this, 'easy_fundraisers_register_styles' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'easy_fundraisers_register_admin_styles' ) );

			add_action( 'widgets_init', array( $this, 'easy_fundraisers_load_widgets' ), 9 );
			add_action( 'widgets_init', array( $this, 'easy_fundraisers_register_widgets' ), 10 );

			add_action( 'init', array( $this, 'easy_fundraisers_register_user_roles' ) );
			add_action( 'init', array( $this, 'easy_fundraisers_add_shortcodes' ) );

			add_action( 'init', array( $this, 'easy_fundraisers_register_post_types' ) );
			add_action( 'init', array( $this, 'easy_fundraisers_register_taxonomies' ) );

			add_action( 'admin_menu', array( $this, 'easy_fundraisers_add_donations_page' ) );

			add_action( 'admin_menu', array( $this, 'easy_fundraisers_disable_add_collection' ) );
			add_action( 'admin_menu', array( $this, 'easy_fundraisers_add_collections_settings' ) );

			add_action('admin_init', array( $this, 'easy_fundraisers_register_settings' ));

			$this->easy_fundraisers_initMetaBoxes();

			register_activation_hook( __FILE__, array( $this, 'easy_fundraisers_rewriteRules' ) );

			add_filter( 'single_template', array( $this, 'easy_fundraisers_get_collection_post_type_template' ) );
			add_filter( 'archive_template', array( $this, 'easy_fundraisers_get_collection_archive_template' ) );

			$this->easy_fundraisers_initEmails();
		}
        
        public function easy_fundraisers_modify_archive_taxonomy_query( $query ) {
            if ( !is_admin() && $query->is_main_query() ) {
                if ( is_post_type_archive( 'collection' )) {// || is_tax( 'types' ) ) {
                    $query->set( 'posts_per_page', 3 );
                }
            }
        }

		public function easy_fundraisers_register_styles() {
			wp_register_style( 'easyfundrasiersstylesheet', plugins_url( 'public/css/style.css', dirname(__FILE__) ) );
			wp_enqueue_style( 'easyfundrasiersstylesheet' );

			wp_register_script('easyfundrasierscharts', plugins_url( 'public/script/Chart.js', dirname(__FILE__) ) );
			wp_enqueue_script('easyfundrasierscharts');
			//wp_register_script('googlecharts', 'https://www.gstatic.com/charts/loader.js');
			//wp_enqueue_script('googlecharts');
		}

		public function easy_fundraisers_register_admin_styles() {
			wp_register_style( 'easyfundrasiersadminstylesheet', plugins_url( 'admin/css/style.css', dirname(__FILE__) ) );
			wp_enqueue_style( 'easyfundrasiersadminstylesheet' );
		}

		public function easy_fundraisers_load_widgets() {
			include_once( 'widgets/class-easy-fundraisers-list-collections-widget.php' );
		}

		public function easy_fundraisers_register_widgets() {
			if ( !is_blog_installed() ) {
				return;
			}
			register_widget( 'easy_fundraisers_list_collections_widget' );
		}

		public function easy_fundraisers_register_user_roles() {
			global $wp_roles;
			if (!isset($wp_roles)) $wp_roles = new WP_Roles();

			$subscriber_role = $wp_roles->get_role('subscriber');
			$wp_roles->add_role('collector', 'Collector', $subscriber_role->capabilities);
			$wp_roles->get_role('collector')->add_cap('modify_own_collection');
		}

		public function easy_fundraisers_add_shortcodes() {
			include_once( 'class-easy-fundraisers-create-collection.php' );
			$easy_fundraisers_create_collections = new easy_fundraisers_create_collections();
			add_shortcode( 'createcollection', array( $easy_fundraisers_create_collections, 'easy_fundraisers_create_collections_shortcode_print' ) );
			
			include_once( 'class-easy-fundraisers-preview-collection.php' );
			$easy_fundraisers_preview_collections = new easy_fundraisers_preview_collections();
			add_shortcode( 'previewcollection', array( $easy_fundraisers_preview_collections, 'easy_fundraisers_preview_collections_shortcode_print' ) );
			
			add_shortcode( 'collectionarchive', array( $this, 'easy_fundraisers_collection_archive_print' ) );
		}
		
		public function easy_fundraisers_collection_archive_print() {
			include_once(realpath( dirname( __FILE__ ) . '/../public/templates/easy-fundraisers-collection-archive.php' ));
		}

		public function easy_fundraisers_register_post_types() {
			$collection = $this->easy_fundraisers_setup_collection_post_type();
			register_post_type( 'collection', $collection ); // First param is included in URL
		}

		private function easy_fundraisers_setup_collection_post_type() {
			$labels = array(
				'name'               => esc_html(_x( 'Collections', 'Post Type General Name', 'fpdomain' )),
				'singular_name'      => esc_html(_x( 'Collection', 'Post Type Singular Name', 'fpdomain' )),
				'add_new'            => esc_html__( 'Add Collection', 'fpdomain'),
				'add_new_item'       => esc_html__( 'Add Collection', 'fpdomain'),
				'edit_item'          => esc_html__( 'Edit Collection', 'fpdomain'),
				'new_item'           => esc_html__( 'New Collection', 'fpdomain'),
				'all_items'          => esc_html__( 'All Collections', 'fpdomain'),
				'view_item'          => esc_html__( 'Show Collections', 'fpdomain'),
				'search_items'       => esc_html__( 'Search Collections', 'fpdomain'),
				'not_found'          => esc_html__( 'No collections found', 'fpdomain'),
				'not_found_in_trash' => esc_html__( 'No collections found in the trash', 'fpdomain'),
				'parent_item_colon'  => '',
				'menu_name'          => esc_html__('Collections', 'fpdomain'),
			);

			$args = array(
				'labels'          => $labels,
				'description'     => esc_html__('Holds collections and collection specific data', 'fpdomain'),
				'public'          => true,
				//'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments' ),
				'supports'        => array( 'title', 'editor', 'thumbnail' ),
				'has_archive'     => true,
				'show_in_rest'    => true,
				'capability_type' => 'post',
				//'capabilities' => array(
				//	'create_posts' => 'do_not_allow',
				//),
				'map_meta_cap'    => true, // Set to `false`, if users are not allowed to edit/delete existing posts
			);

			return $args;
		}

		public function easy_fundraisers_register_taxonomies() {
			$categories = $this->easy_fundraisers_setup_category_taxonomy();
			register_taxonomy('collectioncategory', 'collection', $categories);
		}

		private function easy_fundraisers_setup_category_taxonomy() {
			$labels = array(
				'name'                       => esc_html(_x( 'Categories', 'taxonomy general name', 'fpdomain' )),
				'singular_name'              => esc_html(_x( 'Category', 'taxonomy singular name', 'fpdomain' )),
				'search_items'               => esc_html__( 'Search Category', 'fpdomain' ),
				'popular_items'              => esc_html__( 'Popular Categories', 'fpdomain' ),
				'all_items'                  => esc_html__( 'All Categories', 'fpdomain' ),
				'parent_item'                => null,
				'parent_item_colon'          => null,
				'edit_item'                  => esc_html__( 'Edit Category', 'fpdomain' ),
				'update_item'                => esc_html__( 'Update Category', 'fpdomain' ),
				'add_new_item'               => esc_html__( 'Add New Category', 'fpdomain' ),
				'new_item_name'              => esc_html__( 'New Category Name', 'fpdomain' ),
				'separate_items_with_commas' => esc_html__( 'Separate categories with commas', 'fpdomain' ),
				'add_or_remove_items'        => esc_html__( 'Add or remove category', 'fpdomain' ),
				'choose_from_most_used'      => esc_html__( 'Choose from the most used category', 'fpdomain' ),
				'not_found'                  => esc_html__( 'No category found.', 'fpdomain' ),
				'menu_name'                  => esc_html__( 'Categories', 'fpdomain' ),
			);

			$args = array(
				'hierarchical'          => false,
				'labels'                => $labels,
				'show_ui'               => true,
				'show_admin_column'     => true,
				'update_count_callback' => '_update_post_term_count',
				'query_var'             => true,
				'rewrite'               => array( 'slug' => 'collectioncategory' ),
			);
			return $args;
		}

		public function easy_fundraisers_add_donations_page() {
			add_submenu_page(
				'edit.php?post_type=collection',
				esc_html__('Donations', 'fpdomain'),
				esc_html__('Donations', 'fpdomain'),
				'manage_options',
				'donations_admin_page',
				array( $this, 'easy_fundraisers_donation_page')
			);
		}

		public function easy_fundraisers_donation_page() {
			include_once( plugin_dir_path( __FILE__ ) . 'admin/easy-fundraisers-donations-page.php' );
		}

		public function easy_fundraisers_disable_add_collection() {
			global $submenu;
			unset( $submenu['edit.php?post_type=collection'][10] );
		}

		public function easy_fundraisers_add_collections_settings() {
			add_submenu_page(
				'edit.php?post_type=collection',
				esc_html__('Collections Settings', 'fpdomain'),
				esc_html__('Settings', 'fpdomain'),
				'manage_options',
				'collections-settings-menu',
				array( $this, 'easy_fundraisers_collections_options' )
			);
		}

		public function easy_fundraisers_collections_options() {
			if ( !current_user_can( 'manage_options' ) )  {
				wp_die( esc_html__( 'You do not have sufficient permissions to access this page.' ) );
			}
			include_once('admin/class-easy-fundraisers-settings.php');
			$easy_fundraisers_settings = new easy_fundraisers_settings();
		}

		function easy_fundraisers_register_settings() {
			include_once( 'admin/class-easy-fundraisers-general-settings.php' );
			$easy_fundraisers_general_settings = new easy_fundraisers_general_settings();
			$easy_fundraisers_general_settings->easy_fundraisers_registerSettings();
            $easy_fundraisers_general_settings->easy_fundraisers_initSettings();
            
			include_once( 'admin/class-easy-fundraisers-payex-settings.php' );
			$easy_fundraisers_sfl_payex_settings = new easy_fundraisers_sfl_payex_settings();
			$easy_fundraisers_sfl_payex_settings->easy_fundraisers_registerSettings();
            $easy_fundraisers_sfl_payex_settings->easy_fundraisers_initSettings();
            
			include_once( 'admin/class-easy-fundraisers-email-settings.php' );
			$easy_fundraisers_email_settings = new easy_fundraisers_email_settings();
			$easy_fundraisers_email_settings->easy_fundraisers_registerSettings();
            $easy_fundraisers_email_settings->easy_fundraisers_initSettings();
            
			include_once( 'admin/class-easy-fundraisers-archive-settings.php' );
			$easy_fundraisers_archive_settings = new easy_fundraisers_archive_settings();
			$easy_fundraisers_archive_settings->easy_fundraisers_registerSettings();
            $easy_fundraisers_archive_settings->easy_fundraisers_initSettings();
            
			include_once( 'admin/class-easy-fundraisers-newcol-settings.php' );
			$easy_fundraisers_newcol_settings = new easy_fundraisers_newcol_settings();
			$easy_fundraisers_newcol_settings->easy_fundraisers_registerSettings();
            $easy_fundraisers_newcol_settings->easy_fundraisers_initSettings();
            
			include_once( 'admin/class-easy-fundraisers-singlecol-settings.php' );
			$easy_fundraisers_singlecol_settings = new easy_fundraisers_singlecol_settings();
			$easy_fundraisers_singlecol_settings->easy_fundraisers_registerSettings();
            $easy_fundraisers_singlecol_settings->easy_fundraisers_initSettings();
            
			include_once( 'admin/class-easy-fundraisers-3colwidget-settings.php' );
			$easy_fundraisers_3colwidget_settings = new easy_fundraisers_3colwidget_settings();
			$easy_fundraisers_3colwidget_settings->easy_fundraisers_registerSettings();
            $easy_fundraisers_3colwidget_settings->easy_fundraisers_initSettings();
		}
        
		public function easy_fundraisers_initMetaBoxes() {
			include_once('class-easy-fundraisers-collection-meta-boxes.php');
			$easy_fundraisers_meta_boxes = new easy_fundraisers_meta_boxes();
			$easy_fundraisers_meta_boxes->easy_fundraisers_setup();
		}

		public function easy_fundraisers_rewriteRules() {
			//$this->register_post_types();
			flush_rewrite_rules(false);
		}

		public function easy_fundraisers_get_collection_post_type_template( $template ) {
			global $post;
			if ( $post->post_type == 'collection' ) {
				$template = realpath( dirname( __FILE__ ) . '/../public/templates/easy-fundraisers-single-collection.php' );
			}
			return $template;
		}

		public function easy_fundraisers_get_collection_archive_template( $archive_template ) {
			if ( is_post_type_archive ( 'collection' ) ) {
				$archive_template = realpath( dirname( __FILE__ ) . '/../public/templates/easy-fundraisers-collection-archive.php' );
			}
			return $archive_template;
		}

		public function easy_fundraisers_initEmails() {
			include_once('class-easy-fundraisers-emails.php');
			$easy_fundraisers_emails = new easy_fundraisers_emails();
			$easy_fundraisers_emails->easy_fundraisers_setup();
		}

	}

}

?>
