<?php
	// Exit if accessed directly
	if (!defined('ABSPATH')) {
		exit;
	}

	global $wpdb;
	$easy_fundraisers_table = $wpdb->prefix . 'donations';
	$easy_fundraisers_query = "SELECT * FROM $easy_fundraisers_table ORDER BY donation_date";
	$easy_fundraisers_donations = $wpdb->get_results( $easy_fundraisers_query );
	
	$easy_fundraisers_payex_options = get_option( 'easy_fundraisers_payex_settings_arraykey' );
	$easy_fundraisers_payex_currency = esc_html($easy_fundraisers_payex_options["payex_currency"]);
?>

<div class="wrap">
	<div class="postbox">
		<div class="inside">
			<h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
			<br />
			<table class="widefat">
				<thead>
					<tr>
						<th>ID</th>
						<th><?php esc_html_e( 'Collection', 'fpdomain' ) ?></th>
						<th><?php esc_html_e( 'Date', 'fpdomain' ) ?></th>
						<th><?php esc_html_e( 'Name', 'fpdomain' ) ?></th>
						<th><?php esc_html_e( 'Email', 'fpdomain' ) ?></th>
						<th><?php echo esc_html__( 'Amount', 'fpdomain' ) . ' (' . $easy_fundraisers_payex_currency . ')'; ?></th>
						<th><?php esc_html_e( 'Status', 'fpdomain' ) ?></th>
						<th><?php esc_html_e( 'Transaction Number', 'fpdomain' ) ?></th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ( $easy_fundraisers_donations as $donation ) { ?>
					<tr>
						<td><?php echo $donation->id; ?></td>
						<td><?php echo $donation->collection_id; ?></td>
						<td><?php echo $donation->donation_date; ?></td>
						<td><?php echo $donation->donor_name; ?></td>
						<td><?php echo $donation->donor_email; ?></td>
						<td><?php echo $donation->donation_amount / 100; ?></td>
						<td><?php echo $donation->donation_status; ?></td>
						<td><?php echo $donation->transaction_number; ?></td>
					</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>
	</div>
</div>
